/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.lib.gui;

import com.feed_the_beast.ftbl.lib.gui.GuiBase;
import com.feed_the_beast.ftbl.lib.gui.GuiHelper;
import com.feed_the_beast.ftbl.lib.gui.Widget;
import com.feed_the_beast.ftbl.lib.gui.WidgetLayout;
import com.feed_the_beast.ftbl.lib.util.misc.MouseButton;
import java.util.ArrayList;
import java.util.List;

public abstract class Panel
extends Widget {
    public static final int ONLY_RENDER_WIDGETS_INSIDE = 1;
    public static final int ONLY_INTERACT_WITH_WIDGETS_INSIDE = 2;
    public static final int DEFAULTS = 3;
    public final List<Widget> widgets = new ArrayList<Widget>();
    private int scrollX = 0;
    private int scrollY = 0;
    private int offsetX = 0;
    private int offsetY = 0;
    private int flags = 0;

    public Panel(GuiBase gui, int x, int y, int w, int h) {
        super(gui, x, y, w, h);
    }

    public Panel(GuiBase gui) {
        this(gui, 0, 0, 0, 0);
    }

    public void addFlags(int f) {
        this.flags |= f;
    }

    public boolean hasFlag(int flag) {
        return (this.flags & flag) != 0;
    }

    public abstract void addWidgets();

    public void refreshWidgets() {
        this.widgets.clear();
        this.addWidgets();
        this.updateWidgetPositions();
    }

    public void add(Widget widget) {
        widget.setParentPanel(this);
        this.widgets.add(widget);
        if (widget instanceof Panel) {
            ((Panel)widget).refreshWidgets();
        }
    }

    public void addAll(Widget ... widgets) {
        for (Widget w : widgets) {
            this.add(w);
        }
    }

    public void addAll(Iterable<? extends Widget> list) {
        for (Widget widget : list) {
            this.add(widget);
        }
    }

    public void updateWidgetPositions() {
    }

    public void setScrollX(double scroll, int elementsWidth) {
        if (elementsWidth < this.width) {
            this.setScrollX(0);
        } else {
            this.setScrollX((int)(scroll * (double)(elementsWidth - this.width)));
        }
    }

    public void setScrollY(double scroll, int elementsHeight) {
        if (elementsHeight < this.height) {
            this.setScrollY(0);
        } else {
            this.setScrollY((int)(scroll * (double)(elementsHeight - this.height)));
        }
    }

    protected final int align(WidgetLayout layout) {
        return layout.align(this);
    }

    @Override
    public int getAX() {
        return super.getAX() + this.offsetX;
    }

    @Override
    public int getAY() {
        return super.getAY() + this.offsetY;
    }

    public void setOffset(boolean flag) {
        if (flag) {
            this.offsetX = -this.scrollX;
            this.offsetY = -this.scrollY;
        } else {
            this.offsetY = 0;
            this.offsetX = 0;
        }
    }

    public boolean isOffset() {
        return this.offsetX != 0 || this.offsetY != 0;
    }

    public void setScrollX(int scroll) {
        this.scrollX = scroll;
    }

    public void setScrollY(int scroll) {
        this.scrollY = scroll;
    }

    @Override
    public void renderWidget() {
        boolean renderInside = this.hasFlag(1);
        this.gui.pushFontUnicode(this.hasFlag(8));
        int ax = this.getAX();
        int ay = this.getAY();
        this.renderPanelBackground(ax, ay);
        if (renderInside) {
            GuiHelper.pushScissor(this.gui.getScreen(), ax, ay, this.width, this.height);
        }
        this.setOffset(true);
        for (int i = 0; i < this.widgets.size(); ++i) {
            Widget widget = this.widgets.get(i);
            if (!widget.shouldRender() || renderInside && !widget.collidesWith(ax, ay, this.width, this.height)) continue;
            this.renderWidget(widget, i, ax + this.offsetX, ay + this.offsetY, this.width, this.height);
        }
        this.setOffset(false);
        if (renderInside) {
            GuiHelper.popScissor(this.gui.getScreen());
        }
        this.gui.popFontUnicode();
    }

    protected void renderPanelBackground(int ax, int ay) {
        this.getIcon().draw(ax, ay, this.width, this.height);
    }

    protected void renderWidget(Widget widget, int index, int ax, int ay, int w, int h) {
        widget.renderWidget();
    }

    @Override
    public void addMouseOverText(List<String> list) {
        if (this.hasFlag(2) && !this.gui.isMouseOver(this)) {
            return;
        }
        this.setOffset(true);
        for (int i = this.widgets.size() - 1; i >= 0; --i) {
            Widget w = this.widgets.get(i);
            if (!w.shouldAddMouseOverText()) continue;
            w.addMouseOverText(list);
        }
        this.setOffset(false);
    }

    @Override
    public boolean mousePressed(MouseButton button) {
        if (this.hasFlag(2) && !this.gui.isMouseOver(this)) {
            return false;
        }
        this.setOffset(true);
        for (int i = this.widgets.size() - 1; i >= 0; --i) {
            Widget w = this.widgets.get(i);
            if (!w.isEnabled() || !w.mousePressed(button)) continue;
            this.setOffset(false);
            return true;
        }
        this.setOffset(false);
        return false;
    }

    @Override
    public void mouseReleased() {
        this.setOffset(true);
        for (int i = this.widgets.size() - 1; i >= 0; --i) {
            Widget w = this.widgets.get(i);
            if (!w.isEnabled()) continue;
            w.mouseReleased();
        }
        this.setOffset(false);
    }

    @Override
    public boolean keyPressed(int key, char keyChar) {
        this.setOffset(true);
        for (int i = this.widgets.size() - 1; i >= 0; --i) {
            Widget w = this.widgets.get(i);
            if (!w.isEnabled() || !w.keyPressed(key, keyChar)) continue;
            this.setOffset(false);
            return true;
        }
        this.setOffset(false);
        return false;
    }
}

