/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.lib.gui;

import com.feed_the_beast.ftbl.lib.gui.GuiBase;
import com.feed_the_beast.ftbl.lib.gui.Panel;
import com.feed_the_beast.ftbl.lib.gui.ScrollBar;

public class PanelScrollBar
extends ScrollBar {
    public final Panel panel;
    private int elementSize = 1;
    private double scrollStep;
    private boolean autoSize;

    public PanelScrollBar(GuiBase gui, int x, int y, int w, int h, int ss, Panel p) {
        super(gui, x, y, w, h, ss);
        this.panel = p;
        this.autoSize = ss <= 0;
    }

    public void setElementSize(int s) {
        this.elementSize = Math.max(1, s);
        if (this.panel.widgets.isEmpty()) {
            this.setScrollStep(0.0);
        } else {
            this.setSrollStepFromOneElementSize(this.elementSize / this.panel.widgets.size());
        }
        if (this.autoSize) {
            this.sliderSize = this.getPlane().isVertical() ? (int)((double)this.height * (double)this.panel.height / (double)this.elementSize) : (int)((double)this.width * (double)this.panel.width / (double)this.elementSize);
        }
    }

    public void setScrollStep(double v) {
        this.scrollStep = v;
    }

    public void setSrollStepFromOneElementSize(int s) {
        this.setScrollStep((double)s / (double)(this.elementSize - (this.getPlane().isVertical() ? this.panel.height : this.panel.width)));
    }

    @Override
    public boolean canMouseScroll() {
        return super.canMouseScroll() || this.gui.isMouseOver(this.panel);
    }

    @Override
    public double getScrollStep() {
        return this.scrollStep;
    }

    @Override
    public void onMoved() {
        if (this.getPlane().isVertical()) {
            this.panel.setScrollY(this.getValue(), this.elementSize);
        } else {
            this.panel.setScrollX(this.getValue(), this.elementSize);
        }
    }

    @Override
    public boolean isEnabled() {
        return this.elementSize > (this.getPlane().isVertical() ? this.panel.height : this.panel.width);
    }

    @Override
    public boolean shouldRender() {
        return this.isEnabled();
    }
}

