/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.lib.gui;

import com.feed_the_beast.ftbl.lib.gui.GuiBase;
import com.feed_the_beast.ftbl.lib.gui.Widget;
import com.feed_the_beast.ftbl.lib.icon.Icon;
import com.feed_the_beast.ftbl.lib.math.MathUtils;
import com.feed_the_beast.ftbl.lib.util.misc.MouseButton;
import java.util.List;
import net.minecraft.util.math.MathHelper;

public class ScrollBar
extends Widget {
    public int sliderSize;
    private double value;
    private int grab = -10000;

    public ScrollBar(GuiBase gui, int x, int y, int w, int h, int ss) {
        super(gui, x, y, w, h);
        this.sliderSize = Math.max(ss, 1);
    }

    @Override
    public boolean mousePressed(MouseButton button) {
        if (this.gui.isMouseOver(this)) {
            this.grab = this.getPlane().isVertical() ? this.gui.getMouseY() - (this.getAY() + this.getValueI(this.height)) : this.gui.getMouseX() - (this.getAX() + this.getValueI(this.width));
            return true;
        }
        return false;
    }

    @Override
    public void addMouseOverText(List<String> list) {
        double max;
        double min = this.getDisplayMin();
        if (min < (max = this.getDisplayMax())) {
            String s = "" + (int)MathUtils.map(this.value, 0.0, 1.0, min, max);
            String t = this.getTitle();
            list.add(t.isEmpty() ? s : t + ": " + s);
        }
    }

    @Override
    public void renderWidget() {
        int ax = this.getAX();
        int ay = this.getAY();
        if (this.isEnabled()) {
            double v;
            double v0 = v = this.getValue();
            if (this.grab != -10000) {
                if (this.gui.isMouseButtonDown(0)) {
                    v = this.getPlane().isVertical() ? (double)(this.gui.getMouseY() - (ay + this.grab)) / (double)(this.height - this.sliderSize) : (double)(this.gui.getMouseX() - (ax + this.grab)) / (double)(this.width - this.sliderSize);
                } else {
                    this.grab = -10000;
                }
            }
            if (this.gui.getMouseWheel() != 0 && this.gui.isShiftDown() != this.getPlane().isVertical() && this.canMouseScroll()) {
                v += this.gui.getMouseWheel() < 0 ? this.getScrollStep() : -this.getScrollStep();
            }
            if (v0 != (v = MathHelper.func_151237_a((double)v, (double)0.0, (double)1.0))) {
                this.setValue(v);
            }
        }
        this.getBackground().draw(ax, ay, this.width, this.height);
        if (this.getPlane().isVertical()) {
            if (this.sliderSize < this.height) {
                this.getIcon().draw(ax, ay + this.getValueI(this.height), this.width, this.sliderSize);
            }
        } else if (this.sliderSize < this.width) {
            this.getIcon().draw(ax + this.getValueI(this.width), ay, this.sliderSize, this.height);
        }
    }

    public Icon getBackground() {
        return this.gui.getTheme().getScrollBarBackground();
    }

    @Override
    public Icon getIcon() {
        return this.gui.getTheme().getScrollBar(this.grab != -10000, this.getPlane().isVertical());
    }

    public void onMoved() {
    }

    public boolean canMouseScroll() {
        return this.gui.isMouseOver(this);
    }

    public void setValue(double v) {
        if (this.value != v) {
            this.value = MathHelper.func_151237_a((double)v, (double)0.0, (double)1.0);
            this.onMoved();
        }
    }

    public double getValue() {
        return this.value;
    }

    public int getValueI(int max) {
        return (int)(this.getValue() * (double)(max - this.sliderSize));
    }

    public double getScrollStep() {
        return 0.1;
    }

    public Plane getPlane() {
        return Plane.VERTICAL;
    }

    public double getDisplayMin() {
        return 0.0;
    }

    public double getDisplayMax() {
        return 0.0;
    }

    public static enum Plane {
        HORIZONTAL,
        VERTICAL;


        public boolean isVertical() {
            return this == VERTICAL;
        }
    }
}

