/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.lib.gui;

import com.feed_the_beast.ftbl.lib.gui.Button;
import com.feed_the_beast.ftbl.lib.gui.GuiBase;
import com.feed_the_beast.ftbl.lib.icon.Icon;
import java.util.List;

public abstract class SimpleTextButton
extends Button {
    public SimpleTextButton(GuiBase gui, int x, int y, String txt, Icon icon) {
        super(gui, x, y, 0, 20, txt, icon);
    }

    @Override
    public SimpleTextButton setTitle(String txt) {
        super.setTitle(txt);
        this.setWidth(this.gui.getStringWidth(this.getTitle()) + (this.getIcon().isEmpty() ? 8 : 28));
        return this;
    }

    public boolean renderTitleInCenter() {
        return false;
    }

    @Override
    public void addMouseOverText(List<String> list) {
    }

    @Override
    public Icon getIcon() {
        return this.icon;
    }

    @Override
    public void renderWidget() {
        int ax = this.getAX();
        int ay = this.getAY();
        this.getButtonBackground().draw(ax, ay, this.width, this.height);
        int off = (this.height - 16) / 2;
        Icon icon = this.getIcon();
        String title = this.getTitle();
        int textX = ax;
        int textY = ay + (this.height - this.gui.getFontHeight() + 1) / 2;
        textX = this.renderTitleInCenter() ? (textX += (this.width - this.gui.getStringWidth(title) - (icon.isEmpty() ? 0 : off + 16)) / 2) : (textX += 4);
        if (!icon.isEmpty()) {
            icon.draw(ax + off, ay + off, 16, 16);
            textX += off + 16;
        }
        this.gui.drawString(title, textX, textY, 2);
    }
}

