/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.lib.gui;

import com.feed_the_beast.ftbl.lib.gui.GuiBase;
import com.feed_the_beast.ftbl.lib.gui.Widget;
import com.feed_the_beast.ftbl.lib.io.Bits;
import com.feed_the_beast.ftbl.lib.util.CommonUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class TextField
extends Widget {
    public List<String> text = Collections.emptyList();
    public int textFlags = 0;
    public boolean autoSizeWidth;
    public boolean autoSizeHeight;

    public TextField(GuiBase gui, int x, int y, int w, int h, String txt, int flags) {
        super(gui, x, y, w, h);
        this.textFlags = flags;
        this.autoSizeWidth = w <= 0;
        this.autoSizeHeight = h <= 0;
        this.setTitle(txt);
    }

    public TextField(GuiBase gui, int x, int y, int w, int h, String txt) {
        this(gui, x, y, w, h, txt, 0);
    }

    public TextField setTitle(String txt) {
        this.text = null;
        this.gui.pushFontUnicode(Bits.getFlag(this.textFlags, 8));
        if (!txt.isEmpty()) {
            this.text = new ArrayList<String>(this.autoSizeWidth ? CommonUtils.asList(txt.split("\n")) : this.gui.listFormattedStringToWidth(txt, this.width));
        }
        if (this.text == null || this.text.isEmpty()) {
            this.text = Collections.emptyList();
        }
        if (this.autoSizeWidth) {
            this.setWidth(0);
            for (String s : this.text) {
                this.setWidth(Math.max(this.width, this.gui.getStringWidth(s)));
            }
        }
        if (this.autoSizeHeight) {
            int h1 = this.gui.getFontHeight() + 1;
            this.setHeight(this.text.isEmpty() ? h1 : h1 * this.text.size());
        }
        this.gui.popFontUnicode();
        return this;
    }

    @Override
    public void addMouseOverText(List<String> list) {
    }

    @Override
    public void renderWidget() {
        int ay = this.getAY();
        int ax = this.getAX();
        this.getIcon().draw(ax, ay, this.width, this.height);
        if (this.text.isEmpty()) {
            return;
        }
        for (int i = 0; i < this.text.size(); ++i) {
            this.gui.drawString(this.text.get(i), ax, ay + i * 10 + 1, this.textFlags);
        }
    }
}

