/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.lib.gui;

import com.feed_the_beast.ftbl.lib.gui.GuiBase;
import com.feed_the_beast.ftbl.lib.gui.Panel;
import com.feed_the_beast.ftbl.lib.icon.Icon;
import com.feed_the_beast.ftbl.lib.util.misc.MouseButton;
import java.util.List;

public class Widget {
    protected static final int DARK = 1;
    protected static final int SHADOW = 2;
    protected static final int CENTERED = 4;
    public static final int UNICODE = 8;
    public GuiBase gui;
    public int posX;
    public int posY;
    public int width;
    public int height;
    private Panel parentPanel;

    public Widget(GuiBase g, int x, int y, int w, int h) {
        this.gui = g;
        this.posX = x;
        this.posY = y;
        this.width = Math.max(w, 0);
        this.height = Math.max(h, 0);
        this.parentPanel = this.gui;
    }

    public void setX(int v) {
        this.posX = v;
    }

    public void setY(int v) {
        this.posY = v;
    }

    public void setWidth(int v) {
        this.width = Math.max(v, 0);
    }

    public void setHeight(int v) {
        this.height = Math.max(v, 0);
    }

    public Panel getParentPanel() {
        return this.parentPanel;
    }

    public void setParentPanel(Panel p) {
        this.parentPanel = p;
    }

    public int getAX() {
        return this.getParentPanel().getAX() + this.posX;
    }

    public int getAY() {
        return this.getParentPanel().getAY() + this.posY;
    }

    public boolean collidesWith(int x, int y, int w, int h) {
        int ay = this.getAY();
        if (ay >= y + h || ay + this.height <= y) {
            return false;
        }
        int ax = this.getAX();
        return ax < x + w && ax + this.width > x;
    }

    public boolean isEnabled() {
        return true;
    }

    public boolean shouldRender() {
        return true;
    }

    public String getTitle() {
        return "";
    }

    public Icon getIcon() {
        return Icon.EMPTY;
    }

    public void addMouseOverText(List<String> list) {
        String title = this.getTitle();
        if (!title.isEmpty()) {
            list.add(title);
        }
    }

    public boolean shouldAddMouseOverText() {
        return this.isEnabled() && this.gui.isMouseOver(this);
    }

    public void renderWidget() {
        this.getIcon().draw(this);
    }

    public boolean mousePressed(MouseButton button) {
        return false;
    }

    public void mouseReleased() {
    }

    public boolean keyPressed(int key, char keyChar) {
        return false;
    }
}

