/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.lib.gui.misc;

import com.feed_the_beast.ftbl.lib.gui.GuiBase;
import com.feed_the_beast.ftbl.lib.gui.Panel;
import com.feed_the_beast.ftbl.lib.gui.PanelScrollBar;
import com.feed_the_beast.ftbl.lib.gui.Widget;
import com.feed_the_beast.ftbl.lib.gui.WidgetLayout;
import com.feed_the_beast.ftbl.lib.icon.Icon;

public abstract class GuiButtonListBase
extends GuiBase {
    private final Panel panelButtons = new Panel(this.gui, 9, 9, 0, 146){

        @Override
        public void addWidgets() {
            this.width = 0;
            GuiButtonListBase.this.addButtons(this);
            for (Widget w : this.widgets) {
                this.setWidth(Math.max(this.width, w.width));
            }
            for (Widget w : this.widgets) {
                w.setWidth(this.width);
            }
            this.updateWidgetPositions();
        }

        @Override
        public void updateWidgetPositions() {
            int size = this.align(WidgetLayout.VERTICAL);
            GuiButtonListBase.this.scrollBar.setElementSize(size);
            GuiButtonListBase.this.scrollBar.setSrollStepFromOneElementSize(20);
            this.setHeight(this.widgets.size() > 7 ? 144 : size);
            this.gui.setHeight(this.height + 18);
        }

        @Override
        public Icon getIcon() {
            return this.gui.getTheme().getPanelBackground();
        }
    };
    private final PanelScrollBar scrollBar;
    private String title = "";

    public GuiButtonListBase() {
        super(0, 0);
        this.panelButtons.addFlags(3);
        this.scrollBar = new PanelScrollBar(this, 0, 8, 16, 146, 0, this.panelButtons){

            @Override
            public boolean shouldRender() {
                return true;
            }

            @Override
            public boolean canMouseScroll() {
                return true;
            }
        };
    }

    @Override
    public void addWidgets() {
        this.add(this.panelButtons);
        if (this.panelButtons.widgets.size() > 7) {
            this.add(this.scrollBar);
        }
        this.scrollBar.setX(this.panelButtons.posX + this.panelButtons.width + 6);
        this.setWidth(this.scrollBar.posX + (this.panelButtons.widgets.size() > 7 ? this.scrollBar.width + 8 : 4));
        this.posX = (this.getScreen().func_78326_a() - this.width) / 2;
    }

    public abstract void addButtons(Panel var1);

    public void setTitle(String txt) {
        this.title = txt;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public void drawBackground() {
        String title = this.getTitle();
        if (!title.isEmpty()) {
            this.drawString(title, this.getAX() + (this.width - this.gui.getStringWidth(title)) / 2, this.getAY() - this.getFontHeight() - 2, 2);
        }
    }
}

