/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.lib.gui.misc;

import com.feed_the_beast.ftbl.lib.client.CachedVertexData;
import com.feed_the_beast.ftbl.lib.client.ClientUtils;
import com.feed_the_beast.ftbl.lib.gui.Button;
import com.feed_the_beast.ftbl.lib.gui.GuiBase;
import com.feed_the_beast.ftbl.lib.gui.GuiHelper;
import com.feed_the_beast.ftbl.lib.gui.Panel;
import com.feed_the_beast.ftbl.lib.gui.WidgetLayout;
import com.feed_the_beast.ftbl.lib.gui.misc.ChunkSelectorMap;
import com.feed_the_beast.ftbl.lib.icon.Color4I;
import com.feed_the_beast.ftbl.lib.icon.Icon;
import com.feed_the_beast.ftbl.lib.math.MathUtils;
import com.feed_the_beast.ftbl.lib.util.misc.MouseButton;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.math.ChunkPos;
import org.lwjgl.input.Keyboard;

public class GuiChunkSelectorBase
extends GuiBase {
    public static final int TILE_SIZE = 12;
    private static final CachedVertexData GRID = new CachedVertexData(1, DefaultVertexFormats.field_181706_f);
    public final int startX;
    public final int startZ;
    private final MapButton[] mapButtons;
    private final Panel panelButtons;
    public int currentSelectionMode = -1;

    public GuiChunkSelectorBase() {
        super(180, 180);
        this.startX = MathUtils.chunk(ClientUtils.MC.field_71439_g.field_70165_t) - 7;
        this.startZ = MathUtils.chunk(ClientUtils.MC.field_71439_g.field_70161_v) - 7;
        this.panelButtons = new Panel(this, 0, 0, 16, 0){

            @Override
            public void addWidgets() {
                GuiChunkSelectorBase.this.addCornerButtons(GuiChunkSelectorBase.this.panelButtons);
                this.updateWidgetPositions();
            }

            @Override
            public void updateWidgetPositions() {
                this.align(WidgetLayout.VERTICAL);
            }
        };
        this.mapButtons = new MapButton[225];
        for (int i = 0; i < this.mapButtons.length; ++i) {
            this.mapButtons[i] = new MapButton(this, 0, 0, i);
        }
    }

    @Override
    public void onInit() {
        ChunkSelectorMap.getMap().resetMap(this.startX, this.startZ);
    }

    @Override
    public void addWidgets() {
        for (MapButton b : this.mapButtons) {
            this.add(b);
        }
        this.add(this.panelButtons);
        this.panelButtons.posX = this.getScreen().func_78326_a() - 20 - this.getAX();
        this.panelButtons.posY = -this.getAY();
        this.panelButtons.setHeight(this.panelButtons.widgets.size() * 20);
    }

    @Override
    public void drawBackground() {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Color4I.BLACK.draw(this.posX - 2, this.posY - 2, this.width + 4, this.height + 4);
        ChunkSelectorMap.getMap().drawMap(this, this.posX, this.posY, this.startX, this.startZ);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        for (MapButton mapButton : this.mapButtons) {
            mapButton.renderWidget();
        }
        GlStateManager.func_179090_x();
        GlStateManager.func_187441_d((float)1.0f);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_178969_c((double)this.mapButtons[0].getAX(), (double)this.mapButtons[0].getAY(), 0.0);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (!Keyboard.isKeyDown((int)15)) {
            this.drawArea(tessellator, buffer);
        }
        GRID.draw(tessellator, buffer);
        buffer.func_178969_c(0.0, 0.0, 0.0);
        GlStateManager.func_179098_w();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    @Override
    public void mouseReleased() {
        super.mouseReleased();
        if (this.currentSelectionMode != -1) {
            ArrayList<ChunkPos> c = new ArrayList<ChunkPos>();
            for (MapButton b : this.mapButtons) {
                if (!b.isSelected) continue;
                c.add(b.chunkPos);
                b.isSelected = false;
            }
            this.onChunksSelected(c);
            this.currentSelectionMode = -1;
        }
    }

    @Override
    public void drawForeground() {
        int i;
        int lineSpacing = this.getFontHeight() + 1;
        this.addCornerText(TEMP_TEXT_LIST, Corner.BOTTOM_RIGHT);
        for (i = 0; i < TEMP_TEXT_LIST.size(); ++i) {
            String s = (String)TEMP_TEXT_LIST.get(i);
            this.drawString(s, this.getScreen().func_78326_a() - this.getStringWidth(s) - 2, this.getScreen().func_78328_b() - (TEMP_TEXT_LIST.size() - i) * lineSpacing, 2);
        }
        TEMP_TEXT_LIST.clear();
        this.addCornerText(TEMP_TEXT_LIST, Corner.BOTTOM_LEFT);
        for (i = 0; i < TEMP_TEXT_LIST.size(); ++i) {
            this.drawString((String)TEMP_TEXT_LIST.get(i), 2, this.getScreen().func_78328_b() - (TEMP_TEXT_LIST.size() - i) * lineSpacing, 2);
        }
        TEMP_TEXT_LIST.clear();
        this.addCornerText(TEMP_TEXT_LIST, Corner.TOP_LEFT);
        for (i = 0; i < TEMP_TEXT_LIST.size(); ++i) {
            this.drawString((String)TEMP_TEXT_LIST.get(i), 2, 2 + i * lineSpacing, 2);
        }
        TEMP_TEXT_LIST.clear();
        super.drawForeground();
    }

    public int getSelectionMode(MouseButton button) {
        return -1;
    }

    public void onChunksSelected(Collection<ChunkPos> chunks) {
    }

    public void drawArea(Tessellator tessellator, BufferBuilder buffer) {
    }

    public void addCornerButtons(Panel panel) {
    }

    public void addCornerText(List<String> list, Corner corner) {
    }

    public void addButtonText(MapButton button, List<String> list) {
    }

    @Override
    public Icon getIcon() {
        return Icon.EMPTY;
    }

    static {
        GuiChunkSelectorBase.GRID.color.set(128, 128, 128, 50);
        for (int x = 0; x <= 15; ++x) {
            GRID.pos(x * 12, 0.0);
            GRID.pos(x * 12, 180.0, 0.0);
        }
        for (int y = 0; y <= 15; ++y) {
            GRID.pos(0.0, y * 12, 0.0);
            GRID.pos(180.0, y * 12, 0.0);
        }
    }

    public static class MapButton
    extends Button {
        public final GuiChunkSelectorBase gui;
        public final ChunkPos chunkPos;
        public final int index;
        private boolean isSelected = false;

        private MapButton(GuiChunkSelectorBase g, int x, int y, int i) {
            super(g, x, y, 12, 12);
            this.gui = g;
            this.posX += i % 15 * this.width;
            this.posY += i / 15 * this.height;
            this.chunkPos = new ChunkPos(this.gui.startX + i % 15, this.gui.startZ + i / 15);
            this.index = i;
        }

        @Override
        public void onClicked(MouseButton button) {
            GuiHelper.playClickSound();
            this.gui.currentSelectionMode = this.gui.getSelectionMode(button);
            if (this.gui.currentSelectionMode == -1) {
                this.gui.onChunksSelected(Collections.singleton(this.chunkPos));
            }
        }

        @Override
        public void addMouseOverText(List<String> list) {
            this.gui.addButtonText(this, list);
        }

        @Override
        public void renderWidget() {
            int ax = this.getAX();
            int ay = this.getAY();
            if (!this.isSelected && this.gui.currentSelectionMode != -1 && this.gui.isMouseOver(this)) {
                this.isSelected = true;
            }
            if (this.isSelected || this.gui.isMouseOver(this)) {
                Color4I.WHITE_A[33].draw(ax, ay, 12, 12);
            }
        }
    }

    protected static enum Corner {
        BOTTOM_LEFT,
        BOTTOM_RIGHT,
        TOP_LEFT;

    }
}

