/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.lib.gui.misc;

import com.feed_the_beast.ftbl.lib.config.ConfigValue;
import com.feed_the_beast.ftbl.lib.gui.Button;
import com.feed_the_beast.ftbl.lib.gui.GuiBase;
import com.feed_the_beast.ftbl.lib.gui.GuiHelper;
import com.feed_the_beast.ftbl.lib.gui.GuiLang;
import com.feed_the_beast.ftbl.lib.gui.SimpleTextButton;
import com.feed_the_beast.ftbl.lib.gui.TextBox;
import com.feed_the_beast.ftbl.lib.gui.misc.IGuiFieldCallback;
import com.feed_the_beast.ftbl.lib.icon.Icon;
import com.feed_the_beast.ftbl.lib.util.misc.MouseButton;

public class GuiConfigValueField
extends GuiBase {
    private final ConfigValue defValue;
    private final ConfigValue value;
    private final IGuiFieldCallback callback;
    private final Button buttonCancel;
    private final Button buttonAccept;
    private final TextBox textBox;

    GuiConfigValueField(ConfigValue val, IGuiFieldCallback c) {
        super(200, 54);
        this.defValue = val.copy();
        this.value = val.copy();
        this.callback = c;
        int bsize = this.width / 2 - 10;
        this.buttonCancel = new SimpleTextButton(this, 8, this.height - 24, GuiLang.CANCEL.translate(), Icon.EMPTY){

            @Override
            public void onClicked(MouseButton button) {
                GuiHelper.playClickSound();
                GuiConfigValueField.this.callback.onCallback(GuiConfigValueField.this.defValue, false);
            }

            @Override
            public boolean renderTitleInCenter() {
                return true;
            }
        };
        this.buttonCancel.setWidth(bsize);
        this.buttonCancel.setHeight(16);
        this.buttonAccept = new SimpleTextButton(this, this.width - bsize - 8, this.height - 24, GuiLang.ACCEPT.translate(), Icon.EMPTY){

            @Override
            public void onClicked(MouseButton button) {
                GuiHelper.playClickSound();
                if (GuiConfigValueField.this.value.setValueFromString(GuiConfigValueField.this.textBox.getText(), false)) {
                    GuiConfigValueField.this.callback.onCallback(GuiConfigValueField.this.value, true);
                }
            }

            @Override
            public boolean renderTitleInCenter() {
                return true;
            }
        };
        this.buttonAccept.setWidth(bsize);
        this.buttonAccept.setHeight(16);
        this.textBox = new TextBox(this, 8, 8, this.width - 16, 16){

            @Override
            public boolean isValid(String txt) {
                return GuiConfigValueField.this.value.setValueFromString(txt, true);
            }

            @Override
            public void onTextChanged() {
                ((GuiConfigValueField)GuiConfigValueField.this).textBox.textColor = GuiConfigValueField.this.value.getColor();
            }

            @Override
            public void onEnterPressed() {
                GuiConfigValueField.this.buttonAccept.onClicked(MouseButton.LEFT);
            }
        };
        this.textBox.writeText(val.toString());
        this.textBox.setFocused(true);
    }

    @Override
    public void addWidgets() {
        this.add(this.buttonCancel);
        this.add(this.buttonAccept);
        this.add(this.textBox);
    }
}

