/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.lib.icon;

import com.feed_the_beast.ftbl.lib.gui.GuiHelper;
import com.feed_the_beast.ftbl.lib.icon.Icon;
import com.feed_the_beast.ftbl.lib.icon.MutableColor4I;
import com.feed_the_beast.ftbl.lib.math.MathUtils;
import com.feed_the_beast.ftbl.lib.util.ColorUtils;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class Color4I
extends Icon {
    public static final Color4I[] BLACK_A = new Color4I[256];
    public static final Color4I[] WHITE_A = new Color4I[256];
    public static final Color4I BLACK;
    public static final Color4I DARK_GRAY;
    public static final Color4I GRAY;
    public static final Color4I WHITE;
    public static final Color4I RED;
    public static final Color4I GREEN;
    public static final Color4I BLUE;
    public static final Color4I LIGHT_RED;
    public static final Color4I LIGHT_GREEN;
    public static final Color4I LIGHT_BLUE;
    int red = 255;
    int green = 255;
    int blue = 255;
    int alpha = 255;
    int rgba = -1;

    public static Color4I fromJson(@Nullable JsonElement element) {
        JsonArray array;
        if (element == null || element.isJsonNull()) {
            return Icon.EMPTY;
        }
        if (element.isJsonPrimitive()) {
            String s = element.getAsString();
            if (s.equals("-")) {
                return Icon.EMPTY;
            }
            String hex = s.substring(1);
            return hex.length() == 8 ? Color4I.rgba((int)Long.parseLong(hex, 16)) : Color4I.rgb((int)Long.parseLong(hex, 16));
        }
        if (element.isJsonArray() && (array = element.getAsJsonArray()).size() >= 3) {
            int r = array.get(0).getAsInt();
            int g = array.get(1).getAsInt();
            int b = array.get(2).getAsInt();
            int a = 255;
            if (array.size() >= 3) {
                a = array.get(3).getAsInt();
            }
            return Color4I.rgba(r, g, b, a);
        }
        JsonObject object = element.getAsJsonObject();
        if (object.has("red") && object.has("green") && object.has("blue")) {
            int r = object.get("red").getAsInt();
            int g = object.get("green").getAsInt();
            int b = object.get("blue").getAsInt();
            int a = 255;
            if (object.has("alpha")) {
                a = object.get("alpha").getAsInt();
            }
            return Color4I.rgba(r, g, b, a);
        }
        return Icon.EMPTY;
    }

    public static Color4I rgba(int r, int g, int b, int a) {
        if (a <= 0) {
            return EMPTY;
        }
        if (a >= 255 && r >= 255 && g >= 255 && b >= 255) {
            return WHITE;
        }
        return new Color4I(r, g, b, a);
    }

    public static Color4I rgb(int r, int g, int b) {
        return Color4I.rgba(r, g, b, 255);
    }

    public static Color4I rgba(int col) {
        return Color4I.rgba(ColorUtils.getRed(col), ColorUtils.getGreen(col), ColorUtils.getBlue(col), ColorUtils.getAlpha(col));
    }

    public static Color4I rgb(int col) {
        return Color4I.rgb(ColorUtils.getRed(col), ColorUtils.getGreen(col), ColorUtils.getBlue(col));
    }

    Color4I(int r, int g, int b, int a) {
        this.red = r;
        this.green = g;
        this.blue = b;
        this.alpha = a;
        this.rgba = ColorUtils.getRGBA(this.red, this.green, this.blue, this.alpha);
    }

    public Color4I copy() {
        return Color4I.rgba(this.red, this.green, this.blue, this.alpha);
    }

    public boolean isMutable() {
        return false;
    }

    public MutableColor4I mutable() {
        return new MutableColor4I(this.red, this.green, this.blue, this.alpha);
    }

    public Color4I whiteIfEmpty() {
        return this.isEmpty() ? WHITE : this;
    }

    public int redi() {
        return this.red;
    }

    public int greeni() {
        return this.green;
    }

    public int bluei() {
        return this.blue;
    }

    public int alphai() {
        return this.alpha;
    }

    public float redf() {
        return (float)this.red / 255.0f;
    }

    public float greenf() {
        return (float)this.green / 255.0f;
    }

    public float bluef() {
        return (float)this.blue / 255.0f;
    }

    public float alphaf() {
        return (float)this.alpha / 255.0f;
    }

    public int rgba() {
        return this.rgba;
    }

    public int hashCode() {
        return this.rgba();
    }

    public boolean equals(Object o) {
        return o == this || o != null && o.hashCode() == this.rgba();
    }

    public String toString() {
        return ColorUtils.getHex(this.rgba());
    }

    @Override
    public JsonElement getJson() {
        return this.isEmpty() ? JsonNull.INSTANCE : new JsonPrimitive(this.toString());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void draw(int x, int y, int w, int h, Color4I col) {
        if (w <= 0 || h <= 0) {
            return;
        }
        if (col.isEmpty()) {
            col = this;
        }
        if (col.isEmpty()) {
            return;
        }
        GlStateManager.func_179090_x();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        GuiHelper.addRectToBuffer(buffer, x, y, w, h, col);
        tessellator.func_78381_a();
        GlStateManager.func_179098_w();
    }

    @Override
    public Color4I withTint(Color4I col) {
        if (this.isEmpty() || col == WHITE) {
            return this;
        }
        float r0 = this.redf();
        float g0 = this.greenf();
        float b0 = this.bluef();
        float a0 = this.alphaf();
        float r1 = col.redf();
        float g1 = col.greenf();
        float b1 = col.bluef();
        float a1 = col.alphaf();
        float r = MathUtils.lerp(r0, r0 * r1, a1);
        float g = MathUtils.lerp(g0, g0 * g1, a1);
        float b = MathUtils.lerp(b0, b0 * b1, a1);
        return Color4I.rgba((int)(r * 255.0f), (int)(g * 255.0f), (int)(b * 255.0f), (int)(a0 * 255.0f));
    }

    public Color4I withAlpha(int a) {
        return this.alpha == a ? this : Color4I.rgba(this.red, this.green, this.blue, a);
    }

    public final Color4I withAlphaf(float alpha) {
        return this.withAlpha((int)(alpha * 255.0f));
    }

    static {
        for (int i = 0; i < 256; ++i) {
            Color4I.BLACK_A[i] = new Color4I(0, 0, 0, i){

                @Override
                public Color4I withAlpha(int a) {
                    return this.alpha == a ? this : BLACK_A[MathHelper.func_76125_a((int)a, (int)0, (int)255)];
                }
            };
            Color4I.WHITE_A[i] = new Color4I(255, 255, 255, i){

                @Override
                public Color4I withAlpha(int a) {
                    return this.alpha == a ? this : WHITE_A[MathHelper.func_76125_a((int)a, (int)0, (int)255)];
                }
            };
        }
        BLACK = BLACK_A[255];
        DARK_GRAY = Color4I.rgb(0x212121);
        GRAY = Color4I.rgb(0x999999);
        WHITE = WHITE_A[255];
        RED = Color4I.rgb(0xFF0000);
        GREEN = Color4I.rgb(65280);
        BLUE = Color4I.rgb(255);
        LIGHT_RED = Color4I.rgb(0xFF5656);
        LIGHT_GREEN = Color4I.rgb(0x56FF56);
        LIGHT_BLUE = Color4I.rgb(0x5656FF);
    }
}

