/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.lib.icon;

import com.feed_the_beast.ftbl.lib.client.ClientUtils;
import com.feed_the_beast.ftbl.lib.gui.Widget;
import com.feed_the_beast.ftbl.lib.icon.AtlasSpriteIcon;
import com.feed_the_beast.ftbl.lib.icon.BulletIcon;
import com.feed_the_beast.ftbl.lib.icon.Color4I;
import com.feed_the_beast.ftbl.lib.icon.CombinedIcon;
import com.feed_the_beast.ftbl.lib.icon.IconAnimation;
import com.feed_the_beast.ftbl.lib.icon.IconPresets;
import com.feed_the_beast.ftbl.lib.icon.IconWithBorder;
import com.feed_the_beast.ftbl.lib.icon.IconWithOutline;
import com.feed_the_beast.ftbl.lib.icon.IconWithTint;
import com.feed_the_beast.ftbl.lib.icon.ImageIcon;
import com.feed_the_beast.ftbl.lib.icon.ItemIcon;
import com.feed_the_beast.ftbl.lib.icon.LoadingIcon;
import com.feed_the_beast.ftbl.lib.icon.MutableColor4I;
import com.feed_the_beast.ftbl.lib.icon.URLImageIcon;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class Icon {
    public static final Color4I EMPTY = new Color4I(255, 255, 255, 255){

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void draw(int x, int y, int w, int h, Color4I col) {
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void draw(Widget widget, Color4I col) {
        }

        @Override
        public MutableColor4I mutable() {
            return new MutableColor4I.None();
        }
    };

    public static Icon getIcon(JsonElement json) {
        if (json.isJsonNull()) {
            return EMPTY;
        }
        if (json.isJsonObject()) {
            JsonObject o = json.getAsJsonObject();
            if (o.has("id")) {
                switch (o.get("id").getAsString()) {
                    case "loading": {
                        return LoadingIcon.INSTANCE;
                    }
                    case "color": {
                        Color4I color = Color4I.fromJson(o.get("color"));
                        return o.has("mutable") && o.get("mutable").getAsBoolean() ? color.mutable() : color;
                    }
                    case "border": {
                        return Icon.getIcon(o.get("parent")).withBorder(o.has("border") ? o.get("border").getAsInt() : 0);
                    }
                    case "tint": {
                        return Icon.getIcon(o.get("parent")).withTint(Color4I.fromJson(o.get("color")));
                    }
                    case "animation": {
                        ArrayList<Icon> icons = new ArrayList<Icon>();
                        for (JsonElement e : o.get("icons").getAsJsonArray()) {
                            icons.add(Icon.getIcon(e));
                        }
                        IconAnimation list = new IconAnimation(icons);
                        if (o.has("timer")) {
                            list.timer = o.get("timer").getAsLong();
                        }
                        return list;
                    }
                    case "outline": {
                        Icon icon = EMPTY;
                        Color4I outline = EMPTY;
                        boolean roundEdges = false;
                        if (o.has("icon")) {
                            icon = Icon.getIcon(o.get("icon"));
                        }
                        if (o.has("color")) {
                            outline = Color4I.fromJson(o.get("color"));
                        }
                        if (o.has("round_edges")) {
                            roundEdges = o.get("round_edges").getAsBoolean();
                        }
                        return icon.withOutline(outline, roundEdges);
                    }
                    case "bullet": {
                        return new BulletIcon().setColor(o.has("color") ? Color4I.fromJson(o.get("color")) : EMPTY);
                    }
                }
            }
        } else if (json.isJsonArray()) {
            ArrayList<Icon> list = new ArrayList<Icon>();
            for (JsonElement e : json.getAsJsonArray()) {
                list.add(Icon.getIcon(e));
            }
            return CombinedIcon.getCombined(list);
        }
        String s = json.getAsString();
        if (s.isEmpty()) {
            return EMPTY;
        }
        Icon icon = IconPresets.MAP.get(s);
        return icon == null ? Icon.getIcon(s) : icon;
    }

    public static Icon getIcon(String id) {
        if (id.isEmpty()) {
            return EMPTY;
        }
        if (id.charAt(0) == '#') {
            return Color4I.fromJson((JsonElement)new JsonPrimitive(id));
        }
        if (id.equals("loading")) {
            return LoadingIcon.INSTANCE;
        }
        if (id.startsWith("item:")) {
            return ItemIcon.getItemIcon(id.substring(5));
        }
        if (id.startsWith("http:") || id.startsWith("https:")) {
            return new URLImageIcon(id, 0.0, 0.0, 1.0, 1.0);
        }
        if (!id.endsWith(".png")) {
            return new AtlasSpriteIcon(new ResourceLocation(id));
        }
        return new ImageIcon(id, 0.0, 0.0, 1.0, 1.0);
    }

    public boolean isEmpty() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public ITextureObject bindTexture() {
        return ClientUtils.bindTexture(ImageIcon.MISSING_IMAGE);
    }

    @SideOnly(value=Side.CLIENT)
    public abstract void draw(int var1, int var2, int var3, int var4, Color4I var5);

    @SideOnly(value=Side.CLIENT)
    public final void draw(int x, int y, int w, int h) {
        this.draw(x, y, w, h, EMPTY);
    }

    @SideOnly(value=Side.CLIENT)
    public void draw(Widget widget, Color4I col) {
        this.draw(widget.getAX(), widget.getAY(), widget.width, widget.height, col);
    }

    @SideOnly(value=Side.CLIENT)
    public final void draw(Widget widget) {
        this.draw(widget, EMPTY);
    }

    public JsonElement getJson() {
        return JsonNull.INSTANCE;
    }

    public Icon withUV(double u0, double v0, double u1, double v1) {
        return this;
    }

    public Icon withUVfromCoords(int x, int y, int w, int h, int tw, int th) {
        return this.withUV((double)x / (double)tw, (double)y / (double)th, (double)(x + w) / (double)tw, (double)(y + h) / (double)th);
    }

    public final Icon combineWith(Icon icon) {
        if (icon.isEmpty()) {
            return this;
        }
        if (this.isEmpty()) {
            return icon;
        }
        return new CombinedIcon(this, icon);
    }

    public final Icon combineWith(Icon ... icons) {
        if (icons.length == 0) {
            return this;
        }
        if (icons.length == 1) {
            if (this.isEmpty()) {
                return icons[0];
            }
            if (icons[0].isEmpty()) {
                return this;
            }
            return new CombinedIcon(this, icons[0]);
        }
        ArrayList<Icon> list = new ArrayList<Icon>(icons.length + 1);
        list.add(this);
        for (Icon i : icons) {
            list.add(i);
        }
        return CombinedIcon.getCombined(list);
    }

    public final Icon withOutline(Color4I color, boolean roundEdges) {
        if (color.isEmpty()) {
            return this.withBorder(1);
        }
        return new IconWithOutline(this, color, roundEdges);
    }

    public final Icon withBorder(int border) {
        return border == 0 ? this : new IconWithBorder(this, border);
    }

    public Icon withTint(Color4I color) {
        return this.isEmpty() || color == Color4I.WHITE ? this : new IconWithTint(this, color);
    }
}

