/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.lib.icon;

import com.feed_the_beast.ftbl.lib.icon.Color4I;
import com.feed_the_beast.ftbl.lib.icon.Icon;
import com.feed_the_beast.ftbl.lib.icon.ItemIcon;
import com.feed_the_beast.ftbl.lib.math.MathUtils;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;

public class IconAnimation
extends Icon {
    public final List<Icon> list;
    private Icon current = Icon.EMPTY;
    public long timer = 1000L;

    public static Icon fromIngredient(Ingredient ingredient) {
        ArrayList<Icon> icons = new ArrayList<Icon>();
        for (ItemStack stack : ingredient.func_193365_a()) {
            if (stack.func_190926_b()) continue;
            icons.add(ItemIcon.getItemIcon(stack));
        }
        return icons.isEmpty() ? EMPTY : (icons.size() == 1 ? (Icon)icons.get(0) : new IconAnimation(icons));
    }

    public IconAnimation(Collection<Icon> l) {
        this.list = new ArrayList<Icon>(l.size());
        for (Icon o : l) {
            if (o.isEmpty()) continue;
            this.list.add(o);
        }
        if (!this.list.isEmpty()) {
            this.current = this.list.get(0);
        }
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    public int getItemCount() {
        return this.list.size();
    }

    public Icon getObject(int index) {
        if (index < 0 || index >= this.list.size()) {
            return this.current;
        }
        return this.list.get(index);
    }

    public void setIndex(int i) {
        this.current = this.list.get(MathUtils.wrap(i, this.list.size()));
    }

    @Override
    public void draw(int x, int y, int w, int h, Color4I col) {
        if (this.current != null) {
            this.current.draw(x, y, w, h, col);
        }
        if (!this.list.isEmpty()) {
            this.setIndex((int)(System.currentTimeMillis() / this.timer));
        }
    }

    @Override
    public JsonElement getJson() {
        JsonObject json = new JsonObject();
        json.addProperty("id", "animation");
        if (this.timer != 1000L) {
            json.addProperty("timer", (Number)this.timer);
        }
        JsonArray array = new JsonArray();
        for (Icon o : this.list) {
            array.add(o.getJson());
        }
        json.add("icons", (JsonElement)array);
        return json;
    }
}

