/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.lib.icon;

import com.feed_the_beast.ftbl.lib.client.ClientUtils;
import com.feed_the_beast.ftbl.lib.gui.GuiHelper;
import com.feed_the_beast.ftbl.lib.icon.Color4I;
import com.feed_the_beast.ftbl.lib.icon.Icon;
import com.feed_the_beast.ftbl.lib.internal.FTBLibFinals;
import com.google.common.base.Objects;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ImageIcon
extends Icon {
    public static final ResourceLocation MISSING_IMAGE = FTBLibFinals.get("textures/gui/missing_image.png");
    public final ResourceLocation texture;
    public final double minU;
    public final double minV;
    public final double maxU;
    public final double maxV;

    ImageIcon(String tex, double u0, double v0, double u1, double v1) {
        this.texture = new ResourceLocation(tex);
        this.minU = Math.min(u0, u1);
        this.minV = Math.min(v0, v1);
        this.maxU = Math.max(u0, u1);
        this.maxV = Math.max(v0, v1);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ITextureObject bindTexture() {
        return ClientUtils.bindTexture(this.texture);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void draw(int x, int y, int w, int h, Color4I col) {
        this.bindTexture();
        GuiHelper.drawTexturedRect(x, y, w, h, col.whiteIfEmpty(), this.minU, this.minV, this.maxU, this.maxV);
    }

    @Override
    public JsonElement getJson() {
        return new JsonPrimitive(this.texture.toString());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ImageIcon) {
            ImageIcon img = (ImageIcon)o;
            return this.texture.equals((Object)img.texture) && this.minU == img.minU && this.minV == img.minV && this.maxU == img.maxU && this.maxV == img.maxV;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.texture, this.minU, this.minV, this.maxU, this.maxV});
    }

    public String toString() {
        return Double.toString(this.minU) + ',' + this.minV + ',' + this.maxU + ',' + this.maxV;
    }

    @Override
    public Icon withUV(double u0, double v0, double u1, double v1) {
        return new ImageIcon(this.texture.toString(), u0, v0, u1, v1);
    }
}

