/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.lib.icon;

import com.feed_the_beast.ftbl.lib.gui.GuiHelper;
import com.feed_the_beast.ftbl.lib.icon.Color4I;
import com.feed_the_beast.ftbl.lib.icon.Icon;
import com.feed_the_beast.ftbl.lib.item.ItemStackSerializer;
import com.feed_the_beast.ftbl.lib.util.InvUtils;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import net.minecraft.item.ItemStack;

public class ItemIcon
extends Icon {
    ItemStack stack;

    public static Icon getItemIcon(ItemStack stack) {
        return stack.func_190926_b() ? EMPTY : new ItemIcon(stack);
    }

    public static Icon getItemIcon(String lazyStackString) {
        return lazyStackString.isEmpty() ? EMPTY : new LazyItemIcon(lazyStackString);
    }

    private ItemIcon(ItemStack is) {
        this.stack = is;
    }

    public ItemStack getStack() {
        return this.stack;
    }

    @Override
    public void draw(int x, int y, int w, int h, Color4I col) {
        if (!GuiHelper.drawItem(this.getStack(), x, y, (double)w / 16.0, (double)h / 16.0, true, col)) {
            this.stack = InvUtils.ERROR_ITEM;
        }
    }

    @Override
    public JsonElement getJson() {
        return new JsonPrimitive("item:" + ItemStackSerializer.toString(this.getStack()));
    }

    private static class LazyItemIcon
    extends ItemIcon {
        private String lazyStackString;
        private boolean createdStack;

        private LazyItemIcon(String s) {
            super(ItemStack.field_190927_a);
            this.lazyStackString = s;
        }

        @Override
        public ItemStack getStack() {
            if (!this.createdStack) {
                this.stack = ItemStackSerializer.parseItem(this.lazyStackString);
                this.createdStack = true;
            }
            return this.stack;
        }

        @Override
        public JsonElement getJson() {
            return new JsonPrimitive("item:" + this.lazyStackString);
        }
    }
}

