/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.lib.io;

import com.feed_the_beast.ftbl.lib.icon.Icon;
import com.feed_the_beast.ftbl.lib.math.BlockDimPos;
import com.feed_the_beast.ftbl.lib.util.JsonUtils;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.mojang.authlib.GameProfile;
import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.ints.Int2ObjectLinkedOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fml.common.network.ByteBufUtils;

public class DataOut {
    public static Serializer<String> STRING = DataOut::writeString;
    public static Serializer<Integer> INT = DataOut::writeInt;
    public static Serializer<Boolean> BOOLEAN = DataOut::writeBoolean;
    public static Serializer<UUID> UUID = DataOut::writeUUID;
    public static Serializer<BlockPos> BLOCK_POS = DataOut::writePos;
    public static Serializer<BlockDimPos> BLOCK_DIM_POS = DataOut::writeDimPos;
    public static Serializer<JsonElement> JSON = DataOut::writeJson;
    public static Serializer<ITextComponent> TEXT_COMPONENT = DataOut::writeTextComponent;
    public static Serializer<ResourceLocation> RESOURCE_LOCATION = DataOut::writeResourceLocation;
    public static final Serializer<ChunkPos> CHUNK_POS = (data, pos) -> {
        data.writeInt(pos.field_77276_a);
        data.writeInt(pos.field_77275_b);
    };
    private final ByteBuf byteBuf;

    public DataOut(ByteBuf io) {
        this.byteBuf = io;
    }

    public void writeBoolean(boolean value) {
        this.byteBuf.writeBoolean(value);
    }

    public void writeByte(int value) {
        this.byteBuf.writeByte(value);
    }

    public void writeBytes(byte[] bytes, int off, int len) {
        this.byteBuf.writeBytes(bytes, off, len);
    }

    public void writeBytes(byte[] bytes) {
        this.writeBytes(bytes, 0, bytes.length);
    }

    public void writeShort(int value) {
        this.byteBuf.writeShort(value);
    }

    public void writeInt(int value) {
        this.byteBuf.writeInt(value);
    }

    public void writeLong(long value) {
        this.byteBuf.writeLong(value);
    }

    public void writeFloat(float value) {
        this.byteBuf.writeFloat(value);
    }

    public void writeDouble(double value) {
        this.byteBuf.writeDouble(value);
    }

    public void writePos(Vec3i pos) {
        this.writeInt(pos.func_177958_n());
        this.writeInt(pos.func_177956_o());
        this.writeInt(pos.func_177952_p());
    }

    public void writeDimPos(BlockDimPos pos) {
        this.writeInt(pos.dim);
        this.writeInt(pos.posX);
        this.writeInt(pos.posY);
        this.writeInt(pos.posZ);
    }

    public void writeUUID(UUID id) {
        this.writeLong(id.getMostSignificantBits());
        this.writeLong(id.getLeastSignificantBits());
    }

    public void writeString(String string) {
        ByteBufUtils.writeUTF8String((ByteBuf)this.byteBuf, (String)string);
    }

    public <T> void writeCollection(Collection<T> collection, Serializer<T> serializer) {
        int size = collection.size();
        if (size == 0) {
            this.writeByte(6);
            return;
        }
        boolean set = collection instanceof Set;
        if (size >= 65536) {
            this.writeByte(set ? 5 : 2);
            this.writeInt(size);
        } else if (size >= 256) {
            this.writeByte(set ? 4 : 1);
            this.writeShort(size);
        } else {
            this.writeByte(set ? 3 : 0);
            this.writeByte(size);
        }
        for (T object : collection) {
            serializer.write(this, object);
        }
    }

    public <K, V> void writeMap(Map<K, V> map, Serializer<K> keySerializer, Serializer<V> valueSerializer) {
        boolean linked;
        int size = map.size();
        if (size == 0) {
            this.writeByte(6);
            return;
        }
        boolean bl = linked = map instanceof LinkedHashMap || map instanceof Int2ObjectLinkedOpenHashMap;
        if (size >= 65536) {
            this.writeByte(linked ? 5 : 2);
            this.writeInt(size);
        } else if (size >= 256) {
            this.writeByte(linked ? 4 : 1);
            this.writeShort(size);
        } else {
            this.writeByte(linked ? 3 : 0);
            this.writeByte(size);
        }
        for (Map.Entry<K, V> entry : map.entrySet()) {
            keySerializer.write(this, entry.getKey());
            valueSerializer.write(this, entry.getValue());
        }
    }

    public void writeItemStack(ItemStack stack) {
        ByteBufUtils.writeItemStack((ByteBuf)this.byteBuf, (ItemStack)stack);
    }

    public void writeNBT(@Nullable NBTTagCompound nbt) {
        ByteBufUtils.writeTag((ByteBuf)this.byteBuf, (NBTTagCompound)nbt);
    }

    public void writeResourceLocation(ResourceLocation r) {
        this.writeString(r.toString());
    }

    public void writeJson(@Nullable JsonElement element) {
        if (element == null || element.isJsonNull()) {
            this.writeByte(0);
        } else if (element.isJsonObject()) {
            this.writeByte(1);
            Set set = element.getAsJsonObject().entrySet();
            LinkedHashMap map = new LinkedHashMap(set.size());
            for (Map.Entry entry : set) {
                map.put(entry.getKey(), entry.getValue());
            }
            this.writeMap(map, STRING, JSON);
        } else if (element.isJsonArray()) {
            this.writeByte(2);
            JsonArray json = element.getAsJsonArray();
            ArrayList<JsonElement> collection = new ArrayList<JsonElement>(json.size());
            for (JsonElement json1 : json) {
                collection.add(json1);
            }
            this.writeCollection(collection, JSON);
        } else {
            JsonPrimitive primitive = element.getAsJsonPrimitive();
            if (primitive.isString()) {
                this.writeByte(3);
                this.writeString(primitive.getAsString());
            } else if (primitive.isBoolean()) {
                this.writeByte(4);
                this.writeBoolean(primitive.getAsBoolean());
            } else {
                Class<?> n = primitive.getAsNumber().getClass();
                if (n == Integer.class) {
                    this.writeByte(7);
                    this.writeInt(primitive.getAsInt());
                } else if (n == Byte.class) {
                    this.writeByte(5);
                    this.writeByte(primitive.getAsByte());
                } else if (n == Short.class) {
                    this.writeByte(6);
                    this.writeShort(primitive.getAsShort());
                } else if (n == Long.class) {
                    this.writeByte(8);
                    this.writeLong(primitive.getAsLong());
                } else if (n == Float.class) {
                    this.writeByte(9);
                    this.writeFloat(primitive.getAsFloat());
                } else if (n == Double.class) {
                    this.writeByte(10);
                    this.writeDouble(primitive.getAsDouble());
                } else {
                    this.writeByte(0);
                }
            }
        }
    }

    public void writeTextComponent(@Nullable ITextComponent component) {
        this.writeJson(JsonUtils.serializeTextComponent(component));
    }

    public void writeProfile(GameProfile profile) {
        this.writeUUID(profile.getId());
        this.writeString(profile.getName());
    }

    public void writeBlockState(IBlockState state) {
        this.writeInt(state == Blocks.field_150350_a.func_176223_P() ? 0 : Block.func_176210_f((IBlockState)state));
    }

    public void writeIcon(@Nullable Icon icon) {
        this.writeJson((icon == null ? Icon.EMPTY : icon).getJson());
    }

    public <E> void write(Serializer<E> serializer, E object) {
        serializer.write(this, object);
    }

    public static interface Serializer<T> {
        public void write(DataOut var1, T var2);
    }
}

