/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.lib.item;

import com.feed_the_beast.ftbl.lib.item.ItemEntry;
import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntComparators;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.Comparator;
import java.util.HashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.util.RecipeItemHelper;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.crafting.IIngredientFactory;
import net.minecraftforge.common.crafting.JsonContext;
import net.minecraftforge.oredict.OreDictionary;

public class FTBLibOreIngredient
extends Ingredient {
    private NonNullList<ItemStack> ores;
    private IntList itemIds = null;
    private ItemStack[] array = null;
    private int lastSizeA = -1;
    private int lastSizeL = -1;

    public FTBLibOreIngredient(String ore) {
        super(0);
        if (ore.isEmpty()) {
            this.ores = NonNullList.func_191196_a();
        } else if (ore.endsWith("*")) {
            this.ores = NonNullList.func_191196_a();
            HashMap<ItemEntry, ItemStack> map = new HashMap<ItemEntry, ItemStack>();
            ore = ore.substring(0, ore.length() - 1);
            for (String ore1 : OreDictionary.getOreNames()) {
                if (!ore1.startsWith(ore)) continue;
                for (ItemStack stack : OreDictionary.getOres((String)ore1)) {
                    ItemEntry entry = ItemEntry.get(stack);
                    if (entry.isEmpty()) continue;
                    map.put(entry, stack);
                }
            }
            this.ores.addAll(map.values());
        } else {
            this.ores = OreDictionary.getOres((String)ore);
        }
    }

    @Nonnull
    public ItemStack[] func_193365_a() {
        if (this.array == null || this.lastSizeA != this.ores.size()) {
            NonNullList lst = NonNullList.func_191196_a();
            for (ItemStack itemstack : this.ores) {
                if (itemstack.func_77960_j() == Short.MAX_VALUE) {
                    itemstack.func_77973_b().func_150895_a(CreativeTabs.field_78027_g, lst);
                    continue;
                }
                lst.add((Object)itemstack);
            }
            this.array = (ItemStack[])lst.toArray((Object[])new ItemStack[lst.size()]);
            this.lastSizeA = this.ores.size();
        }
        return this.array;
    }

    @Nonnull
    public IntList func_194139_b() {
        if (this.itemIds == null || this.lastSizeL != this.ores.size()) {
            this.itemIds = new IntArrayList(this.ores.size());
            for (ItemStack itemstack : this.ores) {
                if (itemstack.func_77960_j() == Short.MAX_VALUE) {
                    NonNullList lst = NonNullList.func_191196_a();
                    itemstack.func_77973_b().func_150895_a(CreativeTabs.field_78027_g, lst);
                    for (ItemStack item : lst) {
                        this.itemIds.add(RecipeItemHelper.func_194113_b((ItemStack)item));
                    }
                    continue;
                }
                this.itemIds.add(RecipeItemHelper.func_194113_b((ItemStack)itemstack));
            }
            this.itemIds.sort((Comparator)IntComparators.NATURAL_COMPARATOR);
            this.lastSizeL = this.ores.size();
        }
        return this.itemIds;
    }

    public boolean apply(@Nullable ItemStack input) {
        if (input == null) {
            return false;
        }
        for (ItemStack target : this.ores) {
            if (!OreDictionary.itemMatches((ItemStack)target, (ItemStack)input, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    protected void invalidate() {
        this.itemIds = null;
        this.array = null;
    }

    public static class Factory
    implements IIngredientFactory {
        @Nonnull
        public Ingredient parse(JsonContext context, JsonObject json) {
            return new FTBLibOreIngredient(JsonUtils.func_151200_h((JsonObject)json, (String)"ore"));
        }
    }
}

