/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.lib.item;

import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonPrimitive;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;

public class ItemStackSerializer {
    public static ItemStack parseItem(String input) {
        String[] s1;
        if ((input = input.trim()).isEmpty() || input.equals("-")) {
            return ItemStack.field_190927_a;
        }
        if (input.startsWith("{") && input.endsWith("}")) {
            try {
                ItemStack stack = new ItemStack(JsonToNBT.func_180713_a((String)input));
                if (!stack.func_190926_b()) {
                    return stack;
                }
            }
            catch (NBTException e) {
                e.printStackTrace();
            }
        }
        if ((s1 = input.split(" ", 4)).length == 0) {
            return ItemStack.field_190927_a;
        }
        Item item = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(s1[0]));
        if (item == null) {
            return ItemStack.field_190927_a;
        }
        int stackSize = 1;
        int meta = 0;
        if (s1.length >= 2) {
            stackSize = MathHelper.func_82715_a((String)s1[1], (int)1);
        }
        if (s1.length >= 3) {
            meta = s1[2].charAt(0) == '*' ? Short.MAX_VALUE : MathHelper.func_82715_a((String)s1[2], (int)0);
        }
        ItemStack itemstack = new ItemStack(item, stackSize, meta);
        if (s1.length >= 4) {
            try {
                itemstack.func_77982_d(JsonToNBT.func_180713_a((String)s1[3]));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return itemstack;
    }

    public static String toString(ItemStack is) {
        if (is.func_190926_b()) {
            return "-";
        }
        StringBuilder builder = new StringBuilder(String.valueOf(Item.field_150901_e.func_177774_c((Object)is.func_77973_b())));
        int count = is.func_190916_E();
        int meta = is.func_77960_j();
        NBTTagCompound tag = is.func_77978_p();
        if (count > 1 || meta != 0 || tag != null) {
            builder.append(' ');
            builder.append(count);
        }
        if (meta != 0 || tag != null) {
            builder.append(' ');
            builder.append(meta);
        }
        if (tag != null) {
            builder.append(' ');
            builder.append(tag);
        }
        return builder.toString();
    }

    public static JsonElement serialize(ItemStack is) {
        String s = ItemStackSerializer.toString(is);
        return s.isEmpty() ? JsonNull.INSTANCE : new JsonPrimitive(s);
    }

    public static ItemStack deserialize(JsonElement e) {
        if (e.isJsonNull()) {
            return ItemStack.field_190927_a;
        }
        if (e.isJsonPrimitive()) {
            return ItemStackSerializer.parseItem(e.getAsString());
        }
        try {
            return new ItemStack(JsonToNBT.func_180713_a((String)e.toString()));
        }
        catch (Exception ex) {
            return ItemStack.field_190927_a;
        }
    }
}

