/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.lib.tile;

import com.feed_the_beast.ftbl.lib.math.BlockDimPos;
import com.feed_the_beast.ftbl.lib.tile.EnumSaveType;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IWorldNameable;

public abstract class TileBase
extends TileEntity
implements IWorldNameable {
    private boolean isDirty = true;
    private IBlockState currentState;
    public boolean destroyedByCreativePlayer = false;

    protected abstract void writeData(NBTTagCompound var1, EnumSaveType var2);

    protected abstract void readData(NBTTagCompound var1, EnumSaveType var2);

    public String func_70005_c_() {
        return this.func_145748_c_().func_150254_d();
    }

    public boolean func_145818_k_() {
        return false;
    }

    @Nonnull
    public ITextComponent func_145748_c_() {
        return new TextComponentTranslation(this.func_145838_q().func_149739_a() + ".name", new Object[0]);
    }

    public final NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        nbt = super.func_189515_b(nbt);
        this.writeData(nbt, EnumSaveType.SAVE);
        return nbt;
    }

    public final void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.readData(nbt, EnumSaveType.SAVE);
    }

    @Nullable
    public final SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound nbt = super.func_189515_b(new NBTTagCompound());
        this.writeData(nbt, EnumSaveType.NET_UPDATE);
        nbt.func_82580_o("id");
        nbt.func_82580_o("x");
        nbt.func_82580_o("y");
        nbt.func_82580_o("z");
        return nbt.func_82582_d() ? null : new SPacketUpdateTileEntity(this.field_174879_c, 0, nbt);
    }

    public final void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.readData(pkt.func_148857_g(), EnumSaveType.NET_UPDATE);
        this.onUpdatePacket(EnumSaveType.NET_UPDATE);
    }

    public final NBTTagCompound func_189517_E_() {
        NBTTagCompound nbt = super.func_189517_E_();
        this.writeData(nbt, EnumSaveType.NET_FULL);
        nbt.func_82580_o("id");
        return nbt;
    }

    public final void handleUpdateTag(NBTTagCompound tag) {
        this.readData(tag, EnumSaveType.NET_FULL);
        this.onUpdatePacket(EnumSaveType.NET_FULL);
    }

    public void onUpdatePacket(EnumSaveType type) {
        this.func_70296_d();
    }

    protected boolean notifyBlock() {
        return true;
    }

    public boolean updateComparator() {
        return false;
    }

    public void onLoad() {
        this.isDirty = true;
    }

    public void func_70296_d() {
        this.isDirty = true;
    }

    public boolean shouldDrop() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.writeData(nbt, EnumSaveType.SAVE);
        return !nbt.func_82582_d();
    }

    public final void checkIfDirty() {
        if (this.isDirty) {
            this.sendDirtyUpdate();
            this.isDirty = false;
        }
    }

    public final Block func_145838_q() {
        return this.getBlockState().func_177230_c();
    }

    public final int func_145832_p() {
        return this.getBlockState().func_177230_c().func_176201_c(this.getBlockState());
    }

    protected void sendDirtyUpdate() {
        this.func_145836_u();
        if (this.field_145850_b != null) {
            this.field_145850_b.func_175646_b(this.field_174879_c, (TileEntity)this);
            if (this.notifyBlock()) {
                this.field_145850_b.func_184138_a(this.field_174879_c, this.getBlockState(), this.getBlockState(), 255);
            }
            if (this.updateComparator() && this.func_145838_q() != Blocks.field_150350_a) {
                this.field_145850_b.func_175666_e(this.field_174879_c, this.func_145838_q());
            }
        }
    }

    public void func_145836_u() {
        super.func_145836_u();
        this.currentState = null;
    }

    public IBlockState createState(IBlockState state) {
        return state;
    }

    public IBlockState getBlockState() {
        if (this.currentState == null) {
            if (this.field_145850_b == null) {
                return Blocks.field_150350_a.func_176223_P();
            }
            this.currentState = this.createState(this.field_145850_b.func_180495_p(this.func_174877_v()));
        }
        return this.currentState;
    }

    public final boolean isServerSide() {
        return this.field_145850_b != null && !this.field_145850_b.field_72995_K;
    }

    public void notifyNeighbors() {
        this.field_145850_b.func_175685_c(this.func_174877_v(), this.func_145838_q(), false);
    }

    public void playSound(SoundEvent event, SoundCategory category, float volume, float pitch) {
        this.field_145850_b.func_184148_a(null, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, event, category, volume, pitch);
    }

    public BlockDimPos getDimPos() {
        return new BlockDimPos((Vec3i)this.field_174879_c, this.func_145830_o() ? this.field_145850_b.field_73011_w.getDimension() : 0);
    }

    public NBTTagCompound createItemData() {
        NBTTagCompound nbt = new NBTTagCompound();
        NBTTagCompound nbt1 = new NBTTagCompound();
        this.writeData(nbt1, EnumSaveType.SAVE);
        if (!nbt1.func_82582_d()) {
            nbt.func_74782_a("BlockEntityTag", (NBTBase)nbt1);
        }
        return nbt;
    }
}

