/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.lib.util;

import com.feed_the_beast.ftbl.lib.util.UtilsCommon;
import com.google.common.base.Optional;
import com.google.gson.JsonElement;
import java.io.File;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.JsonContext;
import net.minecraftforge.fml.common.Loader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CommonUtils {
    public static final boolean DEV_ENV = (Boolean)Launch.blackboard.get("fml.deobfuscatedEnvironment");
    public static final Logger DEV_LOGGER = LogManager.getLogger((String)"FTBLibDev");
    public static boolean isNEILoaded = false;
    public static File folderConfig;
    public static File folderMinecraft;
    public static File folderLocal;
    public static File folderWorld;
    public static final Comparator<Package> PACKAGE_COMPARATOR;
    private static final Predicate<Object> PREDICATE_ALWAYS_TRUE;
    public static final Object[] NO_OBJECTS;
    public static final JsonContext MINECRAFT_JSON_CONTEXT;
    public static final long TICKS_SECOND = 20L;
    public static final long TICKS_MINUTE = 1200L;
    public static final long TICKS_HOUR = 72000L;
    public static final char[] HEX;

    public static <T> T cast(@Nullable Object o) {
        return (T)o;
    }

    public static <T> Predicate<T> alwaysTruePredicate() {
        return (Predicate)CommonUtils.cast(PREDICATE_ALWAYS_TRUE);
    }

    @SafeVarargs
    public static <T> List<T> asList(T ... objects) {
        return objects == null || objects.length == 0 ? Collections.emptyList() : Arrays.asList(objects);
    }

    public static boolean isNEILoaded() {
        return isNEILoaded;
    }

    public static void init(File configFolder) {
        folderConfig = configFolder;
        folderMinecraft = folderConfig.getParentFile();
        folderLocal = new File(folderMinecraft, "local/");
        if (!folderLocal.exists()) {
            folderLocal.mkdirs();
        }
        isNEILoaded = Loader.isModLoaded((String)"nei");
    }

    public static <E> Map<String, E> getObjects(@Nullable Class<E> type, Class<?> fields, @Nullable Object obj, boolean immutable) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Field f : fields.getDeclaredFields()) {
            f.setAccessible(true);
            if (type != null && !type.isAssignableFrom(f.getType())) continue;
            try {
                map.put(f.getName(), f.get(obj));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return immutable ? Collections.unmodifiableMap(map) : map;
    }

    public static String getNameFromState(IBlockState state) {
        if (state == Blocks.field_150350_a.func_176223_P()) {
            return "minecraft:air";
        }
        StringBuilder builder = new StringBuilder();
        builder.append(Block.field_149771_c.func_177774_c((Object)state.func_177230_c()));
        if (state != state.func_177230_c().func_176223_P() && !state.func_177228_b().isEmpty()) {
            builder.append('[');
            boolean first = true;
            for (Map.Entry entry : state.func_177228_b().entrySet()) {
                if (first) {
                    first = false;
                } else {
                    builder.append(',');
                }
                builder.append(((IProperty)entry.getKey()).func_177701_a());
                builder.append('=');
                builder.append(((IProperty)entry.getKey()).func_177702_a((Comparable)CommonUtils.cast(entry.getValue())));
            }
            builder.append(']');
        }
        return builder.toString();
    }

    public static IBlockState getStateFromName(String name, IBlockState def) {
        if (name.isEmpty()) {
            return def;
        }
        int p = name.indexOf(91);
        String stateName = p == -1 ? name : name.substring(0, p);
        IBlockState state = ((Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(stateName))).func_176223_P();
        if (state == Blocks.field_150350_a.func_176223_P()) {
            return def;
        }
        if (p >= 0) {
            for (String property : name.substring(p + 1, name.length() - 1).split(",")) {
                Optional propValue;
                String[] p1 = property.split("=", 2);
                IProperty property1 = state.func_177230_c().func_176194_O().func_185920_a(p1[0]);
                if (property1 == null || !(propValue = property1.func_185929_b(p1[1])).isPresent()) continue;
                state = state.func_177226_a(property1, (Comparable)CommonUtils.cast(propValue.get()));
            }
        }
        return state;
    }

    public static IBlockState getStateFromName(String name) {
        return CommonUtils.getStateFromName(name, Blocks.field_150350_a.func_176223_P());
    }

    public static boolean isOneOf(Object original, Object ... objects) {
        for (Object o : objects) {
            if (!Objects.equals(original, o)) continue;
            return true;
        }
        return false;
    }

    public static Ingredient getIngredient(@Nullable JsonElement element) {
        if (element == null || element.isJsonNull() || element.isJsonArray() && element.getAsJsonArray().size() == 0) {
            return Ingredient.field_193370_a;
        }
        return CraftingHelper.getIngredient((JsonElement)element, (JsonContext)MINECRAFT_JSON_CONTEXT);
    }

    public static long getWorldTime() {
        return UtilsCommon.INSTANCE.getWorldTime();
    }

    static {
        PACKAGE_COMPARATOR = (o1, o2) -> o1.getName().compareToIgnoreCase(o2.getName());
        PREDICATE_ALWAYS_TRUE = object -> true;
        NO_OBJECTS = new Object[0];
        MINECRAFT_JSON_CONTEXT = new JsonContext("minecraft");
        HEX = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    }
}

