/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.lib.util;

import com.feed_the_beast.ftbl.api.ATHelper;
import com.feed_the_beast.ftbl.lib.internal.FTBLibFinals;
import com.feed_the_beast.ftbl.lib.item.ToolLevel;
import com.feed_the_beast.ftbl.lib.item.ToolType;
import java.lang.reflect.Method;
import java.util.Objects;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;

public class InvUtils {
    private static Boolean baublesLoaded = null;
    private static Method baublesMethod = null;
    public static final ItemStack ERROR_ITEM = new ItemStack(Blocks.field_180401_cv);

    @Nullable
    public static NBTTagCompound nullIfEmpty(@Nullable NBTTagCompound nbt) {
        return nbt == null || nbt.func_82582_d() ? null : nbt;
    }

    public static void addPlayerSlots(Container container, EntityPlayer player, int posX, int posY, boolean ignoreCurrent) {
        int x;
        if (player.field_71071_by == null) {
            return;
        }
        for (int y = 0; y < 3; ++y) {
            for (x = 0; x < 9; ++x) {
                ATHelper.INSTANCE.addSlot(container, new Slot((IInventory)player.field_71071_by, x + y * 9 + 9, posX + x * 18, posY + y * 18));
            }
        }
        int i = ignoreCurrent ? player.field_71071_by.field_70461_c : -1;
        for (x = 0; x < 9; ++x) {
            if (x != i) {
                ATHelper.INSTANCE.addSlot(container, new Slot((IInventory)player.field_71071_by, x, posX + x * 18, posY + 58));
                continue;
            }
            ATHelper.INSTANCE.addSlot(container, new Slot((IInventory)player.field_71071_by, x, posX + x * 18, posY + 58){

                public boolean func_82869_a(EntityPlayer ep) {
                    return false;
                }
            });
        }
    }

    public static ItemStack transferStackInSlot(Container container, int index, int nonPlayerSlots) {
        if (nonPlayerSlots <= 0) {
            return ItemStack.field_190927_a;
        }
        ItemStack is = ItemStack.field_190927_a;
        Slot slot = (Slot)container.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack is1 = slot.func_75211_c();
            is = is1.func_77946_l();
            if (index < nonPlayerSlots ? !ATHelper.INSTANCE.mergeItemStack(container, is1, nonPlayerSlots, container.field_75151_b.size(), true) : !ATHelper.INSTANCE.mergeItemStack(container, is1, 0, nonPlayerSlots, false)) {
                return ItemStack.field_190927_a;
            }
            if (is1.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
        }
        return is;
    }

    public static ItemStack getAndSplit(IItemHandlerModifiable itemHandler, int index, int amount) {
        if (index >= 0 && index < itemHandler.getSlots() && !itemHandler.getStackInSlot(index).func_190926_b() && amount > 0) {
            ItemStack itemstack = itemHandler.getStackInSlot(index).func_77979_a(amount);
            if (itemHandler.getStackInSlot(index).func_190926_b()) {
                itemHandler.setStackInSlot(index, ItemStack.field_190927_a);
            }
            return itemstack;
        }
        return ItemStack.field_190927_a;
    }

    public static ItemStack getAndRemove(IItemHandlerModifiable itemHandler, int index) {
        ItemStack itemStack = itemHandler.getStackInSlot(index);
        itemHandler.setStackInSlot(index, ItemStack.field_190927_a);
        return itemStack;
    }

    public static void clear(IItemHandlerModifiable itemHandler) {
        for (int i = 0; i < itemHandler.getSlots(); ++i) {
            itemHandler.setStackInSlot(i, ItemStack.field_190927_a);
        }
    }

    public static void dropItem(World w, double x, double y, double z, double mx, double my, double mz, ItemStack item, int delay) {
        if (!item.func_190926_b()) {
            EntityItem ei = new EntityItem(w, x, y, z, item.func_77946_l());
            ei.field_70159_w = mx;
            ei.field_70181_x = my;
            ei.field_70179_y = mz;
            ei.func_174867_a(delay);
            w.func_72838_d((Entity)ei);
        }
    }

    public static void dropItem(World w, double x, double y, double z, ItemStack item, int delay) {
        InvUtils.dropItem(w, x, y, z, w.field_73012_v.nextGaussian() * (double)0.07f, w.field_73012_v.nextFloat() * 0.05f, w.field_73012_v.nextGaussian() * (double)0.07f, item, delay);
    }

    public static void dropItem(World w, BlockPos pos, ItemStack item, int delay) {
        InvUtils.dropItem(w, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, item, delay);
    }

    public static void dropItem(Entity e, ItemStack item) {
        InvUtils.dropItem(e.field_70170_p, e.field_70165_t, e.field_70163_u, e.field_70161_v, item, 0);
    }

    public static void giveItem(EntityPlayer ep, ItemStack item) {
        if (!item.func_190926_b()) {
            if (ep.field_71071_by.func_70441_a(item)) {
                ep.field_71071_by.func_70296_d();
                if (ep.field_71070_bA != null) {
                    ep.field_71070_bA.func_75142_b();
                }
            } else {
                InvUtils.dropItem((Entity)ep, item);
            }
        }
    }

    public static void dropAllItems(World world, double x, double y, double z, Iterable<ItemStack> items) {
        if (!world.field_72995_K) {
            for (ItemStack item : items) {
                if (item.func_190926_b()) continue;
                InvUtils.dropItem(world, x, y, z, item, 10);
            }
        }
    }

    public static void dropAllItems(World world, double x, double y, double z, @Nullable IItemHandler itemHandler) {
        if (!world.field_72995_K && itemHandler != null && itemHandler.getSlots() > 0) {
            for (int i = 0; i < itemHandler.getSlots(); ++i) {
                ItemStack item = itemHandler.getStackInSlot(i);
                if (item.func_190926_b()) continue;
                InvUtils.dropItem(world, x, y, z, item, 10);
            }
        }
    }

    public static boolean isWrench(ItemStack is) {
        return !is.func_190926_b() && is.func_77973_b().getHarvestLevel(is, ToolType.WRENCH.func_176610_l(), null, null) >= ToolLevel.BASIC.ordinal();
    }

    public static void transferItems(IItemHandler from, IItemHandler to, int amount, Predicate<ItemStack> filter) {
        if (amount <= 0) {
            return;
        }
        for (int i = 0; i < from.getSlots(); ++i) {
            ItemStack extracted = from.extractItem(i, amount, true);
            if (extracted.func_190926_b() || !filter.test(extracted)) continue;
            ItemStack inserted = ItemHandlerHelper.insertItem((IItemHandler)to, (ItemStack)extracted, (boolean)false);
            int s = extracted.func_190916_E() - inserted.func_190916_E();
            if (s <= 0) continue;
            from.extractItem(i, s, false);
            if ((amount -= s) > 0) continue;
            return;
        }
    }

    @Nullable
    public static IInventory getBaubles(EntityPlayer player) {
        if (baublesLoaded == null) {
            baublesLoaded = Loader.isModLoaded((String)"Baubles") || Loader.isModLoaded((String)"baubles");
        }
        if (!baublesLoaded.booleanValue()) {
            return null;
        }
        IInventory ot = null;
        try {
            if (baublesMethod == null) {
                Class<?> fake = Class.forName("baubles.common.lib.PlayerHandler");
                baublesMethod = fake.getMethod("getPlayerBaubles", EntityPlayer.class);
            }
            ot = (IInventory)baublesMethod.invoke(null, player);
        }
        catch (Exception ex) {
            FTBLibFinals.LOGGER.warn("[Baubles API] Could not invoke baubles.common.lib.PlayerHandler method getPlayerBaubles");
        }
        return ot;
    }

    public static void writeItemHandler(NBTTagCompound nbt, String key, IItemHandlerModifiable itemHandler) {
        NBTTagList list = new NBTTagList();
        int slots = itemHandler.getSlots();
        for (int i = 0; i < slots; ++i) {
            ItemStack stack = itemHandler.getStackInSlot(i);
            if (stack.func_190926_b()) continue;
            NBTTagCompound nbt1 = stack.serializeNBT();
            nbt1.func_74768_a("Slot", i);
            list.func_74742_a((NBTBase)nbt1);
        }
        if (!list.func_82582_d()) {
            nbt.func_74782_a(key, (NBTBase)list);
        }
    }

    public static void readItemHandler(NBTTagCompound nbt, String key, IItemHandlerModifiable itemHandler) {
        int i;
        NBTTagList list = nbt.func_150295_c(key, 10);
        int slots = itemHandler.getSlots();
        for (i = 0; i < slots; ++i) {
            itemHandler.setStackInSlot(i, ItemStack.field_190927_a);
        }
        for (i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound nbt1 = list.func_150305_b(i);
            ItemStack stack = new ItemStack(nbt1);
            if (stack.func_190926_b()) continue;
            itemHandler.setStackInSlot(nbt1.func_74762_e("Slot"), stack);
        }
    }

    public static int getFirstItemIndex(IItemHandler handler, ItemStack filter) {
        boolean filterEmpty = filter.func_190926_b();
        int slots = handler.getSlots();
        for (int i = 0; i < slots; ++i) {
            ItemStack stack = handler.getStackInSlot(i);
            boolean stackEmpty = stack.func_190926_b();
            if (filterEmpty != stackEmpty || !filterEmpty && (filter.func_77973_b() != stack.func_77973_b() || filter.func_77960_j() != stack.func_77960_j() || !ItemStack.func_77970_a((ItemStack)filter, (ItemStack)stack))) continue;
            return i;
        }
        return -1;
    }

    @Nullable
    public static NBTTagCompound getTag(ItemStack stack) {
        return !stack.func_77942_o() || stack.func_77978_p().func_82582_d() ? null : stack.func_77978_p();
    }

    public static boolean stacksAreEqual(ItemStack stackA, ItemStack stackB) {
        return stackA.func_77973_b() == stackB.func_77973_b() && stackA.func_77960_j() == stackB.func_77960_j() && Objects.equals(InvUtils.getTag(stackA), InvUtils.getTag(stackB));
    }

    static {
        ERROR_ITEM.func_151001_c("Broken Item!");
    }
}

