/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.lib.util;

import com.feed_the_beast.ftbl.api.ATHelper;
import com.feed_the_beast.ftbl.api.INotification;
import com.feed_the_beast.ftbl.lib.util.CommonUtils;
import com.feed_the_beast.ftbl.lib.util.FileUtils;
import com.feed_the_beast.ftbl.lib.util.StringUtils;
import com.feed_the_beast.ftbl.lib.util.text_components.CustomStyle;
import com.feed_the_beast.ftbl.lib.util.text_components.Notification;
import com.feed_the_beast.ftbl.lib.util.text_components.TextComponentCountdown;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonIOException;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonWriter;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.resources.IResource;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTPrimitive;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentKeybind;
import net.minecraft.util.text.TextComponentScore;
import net.minecraft.util.text.TextComponentSelector;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class JsonUtils {
    public static final JsonParser PARSER = new JsonParser();

    public static boolean isNull(@Nullable JsonElement element) {
        return element == null || element == JsonNull.INSTANCE || element.isJsonNull();
    }

    public static void toJson(@Nullable JsonElement element, Writer writer, boolean prettyPrinting) {
        if (JsonUtils.isNull(element)) {
            try {
                writer.write("null");
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            return;
        }
        JsonWriter jsonWriter = new JsonWriter(writer);
        jsonWriter.setLenient(true);
        jsonWriter.setHtmlSafe(false);
        jsonWriter.setSerializeNulls(true);
        if (prettyPrinting) {
            jsonWriter.setIndent("\t");
        }
        try {
            Streams.write((JsonElement)element, (JsonWriter)jsonWriter);
        }
        catch (Exception ex) {
            throw new JsonIOException((Throwable)ex);
        }
    }

    public static String toJson(@Nullable JsonElement element, boolean prettyPrinting) {
        StringWriter writer = new StringWriter();
        JsonUtils.toJson(element, writer, prettyPrinting);
        return writer.toString();
    }

    public static void toJson(@Nullable JsonElement element, File file, boolean prettyPrinting) {
        try (OutputStreamWriter output = new OutputStreamWriter((OutputStream)new FileOutputStream(FileUtils.newFile(file)), StandardCharsets.UTF_8);
             BufferedWriter writer = new BufferedWriter(output);){
            JsonUtils.toJson(element, writer, prettyPrinting);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static String toJson(@Nullable JsonElement element) {
        return JsonUtils.toJson(element, false);
    }

    public static void toJson(@Nullable JsonElement element, File file) {
        JsonUtils.toJson(element, file, true);
    }

    public static JsonElement fromJson(@Nullable String json) {
        if (json == null || json.isEmpty()) {
            return JsonNull.INSTANCE;
        }
        try {
            return PARSER.parse(json);
        }
        catch (Exception e) {
            return JsonNull.INSTANCE;
        }
    }

    public static JsonElement fromJson(@Nullable Reader reader) {
        if (reader == null) {
            return JsonNull.INSTANCE;
        }
        try {
            JsonElement element = PARSER.parse(reader);
            reader.close();
            return element;
        }
        catch (IOException e) {
            return JsonNull.INSTANCE;
        }
    }

    public static JsonElement fromJson(File file) {
        try {
            if (!file.exists()) {
                return JsonNull.INSTANCE;
            }
            FileInputStream fis = new FileInputStream(file);
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)fis, StandardCharsets.UTF_8));
            JsonElement e = JsonUtils.fromJson(reader);
            reader.close();
            fis.close();
            return e;
        }
        catch (Exception ex) {
            return JsonNull.INSTANCE;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static JsonElement fromJson(IResource resource) {
        try {
            return JsonUtils.fromJson(new InputStreamReader(resource.func_110527_b()));
        }
        catch (Exception ex) {
            return JsonNull.INSTANCE;
        }
    }

    public static JsonArray toArray(JsonElement element) {
        if (element.isJsonArray()) {
            return element.getAsJsonArray();
        }
        JsonArray array = new JsonArray();
        if (!element.isJsonNull()) {
            array.add(element);
        }
        return array;
    }

    public static JsonElement serializeTextComponent(@Nullable ITextComponent component) {
        if (component == null) {
            return JsonNull.INSTANCE;
        }
        if (component.getClass() == TextComponentString.class && component.func_150253_a().isEmpty() && component.func_150256_b().func_150229_g()) {
            return new JsonPrimitive(((TextComponentString)component).func_150265_g());
        }
        JsonObject json = new JsonObject();
        Style style = component.func_150256_b();
        if (!style.func_150229_g()) {
            if (ATHelper.INSTANCE.getBold(style) != null) {
                json.addProperty("bold", Boolean.valueOf(style.func_150223_b()));
            }
            if (ATHelper.INSTANCE.getItalic(style) != null) {
                json.addProperty("italic", Boolean.valueOf(style.func_150242_c()));
            }
            if (ATHelper.INSTANCE.getUnderlined(style) != null) {
                json.addProperty("underlined", Boolean.valueOf(style.func_150234_e()));
            }
            if (ATHelper.INSTANCE.getStriketrough(style) != null) {
                json.addProperty("strikethrough", Boolean.valueOf(style.func_150236_d()));
            }
            if (ATHelper.INSTANCE.getObfuscated(style) != null) {
                json.addProperty("obfuscated", Boolean.valueOf(style.func_150233_f()));
            }
            if (style instanceof CustomStyle) {
                CustomStyle customStyle = (CustomStyle)style;
                if (customStyle.monospaced != null) {
                    json.addProperty("monospaced", Boolean.valueOf(customStyle.getMonospaced()));
                }
                if (customStyle.background != null) {
                    json.addProperty("background", customStyle.getBackground().func_96297_d());
                }
            }
            if (ATHelper.INSTANCE.getColor(style) != null) {
                json.addProperty("color", style.func_150215_a().func_96297_d());
            }
            if (ATHelper.INSTANCE.getInsertion(style) != null) {
                json.addProperty("insertion", style.func_179986_j());
            }
            if (ATHelper.INSTANCE.getClickEvent(style) != null) {
                json.add("clickEvent", JsonUtils.serializeClickEvent(style.func_150235_h()));
            }
            if (ATHelper.INSTANCE.getHoverEvent(style) != null) {
                json.add("hoverEvent", JsonUtils.serializeHoverEvent(style.func_150210_i()));
            }
        }
        if (!component.func_150253_a().isEmpty()) {
            JsonArray array = new JsonArray();
            for (ITextComponent itextcomponent : component.func_150253_a()) {
                array.add(JsonUtils.serializeTextComponent(itextcomponent));
            }
            json.add("extra", (JsonElement)array);
        }
        if (component instanceof TextComponentString) {
            json.addProperty("text", ((TextComponentString)component).func_150265_g());
            if (component instanceof TextComponentCountdown) {
                json.addProperty("countdown", (Number)((TextComponentCountdown)component).countdown);
            } else if (component instanceof INotification) {
                INotification n = (INotification)component;
                if (!n.getId().equals((Object)INotification.VANILLA_STATUS)) {
                    json.addProperty("notification", n.getId().toString());
                }
                if (n.getTimer() != 60) {
                    json.addProperty("timer", (Number)n.getTimer());
                }
                if (n.isImportant()) {
                    json.addProperty("important", Boolean.valueOf(true));
                }
            }
        } else if (component instanceof TextComponentTranslation) {
            TextComponentTranslation translation = (TextComponentTranslation)component;
            json.addProperty("translate", translation.func_150268_i());
            if (translation.func_150271_j().length > 0) {
                JsonArray array = new JsonArray();
                for (Object object : translation.func_150271_j()) {
                    if (object instanceof ITextComponent) {
                        array.add(JsonUtils.serializeTextComponent((ITextComponent)object));
                        continue;
                    }
                    array.add(String.valueOf(object));
                }
                json.add("with", (JsonElement)array);
            }
        } else if (component instanceof TextComponentScore) {
            TextComponentScore score = (TextComponentScore)component;
            JsonObject json1 = new JsonObject();
            json1.addProperty("name", score.func_179995_g());
            json1.addProperty("objective", score.func_179994_h());
            json1.addProperty("value", score.func_150261_e());
            json.add("score", (JsonElement)json1);
        } else if (component instanceof TextComponentSelector) {
            json.addProperty("selector", ((TextComponentSelector)component).func_179992_g());
        } else if (component instanceof TextComponentKeybind) {
            json.addProperty("keybind", ((TextComponentKeybind)component).func_193633_h());
        }
        if (json.entrySet().isEmpty()) {
            throw new IllegalArgumentException("Don't know how to serialize " + component + " as a Component");
        }
        return json;
    }

    @Nullable
    public static ITextComponent deserializeTextComponent(@Nullable JsonElement element) {
        CustomStyle style;
        TextComponentString component;
        String s;
        if (JsonUtils.isNull(element)) {
            return null;
        }
        if (element.isJsonPrimitive()) {
            return new TextComponentString(StringUtils.fixTabs(element.getAsString(), 2));
        }
        if (!element.isJsonObject()) {
            if (!element.isJsonArray()) {
                throw new JsonParseException("Don't know how to turn " + element + " into a Component");
            }
            ITextComponent component2 = null;
            for (JsonElement element1 : element.getAsJsonArray()) {
                ITextComponent component1 = JsonUtils.deserializeTextComponent(element1);
                if (component1 == null) {
                    component1 = new TextComponentString("");
                }
                if (component2 == null) {
                    component2 = component1;
                    continue;
                }
                component2.func_150257_a(component1);
            }
            return component2;
        }
        JsonObject json = element.getAsJsonObject();
        if (json.has("text") || json.has("notification")) {
            String string = s = json.has("text") ? StringUtils.fixTabs(json.get("text").getAsString(), 2) : "";
            if (json.has("notification") || json.has("timer") || json.has("important")) {
                Notification n = Notification.of(json.has("notification") ? new ResourceLocation(json.get("notification").getAsString()) : INotification.VANILLA_STATUS, s, new ITextComponent[0]);
                component = n;
                if (json.has("timer")) {
                    n.setTimer(net.minecraft.util.JsonUtils.func_151203_m((JsonObject)json, (String)"timer"));
                }
                if (json.has("important")) {
                    n.setImportant(net.minecraft.util.JsonUtils.func_151212_i((JsonObject)json, (String)"important"));
                }
            } else {
                component = json.has("countdown") ? new TextComponentCountdown(s, json.get("countdown").getAsLong()) : new TextComponentString(s);
            }
        } else if (json.has("translate")) {
            s = json.get("translate").getAsString();
            if (json.has("with")) {
                JsonArray a = json.getAsJsonArray("with");
                Object[] o1 = new Object[a.size()];
                for (int i = 0; i < o1.length; ++i) {
                    TextComponentString t2;
                    o1[i] = JsonUtils.deserializeTextComponent(a.get(i));
                    if (o1[i] == null || o1[i].getClass() != TextComponentString.class || !(t2 = (TextComponentString)o1[i]).func_150256_b().func_150229_g() || !t2.func_150253_a().isEmpty()) continue;
                    o1[i] = t2.func_150265_g();
                }
                component = new TextComponentTranslation(s, o1);
            } else {
                component = new TextComponentTranslation(s, CommonUtils.NO_OBJECTS);
            }
        } else if (json.has("score")) {
            JsonObject o1 = json.getAsJsonObject("score");
            if (!o1.has("name") || !o1.has("objective")) {
                throw new JsonParseException("A score component needs a least a name and an objective");
            }
            component = new TextComponentScore(net.minecraft.util.JsonUtils.func_151200_h((JsonObject)o1, (String)"name"), net.minecraft.util.JsonUtils.func_151200_h((JsonObject)o1, (String)"objective"));
            if (o1.has("value")) {
                ((TextComponentScore)component).func_179997_b(net.minecraft.util.JsonUtils.func_151200_h((JsonObject)o1, (String)"value"));
            }
        } else if (json.has("selector")) {
            component = new TextComponentSelector(net.minecraft.util.JsonUtils.func_151200_h((JsonObject)json, (String)"selector"));
        } else if (json.has("keybind")) {
            component = new TextComponentKeybind(net.minecraft.util.JsonUtils.func_151200_h((JsonObject)json, (String)"keybind"));
        } else {
            return null;
        }
        if (json.has("extra")) {
            JsonArray a = json.getAsJsonArray("extra");
            if (a.size() <= 0) {
                throw new JsonParseException("Unexpected empty array of components");
            }
            for (JsonElement element1 : a) {
                ITextComponent component1 = JsonUtils.deserializeTextComponent(element1);
                component.func_150257_a((ITextComponent)(component1 == null ? new TextComponentString("") : component1));
            }
        }
        CustomStyle customStyle = style = json.has("monospaced") || json.has("background") ? new CustomStyle() : new Style();
        if (json.has("bold")) {
            style.func_150227_a(json.get("bold").getAsBoolean());
        }
        if (json.has("italic")) {
            style.func_150217_b(json.get("italic").getAsBoolean());
        }
        if (json.has("underlined")) {
            style.func_150228_d(json.get("underlined").getAsBoolean());
        }
        if (json.has("strikethrough")) {
            style.func_150225_c(json.get("strikethrough").getAsBoolean());
        }
        if (json.has("obfuscated")) {
            style.func_150237_e(json.get("obfuscated").getAsBoolean());
        }
        if (json.has("color")) {
            style.func_150238_a(TextFormatting.func_96300_b((String)json.get("color").getAsString()));
        }
        if (style instanceof CustomStyle) {
            CustomStyle cs = style;
            if (json.has("monospaced")) {
                cs.setMonospaced(json.get("monospaced").getAsBoolean());
            }
            if (json.has("background")) {
                cs.setBackground(TextFormatting.func_96300_b((String)json.get("background").getAsString()));
            }
        }
        if (json.has("insertion")) {
            style.func_179989_a(json.get("insertion").getAsString());
        }
        if (json.has("clickEvent")) {
            style.func_150241_a(JsonUtils.deserializeClickEvent(json.get("clickEvent")));
        }
        if (json.has("hoverEvent")) {
            style.func_150209_a(JsonUtils.deserializeHoverEvent(json.get("hoverEvent")));
        }
        component.func_150255_a((Style)style);
        return component;
    }

    public static JsonElement serializeClickEvent(@Nullable ClickEvent event) {
        if (event == null) {
            return JsonNull.INSTANCE;
        }
        JsonObject o = new JsonObject();
        o.addProperty("action", event.func_150669_a().func_150673_b());
        o.addProperty("value", event.func_150668_b());
        return o;
    }

    @Nullable
    public static ClickEvent deserializeClickEvent(JsonElement element) {
        if (JsonUtils.isNull(element)) {
            return null;
        }
        JsonObject o = element.getAsJsonObject();
        if (o != null) {
            String s;
            JsonPrimitive a = o.getAsJsonPrimitive("action");
            ClickEvent.Action action = a == null ? null : ClickEvent.Action.func_150672_a((String)a.getAsString());
            JsonPrimitive v = o.getAsJsonPrimitive("value");
            String string = s = v == null ? null : v.getAsString();
            if (action != null && s != null && action.func_150674_a()) {
                return new ClickEvent(action, s);
            }
        }
        return null;
    }

    public static JsonElement serializeHoverEvent(@Nullable HoverEvent event) {
        if (event == null) {
            return JsonNull.INSTANCE;
        }
        JsonObject o = new JsonObject();
        o.addProperty("action", event.func_150701_a().func_150685_b());
        o.add("value", JsonUtils.serializeTextComponent(event.func_150702_b()));
        return o;
    }

    @Nullable
    public static HoverEvent deserializeHoverEvent(@Nullable JsonElement element) {
        if (JsonUtils.isNull(element)) {
            return null;
        }
        JsonObject o = element.getAsJsonObject();
        if (o != null) {
            ITextComponent t;
            JsonPrimitive a = o.getAsJsonPrimitive("action");
            HoverEvent.Action action = a == null ? null : HoverEvent.Action.func_150684_a((String)a.getAsString());
            JsonPrimitive v = o.getAsJsonPrimitive("value");
            ITextComponent iTextComponent = t = v == null ? null : JsonUtils.deserializeTextComponent((JsonElement)v);
            if (action != null && t != null && action.func_150686_a()) {
                return new HoverEvent(action, t);
            }
        }
        return null;
    }

    public static JsonObject fromJsonTree(JsonObject o) {
        JsonObject map = new JsonObject();
        JsonUtils.fromJsonTree0(map, null, o);
        return map;
    }

    private static void fromJsonTree0(JsonObject map, @Nullable String id0, JsonObject o) {
        for (Map.Entry entry : o.entrySet()) {
            if (entry.getValue() instanceof JsonObject) {
                JsonUtils.fromJsonTree0(map, id0 == null ? (String)entry.getKey() : id0 + '.' + (String)entry.getKey(), ((JsonElement)entry.getValue()).getAsJsonObject());
                continue;
            }
            map.add(id0 == null ? (String)entry.getKey() : id0 + '.' + (String)entry.getKey(), (JsonElement)entry.getValue());
        }
    }

    public static JsonObject toJsonTree(Collection<Map.Entry<String, JsonElement>> tree) {
        JsonObject o1 = new JsonObject();
        for (Map.Entry<String, JsonElement> entry : tree) {
            JsonUtils.findGroup(o1, entry.getKey()).add(JsonUtils.lastKeyPart(entry.getKey()), entry.getValue());
        }
        return o1;
    }

    private static String lastKeyPart(String s) {
        int idx = s.lastIndexOf(46);
        if (idx != -1) {
            return s.substring(idx + 1);
        }
        return s;
    }

    private static JsonObject findGroup(JsonObject parent, String s) {
        int idx = s.indexOf(46);
        if (idx != -1) {
            String s0 = s.substring(0, idx);
            JsonElement o = parent.get(s0);
            if (o == null) {
                o = new JsonObject();
                parent.add(s0, o);
            }
            return JsonUtils.findGroup(o.getAsJsonObject(), s.substring(idx + 1, s.length() - 1));
        }
        return parent;
    }

    public static String fixJsonString(String json) {
        if (json.isEmpty()) {
            return "\"\"";
        }
        if (!(json.indexOf(32) == -1 || json.startsWith("\"") && json.endsWith("\"") || json.startsWith("{") && json.endsWith("}") || json.startsWith("[") && json.endsWith("]"))) {
            json = "\"" + json + "\"";
        }
        return json;
    }

    public static JsonElement toJson(@Nullable NBTBase nbt) {
        if (nbt == null) {
            return JsonNull.INSTANCE;
        }
        switch (nbt.func_74732_a()) {
            case 10: {
                JsonObject json = new JsonObject();
                if (!nbt.func_82582_d()) {
                    NBTTagCompound tagCompound = (NBTTagCompound)nbt;
                    for (String s : tagCompound.func_150296_c()) {
                        json.add(s, JsonUtils.toJson(tagCompound.func_74781_a(s)));
                    }
                }
                return json;
            }
            case 9: {
                JsonArray json = new JsonArray();
                if (!nbt.func_82582_d()) {
                    NBTTagList list = (NBTTagList)nbt;
                    for (int i = 0; i < list.func_74745_c(); ++i) {
                        json.add(JsonUtils.toJson(list.func_179238_g(i)));
                    }
                }
                return json;
            }
            case 8: {
                return new JsonPrimitive(((NBTTagString)nbt).func_150285_a_());
            }
            case 1: {
                return new JsonPrimitive((Number)((NBTPrimitive)nbt).func_150290_f());
            }
            case 2: {
                return new JsonPrimitive((Number)((NBTPrimitive)nbt).func_150289_e());
            }
            case 3: {
                return new JsonPrimitive((Number)((NBTPrimitive)nbt).func_150287_d());
            }
            case 4: {
                return new JsonPrimitive((Number)((NBTPrimitive)nbt).func_150291_c());
            }
            case 5: {
                return new JsonPrimitive((Number)Float.valueOf(((NBTPrimitive)nbt).func_150288_h()));
            }
            case 6: {
                return new JsonPrimitive((Number)((NBTPrimitive)nbt).func_150286_g());
            }
            case 7: {
                JsonArray json = new JsonArray();
                if (!nbt.func_82582_d()) {
                    for (byte v : ((NBTTagByteArray)nbt).func_150292_c()) {
                        json.add((Number)v);
                    }
                }
                return json;
            }
            case 11: {
                JsonArray json = new JsonArray();
                if (!nbt.func_82582_d()) {
                    for (int v : ((NBTTagIntArray)nbt).func_150302_c()) {
                        json.add((Number)v);
                    }
                }
                return json;
            }
        }
        return JsonNull.INSTANCE;
    }

    @Nullable
    public static NBTBase toNBT(@Nullable JsonElement element) {
        if (JsonUtils.isNull(element)) {
            return null;
        }
        try {
            return JsonToNBT.func_180713_a((String)JsonUtils.toJson(element));
        }
        catch (Exception ex) {
            return null;
        }
    }
}

