/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.lib.util;

import com.feed_the_beast.ftbl.lib.util.CommonUtils;
import com.feed_the_beast.ftbl.lib.util.StringJoiner;
import com.feed_the_beast.ftbl.lib.util.StringUtils;
import javax.annotation.Nullable;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentBase;
import net.minecraftforge.server.command.TextComponentHelper;

public final class LangKey
implements IStringSerializable {
    private final String key;
    private final Class[] arguments;
    private Style defaultStyle;

    public static LangKey of(String key, Class ... args) {
        return new LangKey(key, args);
    }

    private LangKey(String s, Class[] a) {
        this.key = s;
        this.arguments = a;
        this.defaultStyle = null;
        for (int i = 0; i < a.length; ++i) {
            if (a[i] == null) {
                a[i] = Object.class;
                continue;
            }
            if (a[i] == Byte.class || a[i] == Short.class) {
                a[i] = Integer.class;
                continue;
            }
            if (!ITextComponent.class.isAssignableFrom(a[i])) continue;
            a[i] = String.class;
        }
    }

    private static boolean canAssign(@Nullable Object o, @Nullable Class c) {
        if (o == null && c == null) {
            return true;
        }
        if (o == null || c == null) {
            return false;
        }
        Class<?> c1 = o.getClass();
        if (c1 == c) {
            return true;
        }
        if (c == String.class) {
            return o instanceof ITextComponent;
        }
        if (c == Integer.class) {
            return c1 == Short.class || c1 == Byte.class;
        }
        return c.isAssignableFrom(c1);
    }

    private void checkArgument(boolean b, Object[] with) {
        if (!b) {
            Object[] args = new Object[this.arguments.length];
            for (int i = 0; i < this.arguments.length; ++i) {
                args[i] = this.arguments[i].getSimpleName();
            }
            Object[] got = new Object[with.length];
            for (int i = 0; i < with.length; ++i) {
                Class c = Object.class;
                if (with[i] instanceof ITextComponent) {
                    c = String.class;
                } else if (with[i] != null) {
                    c = with.getClass();
                }
                if (c == Byte.class || c == Short.class) {
                    c = Integer.class;
                }
                got[i] = c.getSimpleName();
            }
            throw new IllegalArgumentException("Expected [" + StringJoiner.with(", ").joinObjects(args) + "] for " + this.key + ", got [" + StringJoiner.with(", ").joinObjects(got) + "]");
        }
    }

    private void checkArguments(Object[] with) {
        this.checkArgument(this.arguments.length == with.length, with);
        for (int i = 0; i < this.arguments.length; ++i) {
            this.checkArgument(LangKey.canAssign(with[i], this.arguments[i]), with);
        }
    }

    public String func_176610_l() {
        return this.key;
    }

    public LangKey setDefaultStyle(@Nullable Style style) {
        this.defaultStyle = style;
        return this;
    }

    public String translate() {
        this.checkArguments(CommonUtils.NO_OBJECTS);
        return StringUtils.translate(this.key);
    }

    public String translate(Object ... o) {
        this.checkArguments(o);
        return StringUtils.translate(this.key, o);
    }

    public ITextComponent textComponent(@Nullable ICommandSender sender) {
        this.checkArguments(CommonUtils.NO_OBJECTS);
        TextComponentBase component = TextComponentHelper.createComponentTranslation((ICommandSender)sender, (String)this.key, (Object[])CommonUtils.NO_OBJECTS);
        if (this.defaultStyle != null) {
            component.func_150255_a(this.defaultStyle.func_150232_l());
        }
        return component;
    }

    public ITextComponent textComponent(@Nullable ICommandSender sender, Object ... with) {
        this.checkArguments(with);
        TextComponentBase component = TextComponentHelper.createComponentTranslation((ICommandSender)sender, (String)this.key, (Object[])with);
        if (this.defaultStyle != null) {
            component.func_150255_a(this.defaultStyle.func_150232_l());
        }
        return component;
    }

    public void sendMessage(ICommandSender sender, Object ... with) {
        sender.func_145747_a(this.textComponent(sender, with));
    }

    public CommandException commandError(Object ... with) {
        this.checkArguments(with);
        return new CommandException(this.key, with);
    }
}

