/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.lib.util;

import com.feed_the_beast.ftbl.api.FTBLibAPI;
import com.feed_the_beast.ftbl.lib.internal.FTBLibFinals;
import com.feed_the_beast.ftbl.lib.math.BlockDimPos;
import com.feed_the_beast.ftbl.lib.util.misc.NameMap;
import com.mojang.authlib.GameProfile;
import io.netty.channel.Channel;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.Teleporter;
import net.minecraft.world.World;
import net.minecraft.world.WorldEntitySpawner;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.server.FMLServerHandler;
import net.minecraftforge.server.command.TextComponentHelper;

public class ServerUtils {
    public static final NameMap<TextFormatting> TEXT_FORMATTING_NAME_MAP = NameMap.create(TextFormatting.RESET, TextFormatting.values());

    public static boolean teleportEntity(Entity entity, BlockDimPos pos) {
        return ServerUtils.teleportEntity(entity, pos.getBlockPos(), pos.dim);
    }

    public static boolean teleportEntity(Entity entity, BlockPos pos, int targetDim) {
        int from;
        EntityPlayerMP player = null;
        if (entity instanceof EntityPlayerMP) {
            player = (EntityPlayerMP)entity;
        }
        if ((from = entity.field_71093_bK) != targetDim) {
            MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
            WorldServer fromDim = server.func_71218_a(from);
            WorldServer toDim = server.func_71218_a(targetDim);
            TeleporterBlank teleporter = new TeleporterBlank(toDim);
            if (player != null) {
                server.func_184103_al().transferPlayerToDimension(player, targetDim, (Teleporter)teleporter);
                if (from == 1 && entity.func_70089_S()) {
                    toDim.func_72838_d(entity);
                    toDim.func_72866_a(entity, false);
                }
            } else {
                NBTTagCompound tagCompound = new NBTTagCompound();
                float rotationYaw = entity.field_70177_z;
                float rotationPitch = entity.field_70125_A;
                entity.func_189511_e(tagCompound);
                Class<?> entityClass = entity.getClass();
                fromDim.func_72900_e(entity);
                try {
                    Entity newEntity = (Entity)entityClass.getConstructor(World.class).newInstance(toDim);
                    newEntity.func_70020_e(tagCompound);
                    newEntity.func_70012_b((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), rotationYaw, rotationPitch);
                    newEntity.field_98038_p = true;
                    toDim.func_72838_d(newEntity);
                    newEntity.field_98038_p = false;
                }
                catch (Exception ex) {
                    FTBLibFinals.LOGGER.error("Error creating an entity to be created in new dimension." + ex);
                    return false;
                }
            }
        }
        if (!entity.field_70170_p.func_175667_e(pos)) {
            entity.field_70170_p.func_175726_f(pos);
        }
        if (player != null) {
            player.field_71135_a.func_147364_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 1.1, (double)pos.func_177952_p() + 0.5, player.field_70177_z, player.field_70125_A);
            player.func_82242_a(0);
        } else {
            entity.func_70634_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 1.1, (double)pos.func_177952_p() + 0.5);
        }
        entity.field_70143_R = 0.0f;
        return true;
    }

    public static double getMovementFactor(int dim) {
        switch (dim) {
            case 0: {
                return 1.0;
            }
            case -1: {
                return 8.0;
            }
            case 1: {
                return 1.0;
            }
        }
        WorldServer w = DimensionManager.getWorld((int)dim);
        return w == null ? 1.0 : w.field_73011_w.getMovementFactor();
    }

    public static ITextComponent getDimensionName(@Nullable ICommandSender sender, int dim) {
        switch (dim) {
            case 0: {
                return TextComponentHelper.createComponentTranslation((ICommandSender)sender, (String)"dimension.overworld", (Object[])new Object[0]);
            }
            case -1: {
                return TextComponentHelper.createComponentTranslation((ICommandSender)sender, (String)"dimension.nether", (Object[])new Object[0]);
            }
            case 1: {
                return TextComponentHelper.createComponentTranslation((ICommandSender)sender, (String)"dimension.end", (Object[])new Object[0]);
            }
        }
        return new TextComponentString("DIM_" + dim);
    }

    public static MinecraftServer getServer() {
        if (FTBLibAPI.API.hasUniverse()) {
            return FTBLibAPI.API.getUniverse().getServer();
        }
        return Objects.requireNonNull(FMLServerHandler.instance().getServer());
    }

    public static WorldServer getOverworld() {
        return FTBLibAPI.API.hasUniverse() ? FTBLibAPI.API.getUniverse().getOverworld() : ServerUtils.getServer().func_71218_a(0);
    }

    public static List<EntityPlayerMP> getPlayers() {
        return ServerUtils.getServer().func_184103_al().func_181057_v();
    }

    public static boolean hasOnlinePlayers() {
        return !ServerUtils.getPlayers().isEmpty();
    }

    public static boolean isVanillaClient(ICommandSender sender) {
        if (sender instanceof EntityPlayerMP) {
            EntityPlayerMP playerMP = (EntityPlayerMP)sender;
            Channel channel = playerMP.field_71135_a.field_147371_a.channel();
            return (Boolean)channel.attr(NetworkRegistry.FML_MARKER).get() == false;
        }
        return false;
    }

    public static boolean isOP(GameProfile p) {
        return ServerUtils.getServer().func_184103_al().func_152596_g(p);
    }

    public static Collection<ICommand> getAllCommands(MinecraftServer server, ICommandSender sender) {
        HashSet<ICommand> commands = new HashSet<ICommand>();
        for (ICommand c : server.func_71187_D().func_71555_a().values()) {
            if (!c.func_184882_a(server, sender)) continue;
            commands.add(c);
        }
        return commands;
    }

    public static SpawnType canMobSpawn(World world, BlockPos pos) {
        if (pos.func_177956_o() < 0 || pos.func_177956_o() >= 256) {
            return SpawnType.CANT_SPAWN;
        }
        Chunk chunk = world.func_175726_f(pos);
        if (!WorldEntitySpawner.func_180267_a((EntityLiving.SpawnPlacementType)EntityLiving.SpawnPlacementType.ON_GROUND, (World)world, (BlockPos)pos) || chunk.func_177413_a(EnumSkyBlock.BLOCK, pos) >= 8) {
            return SpawnType.CANT_SPAWN;
        }
        AxisAlignedBB aabb = new AxisAlignedBB((double)pos.func_177958_n() + 0.2, (double)pos.func_177956_o() + 0.01, (double)pos.func_177952_p() + 0.2, (double)pos.func_177958_n() + 0.8, (double)pos.func_177956_o() + 1.8, (double)pos.func_177952_p() + 0.8);
        if (!world.func_72855_b(aabb) || world.func_72953_d(aabb)) {
            return SpawnType.CANT_SPAWN;
        }
        return chunk.func_177413_a(EnumSkyBlock.SKY, pos) >= 8 ? SpawnType.ONLY_AT_NIGHT : SpawnType.ALWAYS_SPAWNS;
    }

    @Nullable
    public static Entity getEntityByUUID(World worldObj, UUID uuid) {
        for (Entity e : worldObj.field_72996_f) {
            if (!e.func_110124_au().equals(uuid)) continue;
            return e;
        }
        return null;
    }

    public static void notify(@Nullable EntityPlayer player, ITextComponent component) {
        if (player == null) {
            for (EntityPlayer player1 : ServerUtils.getServer().func_184103_al().func_181057_v()) {
                player1.func_146105_b(component, true);
            }
        } else {
            player.func_146105_b(component, true);
        }
    }

    private static class TeleporterBlank
    extends Teleporter {
        private TeleporterBlank(WorldServer world) {
            super(world);
        }

        public boolean func_85188_a(Entity entity) {
            return true;
        }

        public boolean func_180620_b(Entity entity, float rotationYaw) {
            return true;
        }

        public void func_180266_a(Entity entity, float rotationYaw) {
            int x = MathHelper.func_76128_c((double)entity.field_70165_t);
            int y = MathHelper.func_76128_c((double)entity.field_70163_u) - 1;
            int z = MathHelper.func_76128_c((double)entity.field_70161_v);
            entity.func_70012_b((double)x, (double)y, (double)z, entity.field_70125_A, entity.field_70177_z);
            entity.field_70159_w = 0.0;
            entity.field_70181_x = 0.0;
            entity.field_70179_y = 0.0;
            entity.field_70143_R = 0.0f;
        }

        public void func_85189_a(long worldTime) {
        }
    }

    public static enum SpawnType {
        CANT_SPAWN,
        ALWAYS_SPAWNS,
        ONLY_AT_NIGHT;

    }
}

