/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.lib.util;

import java.util.Collection;

public abstract class StringJoiner {
    public static StringJoiner with(String string) {
        switch (string.length()) {
            case 0: {
                return WithString.WITH_NOTHING;
            }
            case 1: {
                return StringJoiner.with(string.charAt(0));
            }
        }
        return new WithString(string);
    }

    public static StringJoiner with(char character) {
        switch (character) {
            case ',': {
                return WithChar.WITH_COMMA;
            }
            case ' ': {
                return WithChar.WITH_SPACE;
            }
        }
        return new WithChar(character);
    }

    public static StringJoiner properties() {
        return new PropertiesJoiner();
    }

    protected abstract void append(StringBuilder var1);

    public String joinObjects(Object ... objects) {
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        for (Object object : objects) {
            if (first) {
                first = false;
            } else {
                this.append(builder);
            }
            builder.append(object);
        }
        return builder.toString();
    }

    public String join(Iterable objects) {
        if (objects instanceof Collection && ((Collection)objects).isEmpty()) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        for (Object object : objects) {
            if (first) {
                first = false;
            } else {
                this.append(builder);
            }
            builder.append(object);
        }
        return builder.toString();
    }

    private static class PropertiesJoiner
    extends StringJoiner {
        private int index = 0;

        private PropertiesJoiner() {
        }

        @Override
        protected void append(StringBuilder builder) {
            if (this.index % 2 == 0) {
                builder.append(", ");
            } else {
                builder.append('=');
            }
            ++this.index;
        }
    }

    private static class WithChar
    extends StringJoiner {
        private static final WithChar WITH_COMMA = new WithChar(',');
        private static final WithChar WITH_SPACE = new WithChar(' ');
        private final char c;

        private WithChar(char _c) {
            this.c = _c;
        }

        @Override
        protected void append(StringBuilder builder) {
            builder.append(this.c);
        }
    }

    private static class WithString
    extends StringJoiner {
        private static final WithString WITH_NOTHING = new WithString("");
        private final String s;

        private WithString(String _s) {
            this.s = _s;
        }

        @Override
        protected void append(StringBuilder builder) {
            builder.append(this.s);
        }
    }
}

