/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.lib.util;

import com.feed_the_beast.ftbl.lib.io.Bits;
import com.feed_the_beast.ftbl.lib.util.UtilsCommon;
import com.feed_the_beast.ftbl.lib.util.text_components.CustomStyle;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;

public class StringUtils {
    public static final int DAY24 = 86400;
    public static final String STRIP_SEP = ", ";
    public static final String ALLOWED_TEXT_CHARS = " .-_!@#$%^&*()+=\\/,<>?'\"[]{}|;:`~";
    public static final char FORMATTING_CHAR = '\u00a7';
    public static final String FORMATTING = "\u00a7";
    public static final int FLAG_ID_ALLOW_EMPTY = 1;
    public static final int FLAG_ID_FIX = 2;
    public static final int FLAG_ID_ONLY_LOWERCASE = 4;
    public static final int FLAG_ID_ONLY_UNDERLINE = 8;
    public static final int FLAG_ID_ONLY_UNDERLINE_OR_PERIOD = 24;
    public static final int FLAG_ID_DEFAULTS = 14;
    public static final Comparator<Object> IGNORE_CASE_COMPARATOR = (o1, o2) -> String.valueOf(o1).compareToIgnoreCase(String.valueOf(o2));
    public static final Comparator<Object> ID_COMPARATOR = (o1, o2) -> StringUtils.getId(o1, 2).compareToIgnoreCase(StringUtils.getId(o2, 2));
    public static final Map<String, String> TEMP_MAP = new HashMap<String, String>();
    public static final DecimalFormat SMALL_DOUBLE_FORMATTER = new DecimalFormat("#0.00");
    public static final int[] INT_SIZE_TABLE = new int[]{9, 99, 999, 9999, 99999, 999999, 9999999, 99999999, 999999999, Integer.MAX_VALUE};

    public static String emptyIfNull(@Nullable Object o) {
        return o == null ? "" : o.toString();
    }

    public static String getRawId(Object o) {
        if (o instanceof IStringSerializable) {
            return ((IStringSerializable)o).func_176610_l();
        }
        if (o instanceof Enum) {
            return ((Enum)o).name();
        }
        return String.valueOf(o);
    }

    public static String getId(Object o, int flags) {
        String id = StringUtils.getRawId(o);
        if (flags == 0) {
            return id;
        }
        boolean fix = Bits.getFlag(flags, 2);
        if (!fix && id.isEmpty() && !Bits.getFlag(flags, 1)) {
            throw new NullPointerException("ID can't be empty!");
        }
        if (Bits.getFlag(flags, 4)) {
            if (fix) {
                id = id.toLowerCase();
            } else if (!id.equals(id.toLowerCase())) {
                throw new IllegalArgumentException("ID can't contain uppercase characters!");
            }
        }
        if (Bits.getFlag(flags, 8)) {
            if (fix) {
                id = id.toLowerCase();
            } else if (!id.equals(id.toLowerCase())) {
                throw new IllegalArgumentException("ID can't contain uppercase characters!");
            }
        }
        if (Bits.getFlag(flags, 8)) {
            boolean allowPeriod = Bits.getFlag(flags, 24);
            char[] chars = id.toCharArray();
            for (int i = 0; i < chars.length; ++i) {
                if (chars[i] == '.' && allowPeriod || StringUtils.isTextChar(chars[i], true)) continue;
                if (fix) {
                    chars[i] = 95;
                    continue;
                }
                throw new IllegalArgumentException("ID contains invalid character: '" + chars[i] + "'!");
            }
            id = new String(chars);
        }
        return id;
    }

    public static String toString(@Nullable Object object, @Nullable Function<Object, String> nameSupplier) {
        if (object == null) {
            return "null";
        }
        if (object.getClass().isArray()) {
            Object[] objects = (Object[])object;
            if (objects.length == 0) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            sb.append('[');
            for (int i = 0; i < objects.length; ++i) {
                sb.append(StringUtils.toString(objects[i], nameSupplier));
                if (i == objects.length - 1) continue;
                sb.append(',');
                sb.append(' ');
            }
            sb.append(']');
            return sb.toString();
        }
        if (object instanceof Map) {
            Map map = (Map)object;
            if (map.isEmpty()) {
                return "{}";
            }
            StringBuilder sb = new StringBuilder();
            sb.append('{');
            int s = map.size();
            int i = 0;
            for (Map.Entry e : map.entrySet()) {
                sb.append(StringUtils.toString(e.getKey(), nameSupplier));
                sb.append(':');
                sb.append(' ');
                sb.append(StringUtils.toString(e.getValue(), nameSupplier));
                if (++i == s) continue;
                sb.append(',');
                sb.append(' ');
            }
            sb.append(' ');
            sb.append('}');
            return sb.toString();
        }
        if (object instanceof Collection) {
            Collection c = (Collection)object;
            if (c.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            sb.append('[');
            int s = c.size();
            int i = 0;
            for (Object o : c) {
                sb.append(StringUtils.toString(o, nameSupplier));
                if (++i == s) continue;
                sb.append(',');
                sb.append(' ');
            }
            sb.append(']');
            return sb.toString();
        }
        String s = nameSupplier == null ? null : nameSupplier.apply(object);
        return s == null ? object.toString() : s;
    }

    public static String[] shiftArray(@Nullable String[] s) {
        if (s == null || s.length == 0) {
            return new String[0];
        }
        String[] s1 = new String[s.length - 1];
        System.arraycopy(s, 1, s1, 0, s1.length);
        return s1;
    }

    public static String readString(InputStream is) throws Exception {
        char[] buffer = new char[65536];
        StringBuilder out = new StringBuilder();
        try (InputStreamReader in = new InputStreamReader(is, StandardCharsets.UTF_8);){
            int read;
            do {
                if ((read = ((Reader)in).read(buffer, 0, buffer.length)) <= 0) continue;
                out.append(buffer, 0, read);
            } while (read >= 0);
            ((Reader)in).close();
        }
        return out.toString();
    }

    public static List<String> readStringList(Reader r) throws Exception {
        String s;
        ArrayList<String> l = new ArrayList<String>();
        BufferedReader reader = new BufferedReader(r);
        while ((s = reader.readLine()) != null) {
            l.add(s);
        }
        reader.close();
        return l;
    }

    public static List<String> readStringList(InputStream is) throws Exception {
        return StringUtils.readStringList(new InputStreamReader(is, StandardCharsets.UTF_8));
    }

    public static List<String> toStringList(String s, String regex) {
        ArrayList<String> al = new ArrayList<String>();
        String[] s1 = s.split(regex);
        if (s1.length > 0) {
            for (String aS1 : s1) {
                al.add(aS1.trim());
            }
        }
        return al;
    }

    public static boolean isASCIIChar(char c) {
        return c > '\u0000' && c < '\u0100';
    }

    public static boolean isTextChar(char c, boolean onlyAZ09) {
        return StringUtils.isASCIIChar(c) && (c >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || !onlyAZ09 && ALLOWED_TEXT_CHARS.indexOf(c) != -1);
    }

    public static void replace(List<String> txt, String s, String s1) {
        if (!txt.isEmpty()) {
            for (int i = 0; i < txt.size(); ++i) {
                String s2 = txt.get(i);
                if (s2 == null || s2.length() <= 0) continue;
                s2 = s2.replace(s, s1);
                txt.set(i, s2);
            }
        }
    }

    public static String replace(String s, char c, char with) {
        if (s.isEmpty()) {
            return s;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char c1 = s.charAt(i);
            sb.append(c1 == c ? with : c1);
        }
        return sb.toString();
    }

    public static <E> String[] toStrings(E[] o) {
        String[] s = new String[o.length];
        for (int i = 0; i < o.length; ++i) {
            s[i] = String.valueOf(o[i]);
        }
        return s;
    }

    public static String strip(String ... o) {
        if (o.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < o.length; ++i) {
            sb.append(o[i]);
            if (i == o.length - 1) continue;
            sb.append(STRIP_SEP);
        }
        return sb.toString();
    }

    public static String strip(Collection<?> c) {
        if (c.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        int idx = 0;
        int eidx = c.size() - 1;
        for (Object o : c) {
            sb.append(o);
            if (idx != eidx) {
                sb.append(STRIP_SEP);
            }
            ++idx;
        }
        return sb.toString();
    }

    public static String stripD(double ... o) {
        if (o.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < o.length; ++i) {
            sb.append(StringUtils.formatDouble(o[i]));
            if (i == o.length - 1) continue;
            sb.append(STRIP_SEP);
        }
        return sb.toString();
    }

    public static String stripDI(double ... o) {
        if (o.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < o.length; ++i) {
            sb.append((long)o[i]);
            if (i == o.length - 1) continue;
            sb.append(STRIP_SEP);
        }
        return sb.toString();
    }

    public static String stripI(int ... o) {
        if (o.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < o.length; ++i) {
            sb.append(o[i]);
            if (i == o.length - 1) continue;
            sb.append(STRIP_SEP);
        }
        return sb.toString();
    }

    public static String stripB(boolean ... o) {
        if (o.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < o.length; ++i) {
            sb.append(o[i] ? (char)'1' : '0');
            if (i == o.length - 1) continue;
            sb.append(STRIP_SEP);
        }
        return sb.toString();
    }

    public static String stripB(byte ... o) {
        if (o.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < o.length; ++i) {
            sb.append(o[i]);
            if (i == o.length - 1) continue;
            sb.append(STRIP_SEP);
        }
        return sb.toString();
    }

    @Nullable
    public static String joinSpaceUntilEnd(int startIndex, CharSequence[] o) {
        if (startIndex < 0 || o.length <= startIndex) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = startIndex; i < o.length; ++i) {
            sb.append(o[i]);
            if (i == o.length - 1) continue;
            sb.append(' ');
        }
        return sb.toString();
    }

    public static String firstUppercase(String s) {
        if (s.length() == 0) {
            return s;
        }
        char c = Character.toUpperCase(s.charAt(0));
        if (s.length() == 1) {
            return Character.toString(c);
        }
        return String.valueOf(c) + s.substring(1);
    }

    public static String fillString(CharSequence s, char fill, int length) {
        int sl = s.length();
        char[] c = new char[Math.max(sl, length)];
        for (int i = 0; i < c.length; ++i) {
            c[i] = i >= sl ? fill : s.charAt(i);
        }
        return new String(c);
    }

    public static String removeAllWhitespace(String s) {
        return s.isEmpty() ? s : s.replaceAll("\\s+", "");
    }

    public static String trimAllWhitespace(String s) {
        return s.isEmpty() ? s : s.replace("^\\s*(.*?)\\s*$", "$1");
    }

    public static String formatDouble(double d) {
        if (d == Double.POSITIVE_INFINITY) {
            return "+Inf";
        }
        if (d == Double.NEGATIVE_INFINITY) {
            return "-Inf";
        }
        if (d == Double.NaN) {
            return "NaN";
        }
        if (d == 0.0) {
            return "0.00";
        }
        return SMALL_DOUBLE_FORMATTER.format(d);
    }

    public static String getTimeStringTicks(long ticks) {
        return StringUtils.getTimeString(ticks * 1000L / 20L);
    }

    public static String getTimeString(long millis) {
        return StringUtils.getTimeString(millis, true);
    }

    public static String getTimeString(long millis, boolean days) {
        boolean neg = false;
        if (millis <= 0L) {
            neg = true;
            millis = -millis + 999L;
        }
        long secs = millis / 1000L;
        StringBuilder sb = new StringBuilder();
        if (neg) {
            sb.append('-');
        }
        long h = secs / 3600L % 24L;
        long m = secs / 60L % 60L;
        long s = secs % 60L;
        if (days && secs >= 86400L) {
            sb.append(secs / 86400L);
            sb.append(':');
        }
        if (h < 10L) {
            sb.append('0');
        }
        sb.append(h);
        sb.append(':');
        if (m < 10L) {
            sb.append('0');
        }
        sb.append(m);
        sb.append(':');
        if (s < 10L) {
            sb.append('0');
        }
        sb.append(s);
        return sb.toString();
    }

    public static String fromUUID(@Nullable UUID id) {
        if (id != null) {
            long msb = id.getMostSignificantBits();
            long lsb = id.getLeastSignificantBits();
            StringBuilder sb = new StringBuilder(32);
            StringUtils.digitsUUID(sb, msb >> 32, 8);
            StringUtils.digitsUUID(sb, msb >> 16, 4);
            StringUtils.digitsUUID(sb, msb, 4);
            StringUtils.digitsUUID(sb, lsb >> 48, 4);
            StringUtils.digitsUUID(sb, lsb, 12);
            return sb.toString();
        }
        return "";
    }

    private static void digitsUUID(StringBuilder sb, long val, int digits) {
        long hi = 1L << digits * 4;
        String s = Long.toHexString(hi | val & hi - 1L);
        sb.append(s, 1, s.length());
    }

    @Nullable
    public static UUID fromString(@Nullable String s) {
        if (s == null || s.length() != 32 && s.length() != 36) {
            return null;
        }
        try {
            if (s.indexOf(45) != -1) {
                return UUID.fromString(s);
            }
            int l = s.length();
            StringBuilder sb = new StringBuilder(36);
            for (int i = 0; i < l; ++i) {
                sb.append(s.charAt(i));
                if (i != 7 && i != 11 && i != 15 && i != 19) continue;
                sb.append('-');
            }
            return UUID.fromString(sb.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Map<String, String> parse(Map<String, String> map, String s) {
        if (map == TEMP_MAP) {
            map.clear();
        }
        for (String entry : s.split(",")) {
            String[] val = entry.split("=");
            for (String key : val[0].split("&")) {
                map.put(key, val[1]);
            }
        }
        return map;
    }

    public static boolean nodesMatch(String[] node, String[] with) {
        if (with.length > node.length) {
            return false;
        }
        for (int i = 0; i < with.length; ++i) {
            if (with[i].equals("*")) {
                return true;
            }
            if (with[i].equals(node[i])) continue;
            return false;
        }
        return false;
    }

    public static CustomStyle getStyle(ITextComponent component) {
        Style s = component.func_150256_b();
        if (!(s instanceof CustomStyle)) {
            s = new CustomStyle(s);
            component.func_150255_a(s);
        }
        return (CustomStyle)s;
    }

    public static ITextComponent color(ITextComponent component, @Nullable TextFormatting color) {
        component.func_150256_b().func_150238_a(color);
        return component;
    }

    public static ITextComponent bold(ITextComponent component, boolean value) {
        component.func_150256_b().func_150227_a(Boolean.valueOf(value));
        return component;
    }

    public static ITextComponent italic(ITextComponent component, boolean value) {
        component.func_150256_b().func_150217_b(Boolean.valueOf(value));
        return component;
    }

    public static ITextComponent underlined(ITextComponent component, boolean value) {
        component.func_150256_b().func_150228_d(Boolean.valueOf(value));
        return component;
    }

    public static ITextComponent monospaced(ITextComponent component, boolean value) {
        StringUtils.getStyle(component).setMonospaced(value);
        return component;
    }

    public static ITextComponent background(ITextComponent component, TextFormatting background) {
        StringUtils.getStyle(component).setBackground(background);
        return component;
    }

    public static String translate(String key) {
        return UtilsCommon.INSTANCE.translate(key);
    }

    public static String translate(String key, Object ... objects) {
        return UtilsCommon.INSTANCE.translate(key, objects);
    }

    public static boolean canTranslate(String key) {
        return UtilsCommon.INSTANCE.canTranslate(key);
    }

    public static String fixTabs(String string, int tabSize) {
        String with;
        if (tabSize == 2) {
            with = "  ";
        } else if (tabSize == 4) {
            with = "    ";
        } else {
            char[] c = new char[tabSize];
            Arrays.fill(c, ' ');
            with = new String(c);
        }
        return string.replace("\t", with);
    }

    public static int stringSize(int x) {
        int i = 0;
        while (x > INT_SIZE_TABLE[i]) {
            ++i;
        }
        return i + 1;
    }

    public static String add0s(int number, int max) {
        int size = StringUtils.stringSize(max);
        int nsize = StringUtils.stringSize(number);
        StringBuilder builder = new StringBuilder(size);
        for (int i = 0; i < size - nsize; ++i) {
            builder.append('0');
        }
        builder.append(number);
        return builder.toString();
    }
}

