/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.lib.util.misc;

import com.feed_the_beast.ftbl.lib.util.JsonUtils;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.IntSupplier;
import net.minecraft.util.IJsonSerializable;
import net.minecraft.util.text.ITextComponent;

public class ChatHistory
implements Iterable<Message>,
IJsonSerializable {
    public final List<Message> list = new ArrayList<Message>();
    public final IntSupplier limit;

    public ChatHistory(IntSupplier l) {
        this.limit = l;
    }

    public void add(Message message) {
        int limitInt = this.limit.getAsInt();
        while (this.list.size() >= limitInt) {
            this.list.remove(0);
        }
        this.list.add(message);
    }

    @Override
    public Iterator<Message> iterator() {
        return this.list.iterator();
    }

    public void func_152753_a(JsonElement json) {
        this.list.clear();
        if (json.isJsonArray()) {
            for (JsonElement element : json.getAsJsonArray()) {
                Message message = new Message(element.getAsJsonObject());
                if (!message.isValid()) continue;
                this.list.add(message);
            }
        }
    }

    public JsonElement func_151003_a() {
        JsonArray json = new JsonArray();
        for (Message message : this.list) {
            if (!message.isValid()) continue;
            json.add((JsonElement)message.toJson());
        }
        return json;
    }

    public static class Message
    implements Comparable<Message> {
        public final ITextComponent message;
        public final ITextComponent from;
        public final long ticks;

        public Message(ITextComponent msg, ITextComponent p, long t) {
            this.message = msg;
            this.from = p;
            this.ticks = t;
        }

        public Message(JsonObject json) {
            this.message = JsonUtils.deserializeTextComponent(json.get("message"));
            this.from = JsonUtils.deserializeTextComponent(json.get("from"));
            this.ticks = json.has("time") ? json.get("time").getAsLong() : 0L;
        }

        public boolean isValid() {
            return this.message != null && this.from != null && this.ticks > 0L;
        }

        public JsonObject toJson() {
            JsonObject json = new JsonObject();
            json.add("message", JsonUtils.serializeTextComponent(this.message));
            json.add("from", JsonUtils.serializeTextComponent(this.from));
            json.addProperty("time", (Number)this.ticks);
            return json;
        }

        @Override
        public int compareTo(Message o) {
            return Long.compare(o.ticks, this.ticks);
        }
    }
}

