/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.lib.util.misc;

import com.feed_the_beast.ftbl.api.ICustomName;
import com.feed_the_beast.ftbl.lib.gui.GuiIcons;
import com.feed_the_beast.ftbl.lib.icon.Icon;
import com.feed_the_beast.ftbl.lib.internal.FTBLibFinals;
import com.feed_the_beast.ftbl.lib.util.LangKey;
import com.feed_the_beast.ftbl.lib.util.misc.NameMap;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.text.ITextComponent;

public enum EnumRedstoneMode implements IStringSerializable,
ICustomName
{
    DISABLED("disabled"),
    ACTIVE_HIGH("active_high"),
    ACTIVE_LOW("active_low"),
    PULSE("pulse");

    public static final NameMap<EnumRedstoneMode> NAME_MAP;
    public static final NameMap<EnumRedstoneMode> NAME_MAP_WITH_PULSE;
    public static final LangKey ENUM_LANG_KEY;
    private final LangKey langKey;
    private final String name;

    private EnumRedstoneMode(String n2) {
        this.name = n2;
        this.langKey = FTBLibFinals.lang("redstonemode." + this.name, new Class[0]);
    }

    public LangKey getLangKey() {
        return this.langKey;
    }

    public String func_176610_l() {
        return this.name;
    }

    @Override
    public ITextComponent getCustomDisplayName() {
        return this.langKey.textComponent(null);
    }

    public boolean isActive(boolean prevValue, boolean value) {
        switch (this) {
            case DISABLED: {
                return false;
            }
            case ACTIVE_HIGH: {
                return value;
            }
            case ACTIVE_LOW: {
                return !value;
            }
        }
        return false;
    }

    public Icon getIcon() {
        switch (this) {
            case ACTIVE_HIGH: {
                return GuiIcons.RS_HIGH;
            }
            case ACTIVE_LOW: {
                return GuiIcons.RS_LOW;
            }
            case PULSE: {
                return GuiIcons.RS_PULSE;
            }
        }
        return GuiIcons.RS_NONE;
    }

    static {
        NAME_MAP = NameMap.create(DISABLED, DISABLED, ACTIVE_HIGH, ACTIVE_LOW);
        NAME_MAP_WITH_PULSE = NameMap.create(DISABLED, DISABLED, ACTIVE_HIGH, ACTIVE_LOW, PULSE);
        ENUM_LANG_KEY = FTBLibFinals.lang("redstonemode", new Class[0]);
    }
}

