/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.lib.util.misc;

import com.feed_the_beast.ftbl.lib.io.DataIn;
import com.feed_the_beast.ftbl.lib.io.DataOut;
import com.feed_the_beast.ftbl.lib.math.MathUtils;
import com.feed_the_beast.ftbl.lib.tile.EnumSaveType;
import com.feed_the_beast.ftbl.lib.util.StringUtils;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;

public final class NameMap<E>
implements Iterable<E>,
DataIn.Deserializer<E>,
DataOut.Serializer<E> {
    private static final Function<Object, String> DEFAULT_OBJECT_TO_NAME = value -> StringUtils.getId(value, 6);
    private final Function<Object, String> objectToName;
    public final E defaultValue;
    public final Map<String, E> map;
    public final List<String> keys;
    public final List<E> values;

    @SafeVarargs
    public static <T> NameMap<T> create(T defaultValue, Function<Object, String> objectToName, T ... values) {
        ArrayList<T> list = new ArrayList<T>(values.length);
        for (T e : values) {
            if (e == null) continue;
            list.add(e);
        }
        Preconditions.checkState((!list.isEmpty() ? 1 : 0) != 0);
        return new NameMap<T>(defaultValue, objectToName, list);
    }

    @SafeVarargs
    public static <T> NameMap<T> create(T defaultValue, T ... values) {
        return NameMap.create(defaultValue, DEFAULT_OBJECT_TO_NAME, values);
    }

    private NameMap(E def, Function<Object, String> o2n, List<E> v) {
        this.objectToName = o2n;
        this.values = v;
        LinkedHashMap<String, E> map0 = new LinkedHashMap<String, E>(this.values.size());
        for (E value : this.values) {
            map0.put(this.getName(value), value);
        }
        this.map = Collections.unmodifiableMap(map0);
        this.keys = Collections.unmodifiableList(new ArrayList<String>(this.map.keySet()));
        this.defaultValue = this.get(this.getName(def));
    }

    private NameMap(E def, NameMap<E> n) {
        this.objectToName = n.objectToName;
        this.map = n.map;
        this.keys = n.keys;
        this.values = n.values;
        this.defaultValue = this.get(this.getName(def));
    }

    public String getName(Object value) {
        return this.objectToName.apply(value);
    }

    public NameMap<E> withDefault(E def) {
        if (def == this.defaultValue) {
            return this;
        }
        return new NameMap<E>(def, this);
    }

    public E get(@Nullable String s) {
        if (s == null || s.isEmpty() || s.charAt(0) == '-') {
            return this.defaultValue;
        }
        E e = this.map.get(s);
        return e == null ? this.defaultValue : e;
    }

    public E get(int index) {
        return index < 0 || index >= this.values.size() ? this.defaultValue : this.values.get(index);
    }

    public E offset(E value, int index) {
        return this.get(MathUtils.wrap(this.getIndex(value) + index, this.values.size()));
    }

    public E getNext(E value) {
        return this.offset(value, 1);
    }

    public E getPrevious(E value) {
        return this.offset(value, -1);
    }

    public int getIndex(Object e) {
        return this.values.indexOf(e);
    }

    public int getStringIndex(String s) {
        return this.getIndex(this.map.get(s));
    }

    public void writeToNBT(NBTTagCompound nbt, String name, EnumSaveType type, Object value) {
        if (value == this.defaultValue) {
            return;
        }
        if (!type.save) {
            int index = this.getIndex(value);
            if (index == 0) {
                return;
            }
            if (this.values.size() >= 128) {
                nbt.func_74777_a(name, (short)index);
            } else {
                nbt.func_74774_a(name, (byte)index);
            }
        } else {
            nbt.func_74778_a(name, this.getName(value));
        }
    }

    public E readFromNBT(NBTTagCompound nbt, String name, EnumSaveType type) {
        if (!nbt.func_74764_b(name)) {
            return this.defaultValue;
        }
        return !type.save || nbt.func_150297_b(name, 99) ? this.get(nbt.func_74762_e(name)) : this.get(nbt.func_74779_i(name));
    }

    public E getRandom(Random rand) {
        return this.values.get(rand.nextInt(this.values.size()));
    }

    @Override
    public Iterator<E> iterator() {
        return this.values.iterator();
    }

    public Comparator<E> getComparator() {
        return Comparator.comparing(this::getName);
    }

    @Override
    public void write(DataOut data, E object) {
        int index = this.getIndex(object);
        if (this.values.size() >= 256) {
            data.writeShort(index);
        } else {
            data.writeByte(index);
        }
    }

    @Override
    public E read(DataIn data) {
        return this.get(this.values.size() >= 256 ? data.readUnsignedShort() : (int)data.readUnsignedByte());
    }
}

