/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.lib.util.text_components;

import com.feed_the_beast.ftbl.api.INotification;
import com.feed_the_beast.ftbl.lib.util.StringJoiner;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;

public class Notification
extends TextComponentString
implements INotification {
    private final ResourceLocation id;
    private int timer;
    private boolean important;

    public static Notification of(ResourceLocation id, String text, ITextComponent ... lines) {
        Notification n = new Notification(id, text);
        for (ITextComponent line : lines) {
            n.addLine(line);
        }
        return n;
    }

    public static Notification of(ResourceLocation id, ITextComponent ... lines) {
        return Notification.of(id, "", lines);
    }

    private Notification(ResourceLocation i, String text) {
        super(text);
        this.id = i;
        this.timer = 60;
        this.important = false;
    }

    public Notification(INotification n) {
        this(n.getId(), n.func_150261_e());
        this.func_150255_a(n.func_150256_b().func_150232_l());
        for (ITextComponent line : n.func_150253_a()) {
            this.func_150253_a().add(line.func_150259_f());
        }
        this.setTimer(n.getTimer());
    }

    public Notification addLine(ITextComponent line) {
        if (!this.func_150253_a().isEmpty()) {
            this.appendText("\n");
        }
        this.appendSibling(line);
        return this;
    }

    public Notification setError() {
        this.func_150256_b().func_150238_a(TextFormatting.DARK_RED);
        this.important = true;
        return this;
    }

    public Notification appendText(String text) {
        return this.appendSibling((ITextComponent)new TextComponentString(text));
    }

    public Notification appendSibling(ITextComponent component) {
        super.func_150257_a(component);
        return this;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object o) {
        return o == this || o instanceof INotification && ((INotification)o).getId().equals((Object)this.getId());
    }

    public String toString() {
        return "Notification{" + StringJoiner.with(", ").joinObjects("id=" + this.id, "siblings=" + this.field_150264_a, "style=" + this.func_150256_b(), "timer=" + this.timer, "important=" + this.important) + '}';
    }

    @Override
    public ResourceLocation getId() {
        return this.id;
    }

    @Override
    public int getTimer() {
        return this.timer;
    }

    public Notification setTimer(int t) {
        this.timer = t;
        return this;
    }

    @Override
    public boolean isImportant() {
        return this.important;
    }

    public Notification setImportant(boolean v) {
        this.important = v;
        return this;
    }

    public Notification createCopy() {
        return new Notification(this);
    }
}

