/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.net;

import com.feed_the_beast.ftbl.api.EnumTeamStatus;
import com.feed_the_beast.ftbl.api.FTBLibAPI;
import com.feed_the_beast.ftbl.api.IForgePlayer;
import com.feed_the_beast.ftbl.api.IForgeTeam;
import com.feed_the_beast.ftbl.api_impl.FTBLibTeamGuiActions;
import com.feed_the_beast.ftbl.client.teamsgui.GuiManageAllies;
import com.feed_the_beast.ftbl.client.teamsgui.GuiManageEnemies;
import com.feed_the_beast.ftbl.client.teamsgui.GuiManageMembers;
import com.feed_the_beast.ftbl.client.teamsgui.GuiManageModerators;
import com.feed_the_beast.ftbl.client.teamsgui.GuiTransferOwnership;
import com.feed_the_beast.ftbl.lib.io.DataIn;
import com.feed_the_beast.ftbl.lib.io.DataOut;
import com.feed_the_beast.ftbl.lib.net.MessageToClient;
import com.feed_the_beast.ftbl.lib.net.NetworkWrapper;
import com.feed_the_beast.ftbl.net.FTBLibNetHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;

public class MessageMyTeamPlayerList
extends MessageToClient<MessageMyTeamPlayerList> {
    private ResourceLocation id;
    private Collection<Entry> entries;

    public MessageMyTeamPlayerList() {
    }

    public MessageMyTeamPlayerList(ResourceLocation _id, IForgeTeam team, IForgePlayer player, Predicate<EnumTeamStatus> predicate) {
        this.id = _id;
        this.entries = new ArrayList<Entry>();
        for (IForgePlayer iForgePlayer : FTBLibAPI.API.getUniverse().getPlayers()) {
            EnumTeamStatus status;
            if (iForgePlayer == player || iForgePlayer.isFake() || (status = team.getHighestStatus(iForgePlayer)) == EnumTeamStatus.OWNER || !predicate.test(status)) continue;
            this.entries.add(new Entry(iForgePlayer, status, team.isRequestingInvite(iForgePlayer)));
        }
    }

    @Override
    public NetworkWrapper getWrapper() {
        return FTBLibNetHandler.MY_TEAM;
    }

    @Override
    public void writeData(DataOut data) {
        data.writeResourceLocation(this.id);
        data.writeCollection(this.entries, Entry.SERIALIZER);
    }

    @Override
    public void readData(DataIn data) {
        this.id = data.readResourceLocation();
        this.entries = data.readCollection(Entry.DESERIALIZER);
    }

    @Override
    public void onMessage(MessageMyTeamPlayerList m, EntityPlayer player) {
        if (m.id.equals((Object)FTBLibTeamGuiActions.MEMBERS.getId())) {
            new GuiManageMembers(m.entries).openGuiLater();
        } else if (m.id.equals((Object)FTBLibTeamGuiActions.ALLIES.getId())) {
            new GuiManageAllies(m.entries).openGuiLater();
        } else if (m.id.equals((Object)FTBLibTeamGuiActions.MODERATORS.getId())) {
            new GuiManageModerators(m.entries).openGuiLater();
        } else if (m.id.equals((Object)FTBLibTeamGuiActions.ENEMIES.getId())) {
            new GuiManageEnemies(m.entries).openGuiLater();
        } else if (m.id.equals((Object)FTBLibTeamGuiActions.TRANSFER_OWNERSHIP.getId())) {
            new GuiTransferOwnership(m.entries).openGuiLater();
        }
    }

    public static class Entry {
        private static final DataOut.Serializer<Entry> SERIALIZER = (data, object) -> object.writeData(data);
        private static final DataIn.Deserializer<Entry> DESERIALIZER = Entry::new;
        public final UUID uuid;
        public final String name;
        public EnumTeamStatus status;
        public boolean requestingInvite;

        private Entry(DataIn data) {
            this.uuid = data.readUUID();
            this.name = data.readString();
            this.status = data.read(EnumTeamStatus.NAME_MAP);
            this.requestingInvite = data.readBoolean();
        }

        public Entry(IForgePlayer player, EnumTeamStatus s, boolean i) {
            this.uuid = player.getId();
            this.name = player.func_176610_l();
            this.status = s;
            this.requestingInvite = i;
        }

        private void writeData(DataOut data) {
            data.writeUUID(this.uuid);
            data.writeString(this.name);
            data.write(EnumTeamStatus.NAME_MAP, this.status);
            data.writeBoolean(this.requestingInvite);
        }

        public int getSortIndex() {
            return this.requestingInvite ? 1000 : Math.max(this.status.getStatus(), this.status == EnumTeamStatus.ENEMY ? 1 : 0);
        }
    }
}

