/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.net;

import com.feed_the_beast.ftbl.api.player.IGuiProvider;
import com.feed_the_beast.ftbl.client.FTBLibModClient;
import com.feed_the_beast.ftbl.lib.client.ClientUtils;
import com.feed_the_beast.ftbl.lib.io.DataIn;
import com.feed_the_beast.ftbl.lib.io.DataOut;
import com.feed_the_beast.ftbl.lib.net.MessageToClient;
import com.feed_the_beast.ftbl.lib.net.NetworkWrapper;
import com.feed_the_beast.ftbl.net.FTBLibNetHandler;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MessageOpenGui
extends MessageToClient<MessageOpenGui> {
    private ResourceLocation guiId;
    private BlockPos pos;
    private NBTTagCompound nbt;
    private int windowId;

    public MessageOpenGui() {
    }

    public MessageOpenGui(ResourceLocation key, BlockPos p, @Nullable NBTTagCompound tag, int wid) {
        this.guiId = key;
        this.pos = p;
        this.nbt = tag;
        this.windowId = wid;
    }

    @Override
    public NetworkWrapper getWrapper() {
        return FTBLibNetHandler.GENERAL;
    }

    @Override
    public void writeData(DataOut data) {
        data.writeResourceLocation(this.guiId);
        data.writePos((Vec3i)this.pos);
        data.writeNBT(this.nbt);
        data.writeByte(this.windowId);
    }

    @Override
    public void readData(DataIn data) {
        this.guiId = data.readResourceLocation();
        this.pos = data.readPos();
        this.nbt = data.readNBT();
        this.windowId = data.readUnsignedByte();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onMessage(MessageOpenGui m, EntityPlayer player) {
        GuiScreen g;
        IGuiProvider guiProvider = FTBLibModClient.getGui(m.guiId);
        if (guiProvider != null && (g = guiProvider.getGui(player, m.pos, m.nbt)) != null) {
            ClientUtils.MC.func_147108_a(g);
            player.field_71070_bA.field_75152_c = m.windowId;
        }
    }
}

