/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.net;

import com.feed_the_beast.ftbl.FTBLibModCommon;
import com.feed_the_beast.ftbl.api.IForgePlayer;
import com.feed_the_beast.ftbl.api.ISyncData;
import com.feed_the_beast.ftbl.api_impl.SharedClientData;
import com.feed_the_beast.ftbl.api_impl.SharedServerData;
import com.feed_the_beast.ftbl.lib.client.ClientUtils;
import com.feed_the_beast.ftbl.lib.io.DataIn;
import com.feed_the_beast.ftbl.lib.io.DataOut;
import com.feed_the_beast.ftbl.lib.net.MessageToClient;
import com.feed_the_beast.ftbl.lib.net.NetworkWrapper;
import com.feed_the_beast.ftbl.net.FTBLibNetHandler;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class MessageSyncData
extends MessageToClient<MessageSyncData> {
    private int flags;
    private UUID universeId;
    private NBTTagCompound syncData;
    private Collection<String> optionalServerMods;

    public MessageSyncData() {
    }

    public MessageSyncData(EntityPlayerMP player, IForgePlayer forgePlayer) {
        this.flags = 0;
        this.universeId = SharedServerData.INSTANCE.getUniverseId();
        this.syncData = new NBTTagCompound();
        for (Map.Entry<String, ISyncData> entry : FTBLibModCommon.SYNCED_DATA.entrySet()) {
            this.syncData.func_74782_a(entry.getKey(), (NBTBase)entry.getValue().writeSyncData(player, forgePlayer));
        }
        this.optionalServerMods = SharedServerData.INSTANCE.optionalServerMods;
    }

    @Override
    public NetworkWrapper getWrapper() {
        return FTBLibNetHandler.GENERAL;
    }

    @Override
    public void writeData(DataOut data) {
        data.writeByte(this.flags);
        data.writeUUID(this.universeId);
        data.writeNBT(this.syncData);
        data.writeCollection(this.optionalServerMods, DataOut.STRING);
    }

    @Override
    public void readData(DataIn data) {
        this.flags = data.readByte();
        this.universeId = data.readUUID();
        this.syncData = data.readNBT();
        this.optionalServerMods = data.readCollection(DataIn.STRING);
    }

    @Override
    public void onMessage(MessageSyncData m, EntityPlayer player) {
        SharedClientData.INSTANCE.reset();
        SharedClientData.INSTANCE.universeId = m.universeId;
        SharedClientData.INSTANCE.optionalServerMods.addAll(m.optionalServerMods);
        for (String key : m.syncData.func_150296_c()) {
            ISyncData nbt = FTBLibModCommon.SYNCED_DATA.get(key);
            if (nbt == null) continue;
            nbt.readSyncData(m.syncData.func_74775_l(key));
        }
        ClientUtils.CACHED_SKINS.clear();
    }
}

