/*
 * Decompiled with CFR 0.152.
 */
package jeresources.config;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import jeresources.config.Settings;
import jeresources.util.TranslationHelper;
import net.minecraftforge.common.config.ConfigElement;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.client.config.IConfigElement;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ConfigHandler {
    public static Configuration config;
    private static File configDir;
    private static String worldGenFileName;

    public static void init(File configDir) {
        if (config == null) {
            configDir = new File(configDir, "jeresources");
            configDir.mkdir();
            ConfigHandler.configDir = configDir;
            config = new Configuration(new File(configDir, "jeresources.cfg"));
            ConfigHandler.loadConfig();
        }
    }

    public static File getConfigDir() {
        return configDir;
    }

    public static File getWorldGenFile() {
        return new File(configDir, worldGenFileName);
    }

    @SubscribeEvent
    public void onConfigChangedEvent(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equalsIgnoreCase("jeresources")) {
            ConfigHandler.loadConfig();
        }
    }

    private static void loadConfig() {
        Property prop = config.get("general", "itemsPerColumn", 4);
        prop.setComment(TranslationHelper.translateToLocal("jer.config.itemsPerColumn.description"));
        prop.setMinValue(1).setMaxValue(4);
        prop.setLanguageKey("jer.config.itemsPerColumn.title");
        Settings.ITEMS_PER_COLUMN = prop.getInt();
        prop = config.get("general", "itemsPerRow", 4);
        prop.setComment(TranslationHelper.translateToLocal("jer.config.itemsPerRow.description"));
        prop.setMinValue(1).setMaxValue(4);
        prop.setLanguageKey("jer.config.itemsPerRow.title");
        Settings.ITEMS_PER_ROW = prop.getInt();
        prop = config.get("general", "diyData", true);
        prop.setComment(TranslationHelper.translateToLocal("jer.config.diyData.description"));
        prop.setLanguageKey("jer.config.diyData.title");
        prop.requiresMcRestart();
        Settings.useDIYdata = prop.getBoolean();
        prop = config.get("general", "enchantsBlacklist", new String[]{"flimflam", "soulBound"});
        prop.setComment(TranslationHelper.translateToLocal("jer.config.enchantsBlacklist.description"));
        prop.setLanguageKey("jer.config.enchantsBlacklist.title");
        prop.requiresMcRestart();
        Settings.excludedEnchants = prop.getStringList();
        prop = config.get("general", "dimensionsBlacklist", new int[]{-11});
        prop.setComment(TranslationHelper.translateToLocal("jer.config.dimensionsBlacklist.description"));
        prop.setLanguageKey("jer.config.dimensionsBlacklist.title");
        prop.requiresMcRestart();
        Settings.excludedDimensions = IntStream.of(prop.getIntList()).boxed().collect(Collectors.toList());
        if (config.hasChanged()) {
            config.save();
        }
        Settings.reload();
    }

    public static List<IConfigElement> getConfigElements() {
        ArrayList<IConfigElement> list = new ArrayList<IConfigElement>();
        list.addAll(new ConfigElement(config.getCategory("general")).getChildElements());
        return list;
    }

    static {
        worldGenFileName = "world-gen.json";
    }
}

