/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.blocks.workbench;

import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import mcjty.lib.base.ModBase;
import mcjty.lib.base.StyleConfig;
import mcjty.lib.container.GenericGuiContainer;
import mcjty.lib.entity.GenericEnergyStorageTileEntity;
import mcjty.lib.entity.GenericTileEntity;
import mcjty.lib.gui.Scrollable;
import mcjty.lib.gui.Window;
import mcjty.lib.gui.events.SelectionEvent;
import mcjty.lib.gui.layout.HorizontalAlignment;
import mcjty.lib.gui.layout.Layout;
import mcjty.lib.gui.layout.LayoutHint;
import mcjty.lib.gui.layout.PositionalLayout;
import mcjty.lib.gui.widgets.AbstractContainerWidget;
import mcjty.lib.gui.widgets.AbstractWidget;
import mcjty.lib.gui.widgets.BlockRender;
import mcjty.lib.gui.widgets.EnergyBar;
import mcjty.lib.gui.widgets.Label;
import mcjty.lib.gui.widgets.Panel;
import mcjty.lib.gui.widgets.Slider;
import mcjty.lib.gui.widgets.TextField;
import mcjty.lib.gui.widgets.ToggleButton;
import mcjty.lib.gui.widgets.Widget;
import mcjty.lib.gui.widgets.WidgetList;
import mcjty.lib.network.Argument;
import mcjty.rftoolsdim.RFToolsDim;
import mcjty.rftoolsdim.blocks.workbench.DimletWorkbenchContainer;
import mcjty.rftoolsdim.blocks.workbench.DimletWorkbenchTileEntity;
import mcjty.rftoolsdim.config.Settings;
import mcjty.rftoolsdim.dimensions.dimlets.DimletKey;
import mcjty.rftoolsdim.dimensions.dimlets.KnownDimletConfiguration;
import mcjty.rftoolsdim.dimensions.dimlets.types.DimletCraftingTools;
import mcjty.rftoolsdim.items.ModItems;
import mcjty.rftoolsdim.network.RFToolsDimMessages;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.inventory.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import org.apache.commons.lang3.tuple.Pair;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public class GuiDimletWorkbench
extends GenericGuiContainer<DimletWorkbenchTileEntity> {
    public static final int WORKBENCH_WIDTH = 256;
    public static final int WORKBENCH_HEIGHT = 244;
    private EnergyBar energyBar;
    private ToggleButton extractButton;
    private TextField searchBar;
    private WidgetList itemList;
    private Slider slider;
    private boolean listDirty = true;
    private static final ResourceLocation iconLocation = new ResourceLocation("rftoolsdim", "textures/gui/dimletworkbench.png");
    private static final ResourceLocation iconGuiElements = new ResourceLocation("rftoolsdim", "textures/gui/guielements.png");

    public GuiDimletWorkbench(DimletWorkbenchTileEntity dimletWorkbenchTileEntity, DimletWorkbenchContainer container) {
        super((ModBase)RFToolsDim.instance, RFToolsDimMessages.INSTANCE, (GenericTileEntity)dimletWorkbenchTileEntity, (Container)container, RFToolsDim.GUI_MANUAL_DIMENSION, "create");
        this.field_146999_f = 256;
        this.field_147000_g = 244;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.searchBar = ((TextField)new TextField(this.field_146297_k, (Gui)this).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(120, 7, 128, 16))).addTextEvent((widget, string) -> {
            this.itemList.setSelected(-1);
            this.listDirty = true;
        });
        this.itemList = ((WidgetList)new WidgetList(this.field_146297_k, (Gui)this).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(120, 25, 118, 133))).setLeftMargin(0).setRowheight(-1).addSelectionEvent(new SelectionEvent(){

            public void select(Widget widget, int i) {
            }

            public void doubleClick(Widget widget, int i) {
                EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
                if (player.func_184812_l_() && (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54))) {
                    GuiDimletWorkbench.this.cheatDimlet();
                } else {
                    GuiDimletWorkbench.this.suggestParts();
                }
            }
        });
        this.slider = ((Slider)((Slider)new Slider(this.field_146297_k, (Gui)this).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(239, 25, 9, 133))).setDesiredWidth(11)).setVertical().setScrollable((Scrollable)this.itemList);
        int maxEnergyStored = ((DimletWorkbenchTileEntity)this.tileEntity).getMaxEnergyStored();
        this.energyBar = ((EnergyBar)new EnergyBar(this.field_146297_k, (Gui)this).setVertical().setMaxValue(maxEnergyStored).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(88, 9, 30, 10))).setShowText(false).setHorizontal();
        this.energyBar.setValue(GenericEnergyStorageTileEntity.getCurrentRF());
        this.extractButton = (ToggleButton)((ToggleButton)((ToggleButton)new ToggleButton(this.field_146297_k, (Gui)this).setText("Extract")).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(30, 7, 56, 14))).setCheckMarker(true).addButtonEvent(parent -> this.setExtractMode()).setTooltips(new String[]{"If on dimlets will be reconstructed into parts"});
        this.extractButton.setPressed(((DimletWorkbenchTileEntity)this.tileEntity).isExtractMode());
        AbstractContainerWidget toplevel = ((Panel)((Panel)((Panel)((Panel)((Panel)new Panel(this.field_146297_k, (Gui)this).setBackground(iconLocation)).setLayout((Layout)new PositionalLayout()).addChild((Widget)this.extractButton)).addChild((Widget)this.energyBar)).addChild((Widget)this.itemList)).addChild((Widget)this.slider)).addChild((Widget)this.searchBar);
        toplevel.setBounds(new Rectangle(this.field_147003_i, this.field_147009_r, this.field_146999_f, this.field_147000_g));
        this.listDirty = true;
        this.window = new Window((GuiScreen)this, (Widget)toplevel);
    }

    private void cheatDimlet() {
        int selected = this.itemList.getSelected();
        if (selected == -1) {
            return;
        }
        Widget widget = this.itemList.getChild(selected);
        Object userObject = widget.getUserObject();
        if (userObject instanceof DimletKey) {
            DimletKey key = (DimletKey)userObject;
            this.sendServerCommand(RFToolsDimMessages.INSTANCE, "cheatDimlet", new Argument[]{new Argument("type", key.getType().dimletType.getName()), new Argument("id", key.getId())});
        }
    }

    private void suggestParts() {
        int selected = this.itemList.getSelected();
        if (selected == -1) {
            return;
        }
        Widget widget = this.itemList.getChild(selected);
        Object userObject = widget.getUserObject();
        if (userObject instanceof DimletKey) {
            DimletKey key = (DimletKey)userObject;
            this.sendServerCommand(RFToolsDimMessages.INSTANCE, "suggestParts", new Argument[]{new Argument("type", key.getType().dimletType.getName()), new Argument("id", key.getId())});
        }
    }

    private void updateList() {
        if (!this.listDirty) {
            return;
        }
        this.listDirty = false;
        this.itemList.removeChildren();
        Map<DimletKey, Settings> dimlets = KnownDimletConfiguration.getKnownDimlets();
        String filter = this.searchBar.getText().toLowerCase();
        HashMap<Pair, DimletKey> uniquelyNamedDimlets = new HashMap<Pair, DimletKey>();
        for (DimletKey key2 : dimlets.keySet()) {
            Pair k;
            String name;
            if (!this.dimletMatches(filter, key2, name = KnownDimletConfiguration.getDisplayName(key2)) || uniquelyNamedDimlets.containsKey(k = Pair.of((Object)((Object)key2.getType()), (Object)name))) continue;
            uniquelyNamedDimlets.put(k, key2);
        }
        ArrayList keys = new ArrayList(uniquelyNamedDimlets.values());
        keys.sort((a, b) -> {
            int rc = a.getType().compareTo(b.getType());
            if (rc == 0) {
                return a.getId().compareTo(b.getId());
            }
            return rc;
        });
        keys.stream().forEach(key -> this.addItemToList((DimletKey)key, this.itemList));
        if (this.itemList.getFirstSelected() >= this.itemList.getChildCount()) {
            this.itemList.setFirstSelected(0);
        }
    }

    private boolean dimletMatches(String filter, DimletKey key, String name) {
        if (name.toLowerCase().contains(filter)) {
            return true;
        }
        String typeName = key.getType().dimletType.getName();
        return typeName.toLowerCase().contains(filter);
    }

    private void addItemToList(DimletKey key, WidgetList itemList) {
        Panel panel = (Panel)((Panel)new Panel(this.field_146297_k, (Gui)this).setLayout((Layout)new PositionalLayout()).setDesiredWidth(116)).setDesiredHeight(16);
        panel.setUserObject((Object)key);
        itemList.addChild((Widget)panel);
        BlockRender blockRender = (BlockRender)((BlockRender)new BlockRender(this.field_146297_k, (Gui)this).setRenderItem((Object)KnownDimletConfiguration.getDimletStack(key)).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(1, 0, 16, 16))).setUserObject((Object)key);
        panel.addChild((Widget)blockRender);
        String displayName = KnownDimletConfiguration.getDisplayName(key);
        AbstractWidget label = new Label(this.field_146297_k, (Gui)this).setText(displayName).setColor(StyleConfig.colorTextInListNormal).setHorizontalAlignment(HorizontalAlignment.ALIGH_LEFT).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(20, 0, 95, 16)).setUserObject((Object)key);
        panel.addChild((Widget)label);
    }

    private void setExtractMode() {
        ((DimletWorkbenchTileEntity)this.tileEntity).setExtractMode(this.extractButton.isPressed());
        this.sendServerCommand(RFToolsDimMessages.INSTANCE, "setExtractMode", new Argument[]{new Argument("mode", this.extractButton.isPressed())});
    }

    protected void func_146976_a(float v, int i, int i2) {
        int extracting = ((DimletWorkbenchTileEntity)this.tileEntity).getExtracting();
        if (extracting == 0) {
            this.extractButton.setText("Extract");
            this.extractButton.setEnabled(true);
        } else {
            switch (extracting % 4) {
                case 0: {
                    this.extractButton.setText(".");
                    break;
                }
                case 1: {
                    this.extractButton.setText("..");
                    break;
                }
                case 2: {
                    this.extractButton.setText("...");
                    break;
                }
                case 3: {
                    this.extractButton.setText("....");
                }
            }
            this.extractButton.setEnabled(false);
        }
        this.updateList();
        this.setDimletTooltip();
        this.drawWindow();
        this.energyBar.setValue(GenericEnergyStorageTileEntity.getCurrentRF());
        ((DimletWorkbenchTileEntity)this.tileEntity).requestRfFromServer("rftoolsdim");
        ((DimletWorkbenchTileEntity)this.tileEntity).requestExtractingFromServer();
    }

    private void setDimletTooltip() {
        Object userObject;
        this.itemList.setTooltips(new String[]{"All known dimlets"});
        int x = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c;
        int y = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1;
        Widget widget = this.window.getToplevel().getWidgetAtPosition(x, y);
        if (widget != null && (userObject = widget.getUserObject()) instanceof DimletKey) {
            DimletKey key = (DimletKey)userObject;
            Settings settings = KnownDimletConfiguration.getSettings(key);
            int rarity = settings.getRarity();
            int level = DimletCraftingTools.calculateItemLevelFromRarity(rarity);
            ItemStack base = new ItemStack((Item)ModItems.dimletBaseItem, 1);
            ItemStack ctrl = new ItemStack((Item)ModItems.dimletControlCircuitItem, 1, rarity);
            ItemStack energy = new ItemStack((Item)ModItems.dimletEnergyModuleItem, 1, level);
            ItemStack memory = new ItemStack((Item)ModItems.dimletMemoryUnitItem, 1, level);
            ItemStack typectrl = new ItemStack((Item)ModItems.dimletTypeControllerItem, 1, key.getType().ordinal());
            ItemStack essence = key.getType().dimletType.getDefaultEssence(key);
            if (Minecraft.func_71410_x().field_71439_g.func_184812_l_()) {
                if (essence.func_190926_b()) {
                    widget.setTooltips(new String[]{TextFormatting.RED + "Shift-Double-Click to cheat", "Type: " + key.getType().dimletType.getName(), "Rarity: " + settings.getRarity(), "@0@1@2", "@3@4@5", TextFormatting.RED + "(currently not craftable)"});
                } else {
                    widget.setTooltips(new String[]{TextFormatting.RED + "Shift-Double-Click to cheat", "Type: " + key.getType().dimletType.getName(), "Rarity: " + settings.getRarity(), "@0@1@2", "@3@4@5"});
                }
            } else if (essence.func_190926_b()) {
                widget.setTooltips(new String[]{"Type: " + key.getType().dimletType.getName(), "Rarity: " + settings.getRarity(), "@0@1@2", "@3@4@5", TextFormatting.RED + "(currently not craftable)"});
            } else {
                widget.setTooltips(new String[]{"Type: " + key.getType().dimletType.getName(), "Rarity: " + settings.getRarity(), "@0@1@2", "@3@4@5"});
            }
            widget.setTooltipItems(new ItemStack[]{base, ctrl, energy, memory, typectrl, essence});
        }
    }
}

