/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.commands;

import java.util.ArrayList;
import mcjty.rftoolsdim.commands.AbstractRfToolsCommand;
import mcjty.rftoolsdim.dimensions.RfToolsDimensionManager;
import mcjty.rftoolsdim.dimensions.description.DimensionDescriptor;
import mcjty.rftoolsdim.dimensions.dimlets.DimletKey;
import mcjty.rftoolsdim.dimensions.dimlets.types.DimletType;
import mcjty.rftoolsdim.dimensions.types.TerrainType;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;

public class CmdCreateDimension
extends AbstractRfToolsCommand {
    @Override
    public String getHelp() {
        return "<Name> <Terrain>";
    }

    @Override
    public String getCommand() {
        return "createdim";
    }

    @Override
    public int getPermissionLevel() {
        return 3;
    }

    @Override
    public boolean isClientSide() {
        return false;
    }

    @Override
    public void execute(ICommandSender sender, String[] args) {
        if (args.length < 3) {
            TextComponentString component = new TextComponentString(TextFormatting.RED + "The name and terrain parameters are missing!");
            if (sender instanceof EntityPlayer) {
                ((EntityPlayer)sender).func_146105_b((ITextComponent)component, false);
            } else {
                sender.func_145747_a((ITextComponent)component);
            }
            return;
        }
        if (args.length > 3) {
            TextComponentString component = new TextComponentString(TextFormatting.RED + "Too many parameters!");
            if (sender instanceof EntityPlayer) {
                ((EntityPlayer)sender).func_146105_b((ITextComponent)component, false);
            } else {
                sender.func_145747_a((ITextComponent)component);
            }
            return;
        }
        String name = this.fetchString(sender, args, 1, "");
        String terrainName = this.fetchString(sender, args, 2, "Void");
        TerrainType terrainType = TerrainType.getTerrainById(terrainName);
        if (terrainType == null) {
            TextComponentString component = new TextComponentString(TextFormatting.RED + "Unknown terrain type!");
            if (sender instanceof EntityPlayer) {
                ((EntityPlayer)sender).func_146105_b((ITextComponent)component, false);
            } else {
                sender.func_145747_a((ITextComponent)component);
            }
            return;
        }
        if (!(sender instanceof EntityPlayer)) {
            TextComponentString component = new TextComponentString(TextFormatting.RED + "You must be a player to use this command!");
            if (sender instanceof EntityPlayer) {
                ((EntityPlayer)sender).func_146105_b((ITextComponent)component, false);
            } else {
                sender.func_145747_a((ITextComponent)component);
            }
            return;
        }
        EntityPlayer player = (EntityPlayer)sender;
        RfToolsDimensionManager dimensionManager = RfToolsDimensionManager.getDimensionManager(sender.func_130014_f_());
        ArrayList<DimletKey> descriptors = new ArrayList<DimletKey>();
        descriptors.add(new DimletKey(DimletType.DIMLET_TERRAIN, terrainType.getId()));
        DimensionDescriptor descriptor = new DimensionDescriptor(descriptors, 0L);
        int dim = 0;
        try {
            dim = dimensionManager.createNewDimension(sender.func_130014_f_(), descriptor, name, player.func_145748_c_().toString(), player.getPersistentID());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        TextComponentString component = new TextComponentString(TextFormatting.GREEN + "Created dimension: " + dim);
        if (sender instanceof EntityPlayer) {
            ((EntityPlayer)sender).func_146105_b((ITextComponent)component, false);
        } else {
            sender.func_145747_a((ITextComponent)component);
        }
        dimensionManager.save(sender.func_130014_f_());
    }
}

