/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.dimensions.description;

import io.netty.buffer.ByteBuf;
import mcjty.rftoolsdim.dimensions.types.WeatherType;
import net.minecraft.nbt.NBTTagCompound;

public class WeatherDescriptor {
    private final float rainStrength;
    private final float thunderStrength;

    private WeatherDescriptor(Builder builder) {
        this.rainStrength = builder.rainStrength;
        this.thunderStrength = builder.thunderStrength;
    }

    public float getRainStrength() {
        return this.rainStrength;
    }

    public float getThunderStrength() {
        return this.thunderStrength;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeFloat(this.rainStrength);
        buf.writeFloat(this.thunderStrength);
    }

    public void writeToNBT(NBTTagCompound compound) {
        compound.func_74776_a("rainStrength", this.rainStrength);
        compound.func_74776_a("thunderStrength", this.thunderStrength);
    }

    public static class Builder {
        private float rainStrength = -1.0f;
        private float thunderStrength = -1.0f;

        public Builder fromBytes(ByteBuf buf) {
            this.rainStrength = buf.readFloat();
            this.thunderStrength = buf.readFloat();
            return this;
        }

        public Builder fromNBT(NBTTagCompound compound) {
            this.rainStrength = compound.func_74760_g("rainStrength");
            this.thunderStrength = compound.func_74760_g("thunderStrength");
            return this;
        }

        public Builder combine(WeatherDescriptor descriptor) {
            if (descriptor.getRainStrength() > -0.1f) {
                this.rainStrength = descriptor.getRainStrength();
            }
            if (descriptor.getThunderStrength() > -0.1f) {
                this.thunderStrength = descriptor.getThunderStrength();
            }
            return this;
        }

        public Builder rainStrength(float rainStrength) {
            this.rainStrength = rainStrength;
            return this;
        }

        public Builder thunderStrength(float thunderStrength) {
            this.thunderStrength = thunderStrength;
            return this;
        }

        public Builder weatherType(WeatherType weatherType) {
            this.rainStrength = weatherType.getRainStrength();
            this.thunderStrength = weatherType.getThunderStrength();
            return this;
        }

        public WeatherDescriptor build() {
            return new WeatherDescriptor(this);
        }
    }
}

