/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.dimensions.dimlets;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mcjty.lib.varia.Logging;
import mcjty.rftoolsdim.RFToolsDim;
import mcjty.rftoolsdim.compat.ChiselCompat;
import mcjty.rftoolsdim.config.DimletRules;
import mcjty.rftoolsdim.config.Filter;
import mcjty.rftoolsdim.config.GeneralConfiguration;
import mcjty.rftoolsdim.config.Settings;
import mcjty.rftoolsdim.dimensions.description.SkyDescriptor;
import mcjty.rftoolsdim.dimensions.description.WeatherDescriptor;
import mcjty.rftoolsdim.dimensions.dimlets.DimletKey;
import mcjty.rftoolsdim.dimensions.dimlets.DimletObjectMapping;
import mcjty.rftoolsdim.dimensions.dimlets.SkyRegistry;
import mcjty.rftoolsdim.dimensions.dimlets.WeatherRegistry;
import mcjty.rftoolsdim.dimensions.dimlets.types.DimletType;
import mcjty.rftoolsdim.dimensions.types.CelestialBodyType;
import mcjty.rftoolsdim.dimensions.types.ControllerType;
import mcjty.rftoolsdim.dimensions.types.EffectType;
import mcjty.rftoolsdim.dimensions.types.FeatureType;
import mcjty.rftoolsdim.dimensions.types.SkyType;
import mcjty.rftoolsdim.dimensions.types.SpecialType;
import mcjty.rftoolsdim.dimensions.types.StructureType;
import mcjty.rftoolsdim.dimensions.types.TerrainType;
import mcjty.rftoolsdim.dimensions.types.WeatherType;
import mcjty.rftoolsdim.dimensions.world.BiomeControllerMapping;
import mcjty.rftoolsdim.items.ModItems;
import mcjty.rftoolsdim.varia.EntityTools;
import mcjty.rftoolsdim.varia.RFToolsTools;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.Level;

public class KnownDimletConfiguration {
    private static Set<DimletKey> craftableDimlets = new HashSet<DimletKey>();
    private static Map<DimletKey, Settings> knownDimlets = new HashMap<DimletKey, Settings>();
    private static List<List<ItemStack>> randomPartLists = null;

    public static Settings getSettings(DimletKey key) {
        KnownDimletConfiguration.initDimlets();
        return knownDimlets.get(key);
    }

    public static Map<DimletKey, Settings> getKnownDimlets() {
        KnownDimletConfiguration.initDimlets();
        return knownDimlets;
    }

    public static void init() {
        knownDimlets.clear();
        craftableDimlets.clear();
    }

    private static void initDimlets() {
        if (!knownDimlets.isEmpty()) {
            return;
        }
        for (int i = 0; i <= 9; ++i) {
            KnownDimletConfiguration.initDimlet(new DimletKey(DimletType.DIMLET_DIGIT, Integer.toString(i)), "rftoolsdim");
        }
        if (GeneralConfiguration.voidOnly) {
            KnownDimletConfiguration.initDimlet(new DimletKey(DimletType.DIMLET_TERRAIN, TerrainType.TERRAIN_VOID.getId()), "rftoolsdim");
        } else {
            Arrays.stream(TerrainType.values()).forEach(t -> KnownDimletConfiguration.initDimlet(new DimletKey(DimletType.DIMLET_TERRAIN, t.getId()), "rftoolsdim"));
        }
        Arrays.stream(ControllerType.values()).forEach(t -> KnownDimletConfiguration.initDimlet(new DimletKey(DimletType.DIMLET_CONTROLLER, t.getId()), "rftoolsdim"));
        Arrays.stream(FeatureType.values()).forEach(t -> KnownDimletConfiguration.initDimlet(new DimletKey(DimletType.DIMLET_FEATURE, t.getId()), "rftoolsdim"));
        Arrays.stream(EffectType.values()).forEach(t -> KnownDimletConfiguration.initDimlet(new DimletKey(DimletType.DIMLET_EFFECT, t.getId()), "rftoolsdim"));
        Arrays.stream(StructureType.values()).forEach(t -> KnownDimletConfiguration.initDimlet(new DimletKey(DimletType.DIMLET_STRUCTURE, t.getId()), "rftoolsdim"));
        Arrays.stream(SpecialType.values()).forEach(t -> KnownDimletConfiguration.initDimlet(new DimletKey(DimletType.DIMLET_SPECIAL, t.getId()), "rftoolsdim"));
        Biome.field_185377_q.iterator().forEachRemaining(KnownDimletConfiguration::initBiomeDimlet);
        EntityTools.getEntities().forEach(KnownDimletConfiguration::initMobDimlet);
        KnownDimletConfiguration.initMobDimlet(DimletObjectMapping.DEFAULT_ID);
        FluidRegistry.getRegisteredFluids().entrySet().stream().forEach(KnownDimletConfiguration::initFluidDimlet);
        Block.field_149771_c.forEach(KnownDimletConfiguration::initMaterialDimlet);
        KnownDimletConfiguration.initDimlet(new DimletKey(DimletType.DIMLET_MATERIAL, Blocks.field_150348_b.getRegistryName() + "@0"), "minecraft");
        KnownDimletConfiguration.initDimlet(new DimletKey(DimletType.DIMLET_LIQUID, Blocks.field_150355_j.getRegistryName() + "@0"), "minecraft");
        KnownDimletConfiguration.initDimlet(new DimletKey(DimletType.DIMLET_TIME, "Normal"), "rftoolsdim");
        KnownDimletConfiguration.initDimlet(new DimletKey(DimletType.DIMLET_TIME, "Noon"), "rftoolsdim");
        KnownDimletConfiguration.initDimlet(new DimletKey(DimletType.DIMLET_TIME, "Midnight"), "rftoolsdim");
        KnownDimletConfiguration.initDimlet(new DimletKey(DimletType.DIMLET_TIME, "Morning"), "rftoolsdim");
        KnownDimletConfiguration.initDimlet(new DimletKey(DimletType.DIMLET_TIME, "Evening"), "rftoolsdim");
        KnownDimletConfiguration.initDimlet(new DimletKey(DimletType.DIMLET_TIME, "Fast"), "rftoolsdim");
        KnownDimletConfiguration.initDimlet(new DimletKey(DimletType.DIMLET_TIME, "Slow"), "rftoolsdim");
        KnownDimletConfiguration.initSkyDimlets();
        KnownDimletConfiguration.initWeatherDimlets();
        BiomeControllerMapping.setupControllerBiomes();
    }

    private static void initWeatherDimlets() {
        KnownDimletConfiguration.initWeatherDimlet("Default", new WeatherDescriptor.Builder().build());
        KnownDimletConfiguration.initWeatherDimlet("no.rain", new WeatherDescriptor.Builder().weatherType(WeatherType.WEATHER_NORAIN).build());
        KnownDimletConfiguration.initWeatherDimlet("light.rain", new WeatherDescriptor.Builder().weatherType(WeatherType.WEATHER_LIGHTRAIN).build());
        KnownDimletConfiguration.initWeatherDimlet("hard.rain", new WeatherDescriptor.Builder().weatherType(WeatherType.WEATHER_HARDRAIN).build());
        KnownDimletConfiguration.initWeatherDimlet("no.thunder", new WeatherDescriptor.Builder().weatherType(WeatherType.WEATHER_NOTHUNDER).build());
        KnownDimletConfiguration.initWeatherDimlet("light.thunder", new WeatherDescriptor.Builder().weatherType(WeatherType.WEATHER_LIGHTTHUNDER).build());
        KnownDimletConfiguration.initWeatherDimlet("hard.thunder", new WeatherDescriptor.Builder().weatherType(WeatherType.WEATHER_HARDTHUNDER).build());
    }

    private static void initWeatherDimlet(String id, WeatherDescriptor weatherDescriptor) {
        DimletKey key = new DimletKey(DimletType.DIMLET_WEATHER, id);
        KnownDimletConfiguration.initDimlet(key, "rftoolsdim");
        WeatherRegistry.registerWeather(key, weatherDescriptor);
    }

    private static void initSkyDimlets() {
        KnownDimletConfiguration.initSkyDimlet("normal", new SkyDescriptor.Builder().skyType(SkyType.SKY_NORMAL).build(), false);
        KnownDimletConfiguration.initSkyDimlet("normal.day", new SkyDescriptor.Builder().sunBrightnessFactor(1.0f).build(), false);
        KnownDimletConfiguration.initSkyDimlet("normal.night", new SkyDescriptor.Builder().starBrightnessFactor(1.0f).build(), false);
        KnownDimletConfiguration.initSkyDimlet("dark.day", new SkyDescriptor.Builder().sunBrightnessFactor(0.4f).skyColorFactor(0.6f, 0.6f, 0.6f).build(), false);
        KnownDimletConfiguration.initSkyDimlet("normal.night", new SkyDescriptor.Builder().starBrightnessFactor(1.0f).build(), false);
        KnownDimletConfiguration.initSkyDimlet("bright.night", new SkyDescriptor.Builder().starBrightnessFactor(1.5f).build(), false);
        KnownDimletConfiguration.initSkyDimlet("dark.night", new SkyDescriptor.Builder().starBrightnessFactor(0.4f).build(), false);
        KnownDimletConfiguration.initSkyDimlet("red", new SkyDescriptor.Builder().skyColorFactor(1.0f, 0.2f, 0.2f).build(), false);
        KnownDimletConfiguration.initSkyDimlet("dark.red", new SkyDescriptor.Builder().skyColorFactor(0.6f, 0.0f, 0.0f).build(), false);
        KnownDimletConfiguration.initSkyDimlet("green", new SkyDescriptor.Builder().skyColorFactor(0.2f, 1.0f, 0.2f).build(), false);
        KnownDimletConfiguration.initSkyDimlet("dark.green", new SkyDescriptor.Builder().skyColorFactor(0.0f, 0.6f, 0.0f).build(), false);
        KnownDimletConfiguration.initSkyDimlet("blue", new SkyDescriptor.Builder().skyColorFactor(0.2f, 0.2f, 1.0f).build(), false);
        KnownDimletConfiguration.initSkyDimlet("dark.blue", new SkyDescriptor.Builder().skyColorFactor(0.0f, 0.0f, 0.6f).build(), false);
        KnownDimletConfiguration.initSkyDimlet("yellow", new SkyDescriptor.Builder().skyColorFactor(1.0f, 1.0f, 0.2f).build(), false);
        KnownDimletConfiguration.initSkyDimlet("cyan", new SkyDescriptor.Builder().skyColorFactor(0.2f, 1.0f, 1.0f).build(), false);
        KnownDimletConfiguration.initSkyDimlet("dark.cyan", new SkyDescriptor.Builder().skyColorFactor(0.0f, 0.6f, 0.6f).build(), false);
        KnownDimletConfiguration.initSkyDimlet("purple", new SkyDescriptor.Builder().skyColorFactor(1.0f, 0.2f, 1.0f).build(), false);
        KnownDimletConfiguration.initSkyDimlet("dark.purple", new SkyDescriptor.Builder().skyColorFactor(0.6f, 0.0f, 0.6f).build(), false);
        KnownDimletConfiguration.initSkyDimlet("black", new SkyDescriptor.Builder().skyColorFactor(0.0f, 0.0f, 0.0f).build(), false);
        KnownDimletConfiguration.initSkyDimlet("gold", new SkyDescriptor.Builder().skyColorFactor(1.0f, 0.6f, 0.0f).build(), false);
        KnownDimletConfiguration.initSkyDimlet("normal.fog", new SkyDescriptor.Builder().fogColorFactor(1.0f, 1.0f, 1.0f).build(), false);
        KnownDimletConfiguration.initSkyDimlet("black.fog", new SkyDescriptor.Builder().fogColorFactor(0.0f, 0.0f, 0.0f).build(), false);
        KnownDimletConfiguration.initSkyDimlet("red.fog", new SkyDescriptor.Builder().fogColorFactor(1.0f, 0.2f, 0.2f).build(), false);
        KnownDimletConfiguration.initSkyDimlet("green.fog", new SkyDescriptor.Builder().fogColorFactor(0.2f, 1.0f, 0.2f).build(), false);
        KnownDimletConfiguration.initSkyDimlet("blue.fog", new SkyDescriptor.Builder().fogColorFactor(0.2f, 0.2f, 1.0f).build(), false);
        KnownDimletConfiguration.initSkyDimlet("yellow.fog", new SkyDescriptor.Builder().fogColorFactor(1.0f, 1.0f, 0.2f).build(), false);
        KnownDimletConfiguration.initSkyDimlet("cyan.fog", new SkyDescriptor.Builder().fogColorFactor(0.2f, 1.0f, 1.0f).build(), false);
        KnownDimletConfiguration.initSkyDimlet("purple.fog", new SkyDescriptor.Builder().fogColorFactor(1.0f, 0.2f, 1.0f).build(), false);
        KnownDimletConfiguration.initSkyDimlet("ender", new SkyDescriptor.Builder().skyType(SkyType.SKY_ENDER).build(), false);
        KnownDimletConfiguration.initSkyDimlet("inferno", new SkyDescriptor.Builder().skyType(SkyType.SKY_INFERNO).build(), false);
        KnownDimletConfiguration.initSkyDimlet("stars1", new SkyDescriptor.Builder().skyType(SkyType.SKY_STARS1).build(), false);
        KnownDimletConfiguration.initSkyDimlet("stars2", new SkyDescriptor.Builder().skyType(SkyType.SKY_STARS2).build(), false);
        KnownDimletConfiguration.initSkyDimlet("body.none", new SkyDescriptor.Builder().addBody(CelestialBodyType.BODY_NONE).build(), false);
        KnownDimletConfiguration.initSkyDimlet("body.sun", new SkyDescriptor.Builder().addBody(CelestialBodyType.BODY_SUN).build(), true);
        KnownDimletConfiguration.initSkyDimlet("body.large.sun", new SkyDescriptor.Builder().addBody(CelestialBodyType.BODY_LARGESUN).build(), true);
        KnownDimletConfiguration.initSkyDimlet("body.small.sun", new SkyDescriptor.Builder().addBody(CelestialBodyType.BODY_SMALLSUN).build(), true);
        KnownDimletConfiguration.initSkyDimlet("body.red.sun", new SkyDescriptor.Builder().addBody(CelestialBodyType.BODY_REDSUN).build(), true);
        KnownDimletConfiguration.initSkyDimlet("body.moon", new SkyDescriptor.Builder().addBody(CelestialBodyType.BODY_MOON).build(), true);
        KnownDimletConfiguration.initSkyDimlet("body.large.moon", new SkyDescriptor.Builder().addBody(CelestialBodyType.BODY_LARGEMOON).build(), true);
        KnownDimletConfiguration.initSkyDimlet("body.small.moon", new SkyDescriptor.Builder().addBody(CelestialBodyType.BODY_SMALLMOON).build(), true);
        KnownDimletConfiguration.initSkyDimlet("body.red.moon", new SkyDescriptor.Builder().addBody(CelestialBodyType.BODY_REDMOON).build(), true);
        KnownDimletConfiguration.initSkyDimlet("body.planet", new SkyDescriptor.Builder().addBody(CelestialBodyType.BODY_PLANET).build(), true);
        KnownDimletConfiguration.initSkyDimlet("body.large.planet", new SkyDescriptor.Builder().addBody(CelestialBodyType.BODY_LARGEPLANET).build(), true);
        KnownDimletConfiguration.initSkyDimlet("normal.clouds", new SkyDescriptor.Builder().resetCloudColor().build(), false);
        KnownDimletConfiguration.initSkyDimlet("black.clouds", new SkyDescriptor.Builder().cloudColorFactor(0.0f, 0.0f, 0.0f).build(), false);
        KnownDimletConfiguration.initSkyDimlet("red.clouds", new SkyDescriptor.Builder().cloudColorFactor(1.0f, 0.2f, 0.2f).build(), false);
        KnownDimletConfiguration.initSkyDimlet("green.clouds", new SkyDescriptor.Builder().cloudColorFactor(0.2f, 1.0f, 0.2f).build(), false);
        KnownDimletConfiguration.initSkyDimlet("blue.clouds", new SkyDescriptor.Builder().cloudColorFactor(0.2f, 0.2f, 1.0f).build(), false);
        KnownDimletConfiguration.initSkyDimlet("yellow.clouds", new SkyDescriptor.Builder().cloudColorFactor(1.0f, 1.0f, 0.2f).build(), false);
        KnownDimletConfiguration.initSkyDimlet("cyan.clouds", new SkyDescriptor.Builder().cloudColorFactor(0.2f, 1.0f, 1.0f).build(), false);
        KnownDimletConfiguration.initSkyDimlet("purple.clouds", new SkyDescriptor.Builder().cloudColorFactor(1.0f, 0.2f, 1.0f).build(), false);
    }

    private static void initSkyDimlet(String id, SkyDescriptor descriptor, boolean body) {
        DimletKey key = new DimletKey(DimletType.DIMLET_SKY, id);
        KnownDimletConfiguration.initDimlet(key, "rftoolsdim");
        SkyRegistry.registerSky(key, descriptor, body);
    }

    private static void initBiomeDimlet(Biome biome) {
        ResourceLocation registryName = biome.getRegistryName();
        if (registryName != null) {
            DimletKey key = new DimletKey(DimletType.DIMLET_BIOME, registryName.toString());
            KnownDimletConfiguration.initDimlet(key, RFToolsTools.findModID(biome));
        }
    }

    private static void initMobDimlet(String id) {
        if (DimletObjectMapping.DEFAULT_ID.equals(id)) {
            DimletKey key = new DimletKey(DimletType.DIMLET_MOB, id);
            KnownDimletConfiguration.initDimlet(key, "rftoolsdim");
        } else {
            Class<? extends Entity> entityClass = EntityTools.findClassById(id);
            if (KnownDimletConfiguration.isValidMobClass(entityClass)) {
                DimletKey key = new DimletKey(DimletType.DIMLET_MOB, id);
                KnownDimletConfiguration.initDimlet(key, RFToolsTools.findModID(entityClass));
            }
        }
    }

    private static void initFluidDimlet(Map.Entry<String, Fluid> me) {
        ResourceLocation nameForObject;
        Block block;
        String name;
        if (me.getValue().canBePlacedInWorld() && (name = me.getKey()) != null && !name.isEmpty() && (block = me.getValue().getBlock()) != null && (nameForObject = (ResourceLocation)Block.field_149771_c.func_177774_c((Object)block)) != null) {
            String mod = nameForObject.func_110624_b();
            DimletKey key = new DimletKey(DimletType.DIMLET_LIQUID, block.getRegistryName() + "@0");
            KnownDimletConfiguration.initDimlet(key, mod);
        }
    }

    private static void initDimlet(DimletKey key, String mod) {
        Settings settings = DimletRules.getSettings(key, mod);
        if (!settings.isBlacklisted()) {
            knownDimlets.put(key, settings);
        }
    }

    private static void initMaterialDimlet(Block block) {
        if (block instanceof BlockLiquid) {
            return;
        }
        Set<Filter.Feature> features = KnownDimletConfiguration.getBlockFeatures(block);
        ResourceLocation nameForObject = (ResourceLocation)Block.field_149771_c.func_177774_c((Object)block);
        String mod = nameForObject.func_110624_b();
        for (IBlockState state : block.func_176194_O().func_177619_a()) {
            int meta = state.func_177230_c().func_176201_c(state);
            ItemStack stack = new ItemStack(state.func_177230_c(), 1, state.func_177230_c().func_176201_c(state));
            if (stack.func_77973_b() == null) continue;
            ArrayList propertyNames = new ArrayList(state.func_177227_a());
            propertyNames.sort((o1, o2) -> o1.func_177701_a().compareTo(o2.func_177701_a()));
            ImmutableMap properties = state.func_177228_b();
            HashMap<String, String> props = new HashMap<String, String>();
            for (Map.Entry entry : properties.entrySet()) {
                props.put(((IProperty)entry.getKey()).func_177701_a(), ((Comparable)entry.getValue()).toString());
            }
            DimletKey key = new DimletKey(DimletType.DIMLET_MATERIAL, block.getRegistryName() + "@" + meta);
            Settings settings = DimletRules.getSettings(key, mod, features, props);
            if (settings.isBlacklisted()) continue;
            knownDimlets.put(key, settings);
        }
    }

    public static Set<Filter.Feature> getBlockFeatures(Block block) {
        EnumSet<Filter.Feature> features = EnumSet.noneOf(Filter.Feature.class);
        ItemStack stack = null;
        try {
            stack = new ItemStack(block, 1, Short.MAX_VALUE);
        }
        catch (Exception e) {
            Logging.getLogger().log(Level.ERROR, "Failed to create a dimlet for block " + block.getRegistryName() + "! Please report to the correct mod!", (Throwable)e);
            return features;
        }
        int[] iDs = null;
        if (!stack.func_190926_b() && stack.func_77973_b() != null) {
            iDs = OreDictionary.getOreIDs((ItemStack)stack);
        }
        if (iDs != null && iDs.length > 0) {
            features.add(Filter.Feature.OREDICT);
        }
        if (block instanceof BlockFalling) {
            features.add(Filter.Feature.FALLING);
        }
        if (block.hasTileEntity(block.func_176223_P())) {
            features.add(Filter.Feature.TILEENTITY);
        }
        if (block instanceof IPlantable) {
            features.add(Filter.Feature.PLANTABLE);
        }
        if (!block.func_149730_j(block.func_176223_P())) {
            features.add(Filter.Feature.NOFULLBLOCK);
        }
        return features;
    }

    public static void dumpMobs() {
        EntityTools.getEntities().forEach(KnownDimletConfiguration::dumpMob);
    }

    private static void dumpMob(String id) {
        Class<? extends Entity> entityClass = EntityTools.findClassById(id);
        if (KnownDimletConfiguration.isValidMobClass(entityClass)) {
            DimletKey key = new DimletKey(DimletType.DIMLET_MOB, id);
            String mod = RFToolsTools.findModID(entityClass);
            Settings settings = DimletRules.getSettings(key, mod);
            String resourceName = EntityTools.findEntityIdByClass(entityClass);
            String readableName = EntityTools.findEntityLocNameByClass(entityClass);
            Logging.log((String)(resourceName + " (" + resourceName + ", " + readableName + "): " + settings.toString()));
        }
    }

    private static boolean isValidMobClass(Class<? extends Entity> entityClass) {
        if (!EntityLivingBase.class.isAssignableFrom(entityClass)) {
            return false;
        }
        return !Modifier.isAbstract(entityClass.getModifiers());
    }

    public static ItemStack getDimletStack(DimletKey key) {
        ItemStack stack = new ItemStack((Item)ModItems.knownDimletItem, 1, key.getType().ordinal());
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74778_a("dkey", key.getId());
        stack.func_77982_d(compound);
        return stack;
    }

    public static ItemStack getDimletStack(DimletType type, String id) {
        return KnownDimletConfiguration.getDimletStack(new DimletKey(type, id));
    }

    public static DimletKey getDimletKey(ItemStack dimletStack) {
        DimletType type = DimletType.values()[dimletStack.func_77952_i()];
        NBTTagCompound tagCompound = dimletStack.func_77978_p();
        if (tagCompound != null && tagCompound.func_74764_b("dkey")) {
            return new DimletKey(type, tagCompound.func_74779_i("dkey"));
        }
        return new DimletKey(type, null);
    }

    public static boolean isBlacklisted(DimletKey key) {
        return KnownDimletConfiguration.getSettings(key) == null;
    }

    public static boolean isCraftable(DimletKey key) {
        if (craftableDimlets.isEmpty()) {
            KnownDimletConfiguration.registerCraftables();
        }
        return craftableDimlets.contains(key);
    }

    private static void registerCraftables() {
        craftableDimlets.add(new DimletKey(DimletType.DIMLET_EFFECT, "None"));
        craftableDimlets.add(new DimletKey(DimletType.DIMLET_FEATURE, "None"));
        craftableDimlets.add(new DimletKey(DimletType.DIMLET_STRUCTURE, "None"));
        craftableDimlets.add(new DimletKey(DimletType.DIMLET_TERRAIN, "Void"));
        if (!GeneralConfiguration.voidOnly) {
            craftableDimlets.add(new DimletKey(DimletType.DIMLET_TERRAIN, "Flat"));
        }
        craftableDimlets.add(new DimletKey(DimletType.DIMLET_CONTROLLER, DimletObjectMapping.DEFAULT_ID));
        craftableDimlets.add(new DimletKey(DimletType.DIMLET_CONTROLLER, "Single"));
        craftableDimlets.add(new DimletKey(DimletType.DIMLET_MATERIAL, Blocks.field_150348_b.getRegistryName() + "@0"));
        craftableDimlets.add(new DimletKey(DimletType.DIMLET_LIQUID, Blocks.field_150355_j.getRegistryName() + "@0"));
        craftableDimlets.add(new DimletKey(DimletType.DIMLET_SKY, "normal"));
        craftableDimlets.add(new DimletKey(DimletType.DIMLET_SKY, "normal.day"));
        craftableDimlets.add(new DimletKey(DimletType.DIMLET_SKY, "normal.night"));
        craftableDimlets.add(new DimletKey(DimletType.DIMLET_MOB, DimletObjectMapping.DEFAULT_ID));
        craftableDimlets.add(new DimletKey(DimletType.DIMLET_TIME, "Normal"));
        craftableDimlets.add(new DimletKey(DimletType.DIMLET_WEATHER, DimletObjectMapping.DEFAULT_ID));
        craftableDimlets.add(new DimletKey(DimletType.DIMLET_DIGIT, "0"));
        craftableDimlets.add(new DimletKey(DimletType.DIMLET_DIGIT, "1"));
        craftableDimlets.add(new DimletKey(DimletType.DIMLET_DIGIT, "2"));
        craftableDimlets.add(new DimletKey(DimletType.DIMLET_DIGIT, "3"));
        craftableDimlets.add(new DimletKey(DimletType.DIMLET_DIGIT, "4"));
        craftableDimlets.add(new DimletKey(DimletType.DIMLET_DIGIT, "5"));
        craftableDimlets.add(new DimletKey(DimletType.DIMLET_DIGIT, "6"));
        craftableDimlets.add(new DimletKey(DimletType.DIMLET_DIGIT, "7"));
        craftableDimlets.add(new DimletKey(DimletType.DIMLET_DIGIT, "8"));
        craftableDimlets.add(new DimletKey(DimletType.DIMLET_DIGIT, "9"));
    }

    public static Set<DimletKey> getCraftableDimlets() {
        if (craftableDimlets.isEmpty()) {
            KnownDimletConfiguration.registerCraftables();
        }
        return craftableDimlets;
    }

    public static boolean isSeedDimlet(DimletKey key) {
        return key.getType() == DimletType.DIMLET_SPECIAL && "Seed".equals(key.getId());
    }

    public static String getDisplayName(DimletKey key) {
        switch (key.getType()) {
            case DIMLET_BIOME: {
                Biome biome = (Biome)Biome.field_185377_q.func_82594_a((Object)new ResourceLocation(key.getId()));
                return biome == null ? "<invalid>" : biome.field_76791_y;
            }
            case DIMLET_LIQUID: {
                Block fluid = DimletObjectMapping.getFluid(key);
                if (fluid == null) break;
                return fluid.func_149732_F();
            }
            case DIMLET_MATERIAL: {
                String readableName;
                IBlockState state = DimletObjectMapping.getBlock(key);
                if (state == null || state.func_177230_c() == null || state.func_177230_c().getRegistryName() == null) break;
                String modid = state.func_177230_c().getRegistryName().func_110624_b();
                int meta = state.func_177230_c().func_176201_c(state);
                ItemStack stack = new ItemStack(state.func_177230_c(), 1, meta);
                String suffix = "";
                if ("chisel".equals(modid) && RFToolsDim.chisel && (readableName = ChiselCompat.getReadableName(state)) != null) {
                    suffix = ", " + readableName;
                }
                try {
                    return stack.func_77973_b() == null ? "?" : stack.func_82833_r() + suffix;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return "<Bug>";
                }
            }
            case DIMLET_MOB: {
                if (DimletObjectMapping.DEFAULT_ID.equals(key.getId())) {
                    return key.getId();
                }
                Class<? extends Entity> entityClass = EntityTools.findClassById(EntityTools.fixEntityId(key.getId()));
                if (entityClass == null) {
                    return "<Unknown>";
                }
                return EntityTools.findEntityLocNameByClass(entityClass);
            }
            case DIMLET_SKY: {
                return StringUtils.capitalize((String)StringUtils.join((Object[])StringUtils.split((String)key.getId(), (char)'.'), (char)' '));
            }
            case DIMLET_STRUCTURE: {
                return key.getId();
            }
            case DIMLET_TERRAIN: {
                return key.getId();
            }
            case DIMLET_FEATURE: {
                return key.getId();
            }
            case DIMLET_TIME: {
                return key.getId();
            }
            case DIMLET_DIGIT: {
                return key.getId();
            }
            case DIMLET_EFFECT: {
                return key.getId();
            }
            case DIMLET_SPECIAL: {
                return key.getId();
            }
            case DIMLET_CONTROLLER: {
                return key.getId();
            }
            case DIMLET_WEATHER: {
                return StringUtils.capitalize((String)StringUtils.join((Object[])StringUtils.split((String)key.getId(), (char)'.'), (char)' '));
            }
            case DIMLET_PATREON: {
                return key.getId();
            }
        }
        return "Unknown";
    }

    public static List<List<ItemStack>> getRandomPartLists() {
        if (randomPartLists == null) {
            randomPartLists = new ArrayList<List<ItemStack>>();
            randomPartLists.add(Lists.newArrayList((Object[])new ItemStack[]{new ItemStack((Item)ModItems.dimletBaseItem), new ItemStack((Item)ModItems.dimletControlCircuitItem, 1, 0), new ItemStack((Item)ModItems.dimletEnergyModuleItem)}));
            randomPartLists.add(Lists.newArrayList((Object[])new ItemStack[]{new ItemStack((Item)ModItems.dimletControlCircuitItem, 1, 1), new ItemStack((Item)ModItems.dimletEnergyModuleItem, 1, 0), new ItemStack((Item)ModItems.dimletMemoryUnitItem, 1, 0)}));
            randomPartLists.add(Lists.newArrayList((Object[])new ItemStack[]{new ItemStack((Item)ModItems.dimletControlCircuitItem, 1, 2)}));
            ArrayList list3 = Lists.newArrayList((Object[])new ItemStack[]{new ItemStack((Item)ModItems.dimletControlCircuitItem, 1, 3), new ItemStack((Item)ModItems.dimletEnergyModuleItem, 1, 1), new ItemStack((Item)ModItems.dimletMemoryUnitItem, 1, 1)});
            for (DimletType type : DimletType.values()) {
                list3.add(new ItemStack((Item)ModItems.dimletTypeControllerItem, 1, type.ordinal()));
            }
            randomPartLists.add(list3);
            randomPartLists.add(Lists.newArrayList((Object[])new ItemStack[]{new ItemStack((Item)ModItems.dimletControlCircuitItem, 1, 4)}));
            randomPartLists.add(Lists.newArrayList((Object[])new ItemStack[]{new ItemStack((Item)ModItems.dimletControlCircuitItem, 1, 5), new ItemStack((Item)ModItems.dimletEnergyModuleItem, 1, 2), new ItemStack((Item)ModItems.dimletMemoryUnitItem, 1, 2)}));
            randomPartLists.add(Lists.newArrayList((Object[])new ItemStack[]{new ItemStack((Item)ModItems.dimletControlCircuitItem, 1, 6)}));
        }
        return randomPartLists;
    }
}

