/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.items.tools;

import com.blakebr0.cucumber.iface.IRepairMaterial;
import com.blakebr0.mysticalagriculture.MysticalAgriculture;
import com.blakebr0.mysticalagriculture.items.ItemCrafting;
import com.blakebr0.mysticalagriculture.items.ModItems;
import com.blakebr0.mysticalagriculture.items.tools.ToolType;
import com.blakebr0.mysticalagriculture.lib.Tooltips;
import com.blakebr0.mysticalagriculture.util.NBTHelper;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArrow;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatList;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;

public class ItemEssenceBow
extends ItemBow
implements IRepairMaterial {
    public ItemStack repairMaterial;
    public Item.ToolMaterial toolMaterial;
    public float damage;
    public float drawSpeed;
    public TextFormatting color;

    public ItemEssenceBow(String name, Item.ToolMaterial material, float drawSpeed, TextFormatting color) {
        this.func_77655_b("ma." + name);
        this.func_77637_a(MysticalAgriculture.tabMysticalAgriculture);
        this.toolMaterial = material;
        this.damage = material.func_78000_c() / 4.0f;
        this.drawSpeed = drawSpeed;
        this.color = color;
        this.func_77625_d(1);
        this.func_77656_e(material.func_77997_a());
        this.func_185043_a(new ResourceLocation("pull"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World world, @Nullable EntityLivingBase entity) {
                if (entity == null) {
                    return 0.0f;
                }
                ItemStack itemstack = entity.func_184607_cu();
                return !itemstack.func_190926_b() && itemstack.func_77973_b() instanceof ItemEssenceBow ? (float)(stack.func_77988_m() - entity.func_184605_cv()) * ItemEssenceBow.this.getDrawSpeed(stack) / 20.0f : 0.0f;
            }
        });
        this.func_185043_a(new ResourceLocation("pulling"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World world, @Nullable EntityLivingBase entity) {
                return entity != null && entity.func_184587_cr() && entity.func_184607_cu() == stack ? 1.0f : 0.0f;
            }
        });
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World player, List<String> tooltip, ITooltipFlag advanced) {
        int damage = stack.func_77958_k() - stack.func_77952_i();
        tooltip.add(Tooltips.DURABILITY + this.color + (damage > -1 ? Integer.valueOf(damage) : Tooltips.UNLIMITED));
        tooltip.add(Tooltips.DAMAGE + this.color + "+" + this.damage);
        tooltip.add(Tooltips.DRAW_SPEED + this.color + "+" + (int)(this.drawSpeed * 100.0f) + "%");
        if (OreDictionary.itemMatches((ItemStack)this.getRepairMaterial(), (ItemStack)ItemCrafting.itemSupremiumIngot, (boolean)false)) {
            NBTTagCompound tag = NBTHelper.getDataMap(stack);
            if (tag.func_74764_b("ToolType")) {
                tooltip.add(Tooltips.CHARM_SLOT + "\u00a7c" + ToolType.byIndex(tag.func_74762_e("ToolType")).getLocalizedName());
            } else {
                tooltip.add(Tooltips.CHARM_SLOT + "\u00a7c" + Tooltips.EMPTY);
            }
        }
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        return OreDictionary.itemMatches((ItemStack)this.getRepairMaterial(), (ItemStack)repair, (boolean)false);
    }

    public void setRepairMaterial(ItemStack stack) {
        this.repairMaterial = stack;
    }

    public ItemStack getRepairMaterial() {
        return this.repairMaterial;
    }

    public float getDrawSpeed(ItemStack stack) {
        NBTTagCompound tag;
        float multi = 1.0f;
        if (stack.func_77973_b() == ModItems.itemSupremiumBow && (tag = NBTHelper.getDataMap(stack)).func_74764_b("ToolType")) {
            if (tag.func_74762_e("ToolType") == ToolType.QUICK_DRAW.getIndex()) {
                multi = 2.0f;
            } else if (tag.func_74762_e("ToolType") == ToolType.TRIPLE_SHOT.getIndex()) {
                multi = 0.5f;
            }
        }
        return this.drawSpeed * multi + 1.0f;
    }

    protected ItemStack func_185060_a(EntityPlayer player) {
        if (this.func_185058_h_(player.func_184586_b(EnumHand.OFF_HAND))) {
            return player.func_184586_b(EnumHand.OFF_HAND);
        }
        if (this.func_185058_h_(player.func_184586_b(EnumHand.MAIN_HAND))) {
            return player.func_184586_b(EnumHand.MAIN_HAND);
        }
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack itemstack = player.field_71071_by.func_70301_a(i);
            if (!this.func_185058_h_(itemstack)) continue;
            return itemstack;
        }
        return ItemStack.field_190927_a;
    }

    public int getArrowsShot(ItemStack stack) {
        NBTTagCompound tag;
        if (stack.func_77973_b() == ModItems.itemSupremiumBow && (tag = NBTHelper.getDataMap(stack)).func_74764_b("ToolType") && tag.func_74762_e("ToolType") == ToolType.TRIPLE_SHOT.getIndex()) {
            return 3;
        }
        return 1;
    }

    public void func_77615_a(ItemStack stack, World world, EntityLivingBase entityLiving, int timeLeft) {
        if (entityLiving instanceof EntityPlayer) {
            EntityPlayer entityplayer = (EntityPlayer)entityLiving;
            boolean flag = entityplayer.field_71075_bZ.field_75098_d || EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185312_x, (ItemStack)stack) > 0;
            ItemStack itemstack = this.func_185060_a(entityplayer);
            int i = (int)((float)(this.func_77626_a(stack) - timeLeft) * this.getDrawSpeed(stack));
            if ((i = ForgeEventFactory.onArrowLoose((ItemStack)stack, (World)world, (EntityPlayer)((EntityPlayer)entityLiving), (int)i, (!itemstack.func_190926_b() || flag ? 1 : 0) != 0)) < 0) {
                return;
            }
            int ts = this.getArrowsShot(stack);
            for (int xd = 0; xd < ts; ++xd) {
                boolean flag1;
                float f;
                if (itemstack.func_190926_b() && !flag) continue;
                if (itemstack.func_190926_b()) {
                    itemstack = new ItemStack(Items.field_151032_g);
                }
                if (!((double)(f = ItemEssenceBow.func_185059_b((int)i)) >= 0.1)) continue;
                boolean bl = flag1 = entityplayer.field_71075_bZ.field_75098_d || itemstack.func_77973_b() instanceof ItemArrow && ((ItemArrow)itemstack.func_77973_b()).isInfinite(itemstack, stack, entityplayer);
                if (!world.field_72995_K) {
                    int k;
                    int j;
                    ItemArrow itemarrow = (ItemArrow)(itemstack.func_77973_b() instanceof ItemArrow ? itemstack.func_77973_b() : Items.field_151032_g);
                    EntityArrow entityarrow = itemarrow.func_185052_a(world, itemstack, (EntityLivingBase)entityplayer);
                    entityarrow.func_184547_a((Entity)entityplayer, entityplayer.field_70125_A, entityplayer.field_70177_z, 0.0f, f * 3.0f, 1.0f);
                    entityarrow.func_70239_b(entityarrow.func_70242_d() + (double)this.damage);
                    if (f >= 1.0f) {
                        entityarrow.func_70243_d(true);
                    }
                    if ((j = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185309_u, (ItemStack)stack)) > 0) {
                        entityarrow.func_70239_b(entityarrow.func_70242_d() + (double)j * 0.5 + 0.5);
                    }
                    if ((k = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185310_v, (ItemStack)stack)) > 0) {
                        entityarrow.func_70240_a(k);
                    }
                    if (EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185311_w, (ItemStack)stack) > 0) {
                        entityarrow.func_70015_d(100);
                    }
                    stack.func_77972_a(1, (EntityLivingBase)entityplayer);
                    if (flag1) {
                        entityarrow.field_70251_a = EntityArrow.PickupStatus.CREATIVE_ONLY;
                    }
                    world.func_72838_d((Entity)entityarrow);
                }
                world.func_184148_a((EntityPlayer)null, entityplayer.field_70165_t, entityplayer.field_70163_u, entityplayer.field_70161_v, SoundEvents.field_187737_v, SoundCategory.NEUTRAL, 1.0f, 1.0f / (field_77697_d.nextFloat() * 0.4f + 1.2f) + f * 0.5f);
                if (!flag1) {
                    itemstack.func_190918_g(1);
                    if (itemstack.func_190916_E() == 0) {
                        entityplayer.field_71071_by.func_184437_d(itemstack);
                    }
                }
                entityplayer.func_71029_a(StatList.func_188057_b((Item)this));
            }
        }
    }
}

