/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.genetics;

import com.google.common.base.Preconditions;
import com.mojang.authlib.GameProfile;
import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.EnumBeeChromosome;
import forestry.api.apiculture.EnumBeeType;
import forestry.api.apiculture.IAlleleBeeSpecies;
import forestry.api.apiculture.IApiaristTracker;
import forestry.api.apiculture.IBee;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.apiculture.IBeeListener;
import forestry.api.apiculture.IBeeModifier;
import forestry.api.apiculture.IBeeMutation;
import forestry.api.apiculture.IBeeRoot;
import forestry.api.apiculture.IBeekeepingLogic;
import forestry.api.apiculture.IBeekeepingMode;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IAlyzerPlugin;
import forestry.api.genetics.IChromosome;
import forestry.api.genetics.IChromosomeType;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.IMutation;
import forestry.api.genetics.ISpeciesPlugin;
import forestry.api.genetics.ISpeciesType;
import forestry.apiculture.BeeHousingListener;
import forestry.apiculture.BeeHousingModifier;
import forestry.apiculture.BeekeepingLogic;
import forestry.apiculture.ModuleApiculture;
import forestry.apiculture.genetics.ApiaristTracker;
import forestry.apiculture.genetics.Bee;
import forestry.apiculture.genetics.BeeAlyzerPlugin;
import forestry.apiculture.genetics.BeeDefinition;
import forestry.apiculture.genetics.BeeGenome;
import forestry.apiculture.genetics.BeePlugin;
import forestry.apiculture.items.ItemBeeGE;
import forestry.apiculture.items.ItemRegistryApiculture;
import forestry.core.genetics.SpeciesRoot;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BeeRoot
extends SpeciesRoot
implements IBeeRoot {
    private static int beeSpeciesCount = -1;
    private static final List<IBee> beeTemplates = new ArrayList<IBee>();
    private static final List<IBeeMutation> beeMutations = new ArrayList<IBeeMutation>();
    public static final String UID = "rootBees";
    private final List<IBeekeepingMode> beekeepingModes = new ArrayList<IBeekeepingMode>();
    @Nullable
    private static IBeekeepingMode activeBeekeepingMode;

    @Override
    public String getUID() {
        return UID;
    }

    @Override
    public Class<? extends IIndividual> getMemberClass() {
        return IBee.class;
    }

    @Override
    public int getSpeciesCount() {
        if (beeSpeciesCount < 0) {
            beeSpeciesCount = 0;
            for (Map.Entry<String, IAllele> entry : AlleleManager.alleleRegistry.getRegisteredAlleles().entrySet()) {
                if (!(entry.getValue() instanceof IAlleleBeeSpecies) || !((IAlleleBeeSpecies)entry.getValue()).isCounted()) continue;
                ++beeSpeciesCount;
            }
        }
        return beeSpeciesCount;
    }

    @Override
    public boolean isMember(ItemStack stack) {
        return this.getType(stack) != null;
    }

    @Override
    public boolean isMember(ItemStack stack, ISpeciesType type) {
        return this.getType(stack) == type;
    }

    @Override
    public boolean isMember(IIndividual individual) {
        return individual instanceof IBee;
    }

    @Override
    public ItemStack getMemberStack(IIndividual individual, ISpeciesType type) {
        ItemBeeGE beeItem;
        Preconditions.checkArgument((boolean)(individual instanceof IBee), (Object)"individual is not a bee");
        Preconditions.checkArgument((boolean)(type instanceof EnumBeeType), (Object)"type is not an EnumBeeType");
        ItemRegistryApiculture apicultureItems = ModuleApiculture.getItems();
        IBee bee = (IBee)individual;
        switch ((EnumBeeType)type) {
            case QUEEN: {
                beeItem = apicultureItems.beeQueenGE;
                if (bee.getMate() != null) break;
                bee.mate(bee);
                break;
            }
            case PRINCESS: {
                beeItem = apicultureItems.beePrincessGE;
                break;
            }
            case DRONE: {
                beeItem = apicultureItems.beeDroneGE;
                break;
            }
            case LARVAE: {
                beeItem = apicultureItems.beeLarvaeGE;
                break;
            }
            default: {
                throw new RuntimeException("Cannot instantiate a bee of type " + type);
            }
        }
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        bee.writeToNBT(nbttagcompound);
        ItemStack beeStack = new ItemStack((Item)beeItem);
        beeStack.func_77982_d(nbttagcompound);
        return beeStack;
    }

    @Override
    @Nullable
    public EnumBeeType getType(ItemStack stack) {
        Item item = stack.func_77973_b();
        ItemRegistryApiculture apicultureItems = ModuleApiculture.getItems();
        if (apicultureItems.beeDroneGE == item) {
            return EnumBeeType.DRONE;
        }
        if (apicultureItems.beePrincessGE == item) {
            return EnumBeeType.PRINCESS;
        }
        if (apicultureItems.beeQueenGE == item) {
            return EnumBeeType.QUEEN;
        }
        if (apicultureItems.beeLarvaeGE == item) {
            return EnumBeeType.LARVAE;
        }
        return null;
    }

    @Override
    public EnumBeeType getIconType() {
        return EnumBeeType.DRONE;
    }

    @Override
    public boolean isDrone(ItemStack stack) {
        return this.getType(stack) == EnumBeeType.DRONE;
    }

    @Override
    public boolean isMated(ItemStack stack) {
        if (this.getType(stack) != EnumBeeType.QUEEN) {
            return false;
        }
        NBTTagCompound nbt = stack.func_77978_p();
        return nbt != null && nbt.func_74764_b("Mate");
    }

    @Override
    @Nullable
    public IBee getMember(ItemStack stack) {
        if (!this.isMember(stack) || stack.func_77978_p() == null) {
            return null;
        }
        return new Bee(stack.func_77978_p());
    }

    @Override
    public IBee getMember(NBTTagCompound compound) {
        return new Bee(compound);
    }

    @Override
    public IBee getBee(IBeeGenome genome) {
        return new Bee(genome);
    }

    @Override
    public IBee getBee(World world, IBeeGenome genome, IBee mate) {
        return new Bee(genome, mate);
    }

    @Override
    public IBeeGenome templateAsGenome(IAllele[] template) {
        IChromosome[] chromosomes = this.templateAsChromosomes(template);
        return new BeeGenome(chromosomes);
    }

    @Override
    public IBeeGenome templateAsGenome(IAllele[] templateActive, IAllele[] templateInactive) {
        return new BeeGenome(this.templateAsChromosomes(templateActive, templateInactive));
    }

    @Override
    public IBee templateAsIndividual(IAllele[] template) {
        return new Bee(this.templateAsGenome(template));
    }

    @Override
    public IBee templateAsIndividual(IAllele[] templateActive, IAllele[] templateInactive) {
        return new Bee(this.templateAsGenome(templateActive, templateInactive));
    }

    @Override
    public List<IBee> getIndividualTemplates() {
        return beeTemplates;
    }

    @Override
    public void registerTemplate(String identifier, IAllele[] template) {
        IBeeGenome beeGenome = BeeManager.beeRoot.templateAsGenome(template);
        Bee bee = new Bee(beeGenome);
        beeTemplates.add(bee);
        this.speciesTemplates.put(identifier, template);
    }

    @Override
    public IAllele[] getDefaultTemplate() {
        return BeeDefinition.FOREST.getTemplate();
    }

    @Override
    public List<IBeeMutation> getMutations(boolean shuffle) {
        if (shuffle) {
            Collections.shuffle(beeMutations);
        }
        return beeMutations;
    }

    @Override
    public void registerMutation(IMutation mutation) {
        if (AlleleManager.alleleRegistry.isBlacklisted(mutation.getTemplate()[0].getUID())) {
            return;
        }
        if (AlleleManager.alleleRegistry.isBlacklisted(mutation.getAllele0().getUID())) {
            return;
        }
        if (AlleleManager.alleleRegistry.isBlacklisted(mutation.getAllele1().getUID())) {
            return;
        }
        beeMutations.add((IBeeMutation)mutation);
    }

    @Override
    public void resetBeekeepingMode() {
        activeBeekeepingMode = null;
    }

    @Override
    public List<IBeekeepingMode> getBeekeepingModes() {
        return this.beekeepingModes;
    }

    @Override
    public IBeekeepingMode getBeekeepingMode(World world) {
        if (activeBeekeepingMode != null) {
            return activeBeekeepingMode;
        }
        IApiaristTracker tracker = this.getBreedingTracker(world, null);
        String modeName = tracker.getModeName();
        IBeekeepingMode mode = this.getBeekeepingMode(modeName);
        Preconditions.checkNotNull((Object)mode);
        this.setBeekeepingMode(world, mode);
        FMLCommonHandler.instance().getFMLLogger().debug("Set beekeeping mode for a world to " + mode);
        return activeBeekeepingMode;
    }

    @Override
    public void registerBeekeepingMode(IBeekeepingMode mode) {
        this.beekeepingModes.add(mode);
    }

    @Override
    public void setBeekeepingMode(World world, IBeekeepingMode mode) {
        Preconditions.checkNotNull((Object)world);
        Preconditions.checkNotNull((Object)mode);
        activeBeekeepingMode = mode;
        this.getBreedingTracker(world, null).setModeName(mode.getName());
    }

    @Override
    public IBeekeepingMode getBeekeepingMode(String name) {
        for (IBeekeepingMode mode : this.beekeepingModes) {
            if (!mode.getName().equals(name) && !mode.getName().equals(name.toLowerCase(Locale.ENGLISH))) continue;
            return mode;
        }
        FMLCommonHandler.instance().getFMLLogger().debug("Failed to find a beekeeping mode called '%s', reverting to fallback.");
        return this.beekeepingModes.get(0);
    }

    @Override
    public IApiaristTracker getBreedingTracker(World world, @Nullable GameProfile player) {
        String filename = "ApiaristTracker." + (player == null ? "common" : player.getId());
        ApiaristTracker tracker = (ApiaristTracker)world.func_72943_a(ApiaristTracker.class, filename);
        if (tracker == null) {
            tracker = new ApiaristTracker(filename);
            world.func_72823_a(filename, (WorldSavedData)tracker);
        }
        tracker.setUsername(player);
        tracker.setWorld(world);
        return tracker;
    }

    @Override
    public IBeekeepingLogic createBeekeepingLogic(IBeeHousing housing) {
        return new BeekeepingLogic(housing);
    }

    @Override
    public IBeeModifier createBeeHousingModifier(IBeeHousing housing) {
        return new BeeHousingModifier(housing);
    }

    @Override
    public IBeeListener createBeeHousingListener(IBeeHousing housing) {
        return new BeeHousingListener(housing);
    }

    @Override
    public IChromosomeType[] getKaryotype() {
        return EnumBeeChromosome.values();
    }

    @Override
    public IChromosomeType getSpeciesChromosomeType() {
        return EnumBeeChromosome.SPECIES;
    }

    @Override
    public IAlyzerPlugin getAlyzerPlugin() {
        return BeeAlyzerPlugin.INSTANCE;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ISpeciesPlugin getSpeciesPlugin() {
        return BeePlugin.INSTANCE;
    }
}

