/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.items;

import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.EnumBeeType;
import forestry.api.apiculture.IAlleleBeeSpecies;
import forestry.api.apiculture.IBee;
import forestry.api.core.IModelManager;
import forestry.api.core.Tabs;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IAlleleSpecies;
import forestry.apiculture.genetics.BeeGenome;
import forestry.apiculture.genetics.DefaultBeeModelProvider;
import forestry.core.config.Config;
import forestry.core.genetics.ItemGE;
import forestry.core.items.IColoredItem;
import forestry.core.utils.Translator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemBeeGE
extends ItemGE
implements IColoredItem {
    private final EnumBeeType type;

    public ItemBeeGE(EnumBeeType type) {
        super(Tabs.tabApiculture);
        this.type = type;
        if (type != EnumBeeType.DRONE) {
            this.func_77625_d(1);
        }
    }

    @Override
    @Nullable
    public IBee getIndividual(ItemStack itemstack) {
        return BeeManager.beeRoot.getMember(itemstack);
    }

    @Override
    protected IAlleleSpecies getSpecies(ItemStack itemStack) {
        return BeeGenome.getSpecies(itemStack);
    }

    public String func_77653_i(ItemStack itemstack) {
        if (itemstack.func_77978_p() == null) {
            return super.func_77653_i(itemstack);
        }
        IBee individual = BeeManager.beeRoot.getMember(itemstack);
        String customBeeKey = "for.bees.custom." + this.type.getName() + "." + individual.getGenome().getPrimary().getUnlocalizedName().replace("bees.species.", "");
        if (Translator.canTranslateToLocal(customBeeKey)) {
            return Translator.translateToLocal(customBeeKey);
        }
        String beeGrammar = Translator.translateToLocal("for.bees.grammar." + this.type.getName());
        String beeSpecies = individual.getDisplayName();
        String beeType = Translator.translateToLocal("for.bees.grammar." + this.type.getName() + ".type");
        return beeGrammar.replaceAll("%SPECIES", beeSpecies).replaceAll("%TYPE", beeType);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemstack, @Nullable World world, List<String> list, ITooltipFlag flag) {
        if (itemstack.func_77978_p() == null) {
            return;
        }
        if (this.type != EnumBeeType.DRONE) {
            IBee individual = BeeManager.beeRoot.getMember(itemstack);
            if (individual.isNatural()) {
                list.add(TextFormatting.YELLOW + TextFormatting.ITALIC.toString() + Translator.translateToLocal("for.bees.stock.pristine"));
            } else {
                list.add(TextFormatting.YELLOW + Translator.translateToLocal("for.bees.stock.ignoble"));
            }
        }
        super.func_77624_a(itemstack, world, list, flag);
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> subItems) {
        if (this.func_194125_a(tab)) {
            this.addCreativeItems(subItems, true);
        }
    }

    public void addCreativeItems(NonNullList<ItemStack> subItems, boolean hideSecrets) {
        for (IBee bee : BeeManager.beeRoot.getIndividualTemplates()) {
            ItemStack beeStack;
            if (hideSecrets && bee.isSecret() && !Config.isDebug || (beeStack = BeeManager.beeRoot.getMemberStack(bee, this.type)).func_190926_b()) continue;
            subItems.add((Object)beeStack);
        }
    }

    @Override
    public int getColorFromItemstack(ItemStack itemstack, int tintIndex) {
        if (itemstack.func_77978_p() == null) {
            if (tintIndex == 1) {
                return 16768022;
            }
            return 0xFFFFFF;
        }
        IAlleleBeeSpecies species = BeeGenome.getSpecies(itemstack);
        return species.getSpriteColour(tintIndex);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModel(Item item, IModelManager manager) {
        for (IAllele allele : AlleleManager.alleleRegistry.getRegisteredAlleles().values()) {
            if (!(allele instanceof IAlleleBeeSpecies)) continue;
            ((IAlleleBeeSpecies)allele).registerModels(item, manager);
        }
        manager.registerItemModel(item, new BeeMeshDefinition());
    }

    public final EnumBeeType getType() {
        return this.type;
    }

    @SideOnly(value=Side.CLIENT)
    private class BeeMeshDefinition
    implements ItemMeshDefinition {
        private BeeMeshDefinition() {
        }

        public ModelResourceLocation func_178113_a(ItemStack stack) {
            if (!stack.func_77942_o()) {
                return DefaultBeeModelProvider.instance.getModel(ItemBeeGE.this.type);
            }
            IAlleleBeeSpecies species = (IAlleleBeeSpecies)ItemBeeGE.this.getSpecies(stack);
            return species.getModel(ItemBeeGE.this.type);
        }
    }
}

