/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture;

import forestry.api.arboriculture.ITreeGenome;
import forestry.api.arboriculture.TreeManager;
import forestry.api.genetics.IFruitFamily;
import forestry.arboriculture.FruitProviderNone;
import java.awt.Color;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class FruitProviderRipening
extends FruitProviderNone {
    private final Map<ItemStack, Float> products = new HashMap<ItemStack, Float>();
    private int colourCallow = 0xFFFFFF;
    private int diffR;
    private int diffG;
    private int diffB;

    public FruitProviderRipening(String unlocalizedDescription, IFruitFamily family, ItemStack product, float modifier) {
        super(unlocalizedDescription, family);
        this.products.put(product, Float.valueOf(modifier));
    }

    public FruitProviderRipening setColours(Color ripe, Color callow) {
        this.colourCallow = callow.getRGB();
        int ripeRGB = ripe.getRGB();
        this.diffR = (ripeRGB >> 16 & 0xFF) - (this.colourCallow >> 16 & 0xFF);
        this.diffG = (ripeRGB >> 8 & 0xFF) - (this.colourCallow >> 8 & 0xFF);
        this.diffB = (ripeRGB & 0xFF) - (this.colourCallow & 0xFF);
        return this;
    }

    public FruitProviderRipening setRipeningPeriod(int period) {
        this.ripeningPeriod = period;
        return this;
    }

    private float getRipeningStage(int ripeningTime) {
        if (ripeningTime >= this.ripeningPeriod) {
            return 1.0f;
        }
        return (float)ripeningTime / (float)this.ripeningPeriod;
    }

    @Override
    public NonNullList<ItemStack> getFruits(ITreeGenome genome, World world, BlockPos pos, int ripeningTime) {
        NonNullList product = NonNullList.func_191196_a();
        float stage = this.getRipeningStage(ripeningTime);
        if (stage >= 0.5f) {
            float modeYieldMod = TreeManager.treeRoot.getTreekeepingMode(world).getYieldModifier(genome, 1.0f);
            for (Map.Entry<ItemStack, Float> entry : this.products.entrySet()) {
                if (!(world.field_73012_v.nextFloat() <= genome.getYield() * entry.getValue().floatValue() * modeYieldMod * 5.0f * stage)) continue;
                product.add((Object)entry.getKey().func_77946_l());
            }
        }
        return product;
    }

    @Override
    public Map<ItemStack, Float> getProducts() {
        return Collections.unmodifiableMap(this.products);
    }

    @Override
    public boolean isFruitLeaf(ITreeGenome genome, World world, BlockPos pos) {
        return true;
    }

    @Override
    public int getColour(ITreeGenome genome, IBlockAccess world, BlockPos pos, int ripeningTime) {
        float stage = this.getRipeningStage(ripeningTime);
        return this.getColour(stage);
    }

    private int getColour(float stage) {
        int r = (this.colourCallow >> 16 & 0xFF) + (int)((float)this.diffR * stage);
        int g = (this.colourCallow >> 8 & 0xFF) + (int)((float)this.diffG * stage);
        int b = (this.colourCallow & 0xFF) + (int)((float)this.diffB * stage);
        return (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF;
    }

    @Override
    public int getDecorativeColor() {
        return this.getColour(1.0f);
    }
}

