/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.commands;

import forestry.api.arboriculture.IAlleleTreeSpecies;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.arboriculture.commands.ITreeSpawner;
import forestry.core.commands.CommandHelpers;
import forestry.core.commands.SpeciesNotFoundException;
import forestry.core.commands.SubCommand;
import forestry.core.commands.TemplateNotFoundException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.PlayerNotFoundException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import org.apache.commons.lang3.StringUtils;

public final class CommandTreeSpawn
extends SubCommand {
    private final ITreeSpawner treeSpawner;

    public CommandTreeSpawn(String name, ITreeSpawner treeSpawner) {
        super(name);
        this.setPermLevel(SubCommand.PermLevel.ADMIN);
        this.treeSpawner = treeSpawner;
    }

    @Override
    public void executeSubCommand(MinecraftServer server, ICommandSender sender, String[] args) throws PlayerNotFoundException, SpeciesNotFoundException, TemplateNotFoundException {
        if (args.length < 1 || args.length > 2) {
            this.printHelp(sender);
            return;
        }
        if (sender instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)sender;
            String treeName = StringUtils.join((Object[])args, (String)" ");
            boolean success = this.treeSpawner.spawn(sender, treeName, player);
            if (!success) {
                this.printHelp(sender);
            }
        }
    }

    @Override
    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        if (args.length == 1) {
            List<String> tabCompletion = CommandHelpers.getListOfStringsMatchingLastWord(args, CommandTreeSpawn.getSpecies());
            tabCompletion.add("help");
            return tabCompletion;
        }
        return Collections.emptyList();
    }

    private static String[] getSpecies() {
        ArrayList<String> species = new ArrayList<String>();
        for (IAllele allele : AlleleManager.alleleRegistry.getRegisteredAlleles().values()) {
            if (!(allele instanceof IAlleleTreeSpecies)) continue;
            species.add(allele.getAlleleName().replaceAll("\\s", ""));
        }
        return species.toArray(new String[species.size()]);
    }
}

