/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.climate;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import forestry.api.climate.IClimateState;
import forestry.core.climate.ClimateManager;
import forestry.greenhouse.api.climate.IClimateContainer;
import forestry.greenhouse.api.climate.IClimateSourceOwner;
import forestry.greenhouse.api.climate.IGreenhouseClimateManager;
import forestry.greenhouse.api.greenhouse.GreenhouseManager;
import forestry.greenhouse.api.greenhouse.Position2D;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ClimateWorldManager {
    private final Cache<BlockPos, IClimateState> stateCache = CacheBuilder.newBuilder().expireAfterAccess(30L, TimeUnit.SECONDS).build();
    private final ClimateManager parent;
    private final Map<Position2D, Map<Integer, IClimateSourceOwner>> owners;

    public ClimateWorldManager(ClimateManager parent) {
        this.parent = parent;
        this.owners = new HashMap<Position2D, Map<Integer, IClimateSourceOwner>>();
    }

    public IClimateState getClimateState(World world, BlockPos pos) {
        IClimateState cacheState = (IClimateState)this.stateCache.getIfPresent((Object)pos);
        if (cacheState == null) {
            IClimateContainer container;
            IGreenhouseClimateManager climateSourceManager = GreenhouseManager.climateManager;
            if (climateSourceManager != null && (container = climateSourceManager.getContainer(world, pos)) != null) {
                cacheState = container.getState();
            }
            if (cacheState == null) {
                cacheState = this.parent.getBiomeState(world, pos);
            }
            this.stateCache.put((Object)pos, (Object)cacheState);
        }
        return cacheState;
    }
}

