/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.errors;

import forestry.api.core.ForestryAPI;
import forestry.api.core.IErrorState;
import forestry.core.render.TextureManagerForestry;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public enum EnumErrorCode implements IErrorState
{
    TOO_HOT("too_hot"),
    TOO_COLD("too_cold"),
    TOO_HUMID("too_humid"),
    TOO_ARID("too_arid", "invalid_biome"),
    IS_RAINING("is_raining"),
    NOT_GLOOMY("not_gloomy"),
    NOT_BRIGHT("not_lucid"),
    NOT_DAY("not_day"),
    NOT_NIGHT("not_night"),
    NO_FLOWER("no_flower"),
    NO_QUEEN("no_queen"),
    NO_DRONE("no_drone"),
    NO_SKY("no_sky"),
    NO_RESOURCE("no_resource"),
    NO_RESOURCE_INVENTORY("no_resource_inventory", "no_resource"),
    NO_RESOURCE_LIQUID("no_resource_liquid", "no_liquid"),
    NO_RECIPE("no_recipe"),
    NO_SPACE_INVENTORY("no_space"),
    NO_SPACE_TANK("no_space_tank"),
    NO_POWER("no_power"),
    NO_REDSTONE("no_redstone", "disabled"),
    DISABLED_BY_REDSTONE("disabled_redstone", "disabled"),
    NOT_DARK("not_dark", "not_gloomy"),
    NOT_RAINING("not_raining"),
    NO_RAIN_BIOME("no_rain_biome", "not_raining"),
    NO_SKY_RAIN_TANK("no_sky_rain_tank", "no_sky"),
    NO_HONEY("no_honey"),
    NO_SPECIMEN("no_specimen"),
    FORCED_COOLDOWN("forced_cooldown"),
    NO_FUEL("no_fuel"),
    NO_HEAT("no_heat"),
    NO_ENERGY_NET("no_energy_net"),
    NO_STAMPS("no_stamps"),
    NO_PAPER("no_paper"),
    NO_SUPPLIES("no_supplies", "no_resource"),
    NO_TRADE("no_trade", "no_resource"),
    NOT_ALPHANUMERIC("not_alpha_numeric"),
    NOT_UNIQUE("not_unique"),
    NOT_POST_PAID("not_postpaid", "no_stamps"),
    NO_RECIPIENT("no_recipient"),
    NO_CIRCUIT_BOARD("no_circuit_board"),
    NO_CIRCUIT_LAYOUT("no_circuit_layout"),
    CIRCUIT_MISMATCH("circuit_mismatch"),
    NO_FERTILIZER("no_fertilizer"),
    NO_FARMLAND("no_farmland"),
    NO_LIQUID_FARM("no_liquid"),
    NOT_LOADED("not_loaded"),
    NOT_CLOSED("not_closed"),
    TOO_LARGE("too_large");

    private final String name;
    private final String iconName;
    @SideOnly(value=Side.CLIENT)
    private TextureAtlasSprite texture;

    private EnumErrorCode(String name) {
        this(name, name);
    }

    private EnumErrorCode(String name, String iconName) {
        this.name = name;
        this.iconName = iconName;
    }

    @Override
    public String getUnlocalizedDescription() {
        return "for.errors." + this.name + ".desc";
    }

    @Override
    public String getUnlocalizedHelp() {
        return "for.errors." + this.name + ".help";
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerSprite() {
        ResourceLocation location = new ResourceLocation("forestry", "gui/errors/" + this.iconName);
        this.texture = TextureManagerForestry.getInstance().registerGuiSprite(location);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getSprite() {
        return this.texture;
    }

    @Override
    public short getID() {
        return (short)this.ordinal();
    }

    @Override
    public String getUniqueName() {
        return "forestry:" + this.name;
    }

    public static void init() {
        for (EnumErrorCode code : EnumErrorCode.values()) {
            ForestryAPI.errorStateRegistry.registerErrorState(code);
        }
    }
}

