/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui.elements;

import forestry.api.core.IGuiElement;
import forestry.api.core.IGuiElementFactory;
import forestry.api.core.IGuiElementHelper;
import forestry.api.core.IGuiElementLayout;
import forestry.api.genetics.EnumTolerance;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IAlleleInteger;
import forestry.api.genetics.IAlleleSpecies;
import forestry.api.genetics.IAlleleTolerance;
import forestry.api.genetics.IAlyzerPlugin;
import forestry.api.genetics.IBreedingTracker;
import forestry.api.genetics.IMutation;
import forestry.api.genetics.ISpeciesPlugin;
import forestry.api.genetics.ISpeciesRoot;
import forestry.core.genetics.mutations.EnumMutateChance;
import forestry.core.gui.Drawable;
import forestry.core.gui.elements.GuiElementDrawable;
import forestry.core.gui.elements.GuiElementHelper;
import forestry.core.gui.elements.GuiElementHorizontal;
import forestry.core.gui.elements.GuiElementItemStack;
import forestry.core.gui.elements.GuiElementPanel;
import forestry.core.gui.elements.GuiElementText;
import forestry.core.gui.elements.GuiElementVertical;
import forestry.core.render.ColourProperties;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class GuiElementFactory
implements IGuiElementFactory {
    public static final ResourceLocation TEXTURE = new ResourceLocation("forestry", "textures/gui/database_mutation_screen.png");
    public static final Drawable QUESTION_MARK = new Drawable(TEXTURE, 78, 240, 16, 16);
    public static final Drawable DOWN_SYMBOL = new Drawable(TEXTURE, 0, 247, 15, 9);
    public static final Drawable UP_SYMBOL = new Drawable(TEXTURE, 15, 247, 15, 9);
    public static final Drawable BOOTH_SYMBOL = new Drawable(TEXTURE, 30, 247, 15, 9);
    public static final Drawable NONE_SYMBOL = new Drawable(TEXTURE, 45, 247, 15, 9);
    public static final GuiElementFactory INSTANCE = new GuiElementFactory();

    private GuiElementFactory() {
    }

    @Override
    public IGuiElementHelper createHelper(IGuiElementLayout element) {
        return new GuiElementHelper(element);
    }

    @Override
    public IGuiElementLayout createVertical(int xPos, int yPos, int width) {
        return new GuiElementVertical(xPos, yPos, width);
    }

    @Override
    public IGuiElementLayout createHorizontal(int xPos, int yPos, int height) {
        return new GuiElementHorizontal(xPos, yPos, height);
    }

    @Override
    public IGuiElementLayout createPanel(int xPos, int yPos, int width, int height) {
        return new GuiElementPanel(xPos, yPos, width, height);
    }

    @Override
    public final int getColorCoding(boolean dominant) {
        if (dominant) {
            return ColourProperties.INSTANCE.get("gui.beealyzer.dominant");
        }
        return ColourProperties.INSTANCE.get("gui.beealyzer.recessive");
    }

    @Override
    public IGuiElement createFertilityInfo(IAlleleInteger fertilityAllele, int x, int texOffset) {
        String fertilityString = Integer.toString(fertilityAllele.getValue()) + " x";
        IGuiElementLayout layout = this.createHorizontal(x, 0, 0).setDistance(2);
        layout.addElement(new GuiElementText(0, 0, 12, fertilityString, this.getColorCoding(fertilityAllele.isDominant())));
        layout.addElement(new GuiElementDrawable(0, -1, new Drawable(TEXTURE, 60, 240 + texOffset, 12, 8)));
        return layout;
    }

    @Override
    public IGuiElement createToleranceInfo(IAlleleTolerance toleranceAllele, IAlleleSpecies species, String text) {
        IGuiElementLayout layout = this.createHorizontal(0, 0, 0).setDistance(0);
        layout.addElement(new GuiElementText(0, 0, 12, text, this.getColorCoding(species.isDominant())));
        layout.addElement(this.createToleranceInfo(toleranceAllele, 0));
        return layout;
    }

    private IGuiElementLayout createToleranceInfo(IAlleleTolerance toleranceAllele, int x) {
        int textColor = this.getColorCoding(toleranceAllele.isDominant());
        EnumTolerance tolerance = toleranceAllele.getValue();
        String text = "(" + toleranceAllele.getAlleleName() + ")";
        IGuiElementLayout layout = this.createHorizontal(x, 0, 0).setDistance(2);
        switch (tolerance) {
            case BOTH_1: 
            case BOTH_2: 
            case BOTH_3: 
            case BOTH_4: 
            case BOTH_5: {
                layout.addElement(GuiElementFactory.createBothSymbol(0, -1));
                layout.addElement(new GuiElementText(0, 0, 12, text, textColor));
                break;
            }
            case DOWN_1: 
            case DOWN_2: 
            case DOWN_3: 
            case DOWN_4: 
            case DOWN_5: {
                layout.addElement(GuiElementFactory.createDownSymbol(0, -1));
                layout.addElement(new GuiElementText(0, 0, 12, text, textColor));
                break;
            }
            case UP_1: 
            case UP_2: 
            case UP_3: 
            case UP_4: 
            case UP_5: {
                layout.addElement(GuiElementFactory.createUpSymbol(0, -1));
                layout.addElement(new GuiElementText(0, 0, 12, text, textColor));
                break;
            }
            default: {
                layout.addElement(GuiElementFactory.createNoneSymbol(0, -1));
                layout.addElement(new GuiElementText(0, 0, 12, "(0)", textColor));
            }
        }
        return layout;
    }

    @Override
    public IGuiElementLayout createMutationResultant(int x, int y, int width, int height, IMutation mutation, IBreedingTracker breedingTracker) {
        if (breedingTracker.isDiscovered(mutation)) {
            GuiElementPanel element = new GuiElementPanel(x, y, width, height);
            IAlyzerPlugin plugin = mutation.getRoot().getAlyzerPlugin();
            Map<String, ItemStack> iconStacks = plugin.getIconStacks();
            ItemStack firstPartner = iconStacks.get(mutation.getAllele0().getUID());
            ItemStack secondPartner = iconStacks.get(mutation.getAllele1().getUID());
            element.addElements(new GuiElementItemStack(0, 0, firstPartner), GuiElementFactory.createProbabilityAdd(mutation, 21, 4), new GuiElementItemStack(33, 0, secondPartner));
            return element;
        }
        if (mutation.isSecret()) {
            return null;
        }
        return GuiElementFactory.createUnknownMutationGroup(x, y, width, height, mutation);
    }

    @Override
    public IGuiElementLayout createMutation(int x, int y, int width, int height, IMutation mutation, IAllele species, IBreedingTracker breedingTracker) {
        if (breedingTracker.isDiscovered(mutation)) {
            GuiElementPanel element = new GuiElementPanel(x, y, width, height);
            ISpeciesRoot speciesRoot = mutation.getRoot();
            int speciesIndex = speciesRoot.getSpeciesChromosomeType().ordinal();
            ISpeciesPlugin plugin = mutation.getRoot().getSpeciesPlugin();
            Map<String, ItemStack> iconStacks = plugin.getIndividualStacks();
            ItemStack partner = iconStacks.get(mutation.getPartner(species).getUID());
            IAllele resultAllele = mutation.getTemplate()[speciesIndex];
            ItemStack result = iconStacks.get(resultAllele.getUID());
            element.addElements(new IGuiElement[]{new GuiElementItemStack(0, 0, partner), new GuiElementItemStack(33, 0, result)});
            element.addElements(GuiElementFactory.createProbabilityArrow(mutation, 18, 4, breedingTracker));
            return element;
        }
        if (mutation.isSecret()) {
            return null;
        }
        return GuiElementFactory.createUnknownMutationGroup(x, y, width, height, mutation, breedingTracker);
    }

    private static IGuiElementLayout createUnknownMutationGroup(int x, int y, int width, int height, IMutation mutation) {
        GuiElementPanel element = new GuiElementPanel(x, y, width, height);
        element.addElements(new IGuiElement[]{GuiElementFactory.createQuestionMark(0, 0), GuiElementFactory.createProbabilityAdd(mutation, 21, 4), GuiElementFactory.createQuestionMark(32, 0)});
        return element;
    }

    private static IGuiElementLayout createUnknownMutationGroup(int x, int y, int width, int height, IMutation mutation, IBreedingTracker breedingTracker) {
        GuiElementPanel element = new GuiElementPanel(x, y, width, height);
        element.addElements(new IGuiElement[]{GuiElementFactory.createQuestionMark(0, 0), GuiElementFactory.createQuestionMark(32, 0)});
        element.addElements(GuiElementFactory.createProbabilityArrow(mutation, 18, 4, breedingTracker));
        return element;
    }

    private static Collection<IGuiElement> createProbabilityArrow(IMutation combination, int x, int y, IBreedingTracker breedingTracker) {
        float chance = combination.getBaseChance();
        int line = 247;
        int column = 100;
        switch (EnumMutateChance.rateChance(chance)) {
            case HIGHEST: {
                column = 100;
                break;
            }
            case HIGHER: {
                column = 115;
                break;
            }
            case HIGH: {
                column = 130;
                break;
            }
            case NORMAL: {
                column = 145;
                break;
            }
            case LOW: {
                column = 160;
                break;
            }
            case LOWEST: {
                column = 175;
            }
        }
        ArrayList<IGuiElement> elements = new ArrayList<IGuiElement>();
        elements.add(new GuiElementDrawable(x, y, new Drawable(TEXTURE, column, line, 15, 9)));
        boolean researched = breedingTracker.isResearched(combination);
        if (researched) {
            elements.add(new GuiElementText(x + 9, y + 1, 10, 10, "+"));
        }
        return elements;
    }

    private static GuiElementDrawable createProbabilityAdd(IMutation mutation, int x, int y) {
        float chance = mutation.getBaseChance();
        int line = 247;
        int column = 190;
        switch (EnumMutateChance.rateChance(chance)) {
            case HIGHEST: {
                column = 190;
                break;
            }
            case HIGHER: {
                column = 199;
                break;
            }
            case HIGH: {
                column = 208;
                break;
            }
            case NORMAL: {
                column = 217;
                break;
            }
            case LOW: {
                column = 226;
                break;
            }
            case LOWEST: {
                column = 235;
            }
        }
        return new GuiElementDrawable(x, y, new Drawable(TEXTURE, column, line, 9, 9));
    }

    private static GuiElementDrawable createQuestionMark(int x, int y) {
        return new GuiElementDrawable(x, y, QUESTION_MARK);
    }

    private static GuiElementDrawable createDownSymbol(int x, int y) {
        return new GuiElementDrawable(x, y, DOWN_SYMBOL);
    }

    private static GuiElementDrawable createUpSymbol(int x, int y) {
        return new GuiElementDrawable(x, y, UP_SYMBOL);
    }

    private static GuiElementDrawable createBothSymbol(int x, int y) {
        return new GuiElementDrawable(x, y, BOOTH_SYMBOL);
    }

    private static GuiElementDrawable createNoneSymbol(int x, int y) {
        return new GuiElementDrawable(x, y, NONE_SYMBOL);
    }
}

