/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui.elements;

import com.google.common.collect.Lists;
import forestry.api.core.IGuiElement;
import forestry.core.gui.elements.GuiElementVertical;
import forestry.core.gui.widgets.IScrollable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class GuiElementScrollable
extends GuiElementVertical
implements IScrollable {
    protected final List<IGuiElement> visibleElements = new ArrayList<IGuiElement>();
    protected final int sizeX;
    protected int elementOffset;

    public GuiElementScrollable(int xPos, int yPos, int width, int height) {
        super(xPos, yPos, width);
        this.sizeX = height;
    }

    public void updateVisibleElements(int offset) {
        this.visibleElements.clear();
        int height = 0;
        int widgetEnd = this.yPos + this.sizeX;
        for (int i = 0; i < this.elements.size(); ++i) {
            IGuiElement element = (IGuiElement)this.elements.get(i);
            if (i < offset) {
                height += element.getHeight();
                continue;
            }
            this.elementOffset = -height;
            int elementHeight = element.getY() + element.getHeight() + this.elementOffset;
            if (elementHeight > widgetEnd) continue;
            this.visibleElements.add(element);
        }
    }

    public int getInvisibleElementCount() {
        int count = 0;
        int widgetEnd = this.yPos + this.sizeX;
        for (int i = 0; i < this.elements.size(); ++i) {
            IGuiElement element = (IGuiElement)this.elements.get(i);
            int elementHeight = element.getY() + element.getHeight();
            if (elementHeight <= widgetEnd) continue;
            ++count;
        }
        return count;
    }

    @Override
    public void draw(int startX, int startY) {
        for (IGuiElement element : this.visibleElements) {
            element.draw(startX + this.getX(), startY + this.getY() + this.elementOffset);
        }
    }

    @Override
    public List<String> getToolTip(int mouseX, int mouseY) {
        mouseY -= this.getY() + this.elementOffset;
        mouseX -= this.getX();
        for (IGuiElement element : this.visibleElements) {
            List<String> toolTip;
            if (!element.isMouseOver(mouseX, mouseY) || (toolTip = element.getToolTip(mouseX, mouseY)).isEmpty()) continue;
            return toolTip;
        }
        return Collections.emptyList();
    }

    @Override
    public void onScroll(int value) {
        this.updateVisibleElements(value);
    }

    public void clear() {
        this.removeElements(Lists.newArrayList((Iterable)this.elements));
    }

    @Override
    public boolean isFocused(int mouseX, int mouseY) {
        return this.isMouseOver(mouseX, mouseY);
    }

    @Override
    public int getHeight() {
        return this.sizeX;
    }
}

