/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui.slots;

import com.google.common.collect.Lists;
import forestry.factory.inventory.InventoryCraftingForestry;
import forestry.factory.tiles.ICrafterWorktable;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class SlotCrafter
extends Slot {
    private final InventoryCraftingForestry craftMatrix;
    private final ICrafterWorktable crafter;
    private final EntityPlayer player;
    private int amountCrafted;

    public SlotCrafter(EntityPlayer player, InventoryCraftingForestry craftMatrix, IInventory craftingDisplay, ICrafterWorktable crafter, int slot, int xPos, int yPos) {
        super(craftingDisplay, slot, xPos, yPos);
        this.craftMatrix = craftMatrix;
        this.crafter = crafter;
        this.player = player;
    }

    public boolean func_75214_a(ItemStack stack) {
        return false;
    }

    protected void func_75210_a(ItemStack stack, int amount) {
        this.amountCrafted += amount;
        this.func_75208_c(stack);
    }

    protected void func_75208_c(ItemStack stack) {
        if (this.amountCrafted > 0) {
            stack.func_77980_a(this.player.field_70170_p, this.player, this.amountCrafted);
            FMLCommonHandler.instance().firePlayerCraftingEvent(this.player, stack, (IInventory)this.craftMatrix);
        }
        this.amountCrafted = 0;
        IRecipe irecipe = this.crafter.getRecipeUsed();
        if (irecipe != null && !irecipe.func_192399_d()) {
            this.player.func_192021_a((List)Lists.newArrayList((Object[])new IRecipe[]{irecipe}));
        }
    }

    public ItemStack func_75209_a(int amount) {
        if (!this.func_75216_d()) {
            return ItemStack.field_190927_a;
        }
        return this.func_75211_c();
    }

    public boolean func_82869_a(EntityPlayer player) {
        return this.crafter.canTakeStack(this.getSlotIndex());
    }

    public ItemStack func_75211_c() {
        return this.crafter.getResult(this.craftMatrix, this.player.field_70170_p);
    }

    public boolean func_75216_d() {
        return !this.func_75211_c().func_190926_b() && this.crafter.canTakeStack(this.getSlotIndex());
    }

    public ItemStack func_190901_a(EntityPlayer player, ItemStack itemStack) {
        if (this.crafter.onCraftingStart(player)) {
            this.func_75208_c(itemStack);
            this.crafter.onCraftingComplete(player);
        }
        return itemStack;
    }
}

