/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.network.packets;

import forestry.core.network.ForestryPacket;
import forestry.core.network.IForestryPacketClient;
import forestry.core.network.IForestryPacketHandlerClient;
import forestry.core.network.PacketBufferForestry;
import forestry.core.network.PacketIdClient;
import forestry.core.tiles.IItemStackDisplay;
import forestry.core.tiles.TileForestry;
import forestry.core.tiles.TileUtil;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PacketItemStackDisplay
extends ForestryPacket
implements IForestryPacketClient {
    private final BlockPos pos;
    private final ItemStack itemStack;

    public <T extends TileForestry> PacketItemStackDisplay(T tile, ItemStack itemStack) {
        this.pos = tile.func_174877_v();
        this.itemStack = itemStack;
    }

    @Override
    protected void writeData(PacketBufferForestry data) throws IOException {
        data.func_179255_a(this.pos);
        data.func_150788_a(this.itemStack);
    }

    @Override
    public PacketIdClient getPacketId() {
        return PacketIdClient.ITEMSTACK_DISPLAY;
    }

    @SideOnly(value=Side.CLIENT)
    public static class Handler
    implements IForestryPacketHandlerClient {
        @Override
        public void onPacketData(PacketBufferForestry data, EntityPlayer player) throws IOException {
            BlockPos pos = data.func_179259_c();
            ItemStack itemStack = data.func_150791_c();
            TileUtil.actOnTile((IBlockAccess)player.field_70170_p, pos, IItemStackDisplay.class, tile -> tile.handleItemStackForDisplay(itemStack));
        }
    }
}

