/*
 * Decompiled with CFR 0.152.
 */
package forestry.database;

import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IDatabaseTab;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.ISpeciesPlugin;
import forestry.api.genetics.ISpeciesRoot;
import forestry.database.DatabaseTab;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;

public class DatabaseScreenLogic {
    @Nullable
    public ISpeciesRoot speciesRoot;
    @Nullable
    public ISpeciesPlugin databasePlugin;
    @Nullable
    public IIndividual individual;
    public ItemStack itemStack = ItemStack.field_190927_a;
    @Nullable
    public IDatabaseTab selectedTab;
    public IDatabaseTab[] tabs = new IDatabaseTab[4];

    public ScreenState onTabChange(IDatabaseTab selectedTab) {
        if (this.individual == null) {
            return ScreenState.NO_INDIVIDUAL;
        }
        if (!this.individual.isAnalyzed()) {
            return ScreenState.NOT_ANALYZED;
        }
        if (this.selectedTab == selectedTab) {
            return ScreenState.SUCCESS;
        }
        this.selectedTab = selectedTab;
        return ScreenState.SUCCESS;
    }

    public ScreenState onItemChange(ItemStack itemStack) {
        ISpeciesRoot speciesRoot = AlleleManager.alleleRegistry.getSpeciesRoot(itemStack);
        if (speciesRoot == null) {
            return ScreenState.NO_INDIVIDUAL;
        }
        IIndividual individual = speciesRoot.getMember(itemStack);
        if (individual == null) {
            this.individual = null;
            this.itemStack = ItemStack.field_190927_a;
            return ScreenState.NO_INDIVIDUAL;
        }
        if (!individual.isAnalyzed()) {
            this.individual = null;
            this.itemStack = ItemStack.field_190927_a;
            return ScreenState.NOT_ANALYZED;
        }
        this.individual = individual;
        this.itemStack = itemStack;
        if (speciesRoot != this.speciesRoot) {
            IDatabaseTab[] tabs = this.getTabs(speciesRoot);
            if (tabs == null) {
                this.tabs = new IDatabaseTab[4];
                return ScreenState.NO_PLUGIN;
            }
            this.tabs = tabs;
            this.onTabChange(tabs[0]);
        } else {
            this.onTabChange(this.selectedTab);
        }
        this.speciesRoot = speciesRoot;
        return ScreenState.SUCCESS;
    }

    private IDatabaseTab[] getTabs(ISpeciesRoot speciesRoot) {
        ISpeciesPlugin databasePlugin = speciesRoot.getSpeciesPlugin();
        if (databasePlugin == null) {
            return null;
        }
        this.databasePlugin = databasePlugin;
        IDatabaseTab[] tabs = new IDatabaseTab[4];
        IDatabaseTab speciesTab = databasePlugin.getSpeciesTab(true);
        if (speciesTab == null) {
            return null;
        }
        DatabaseTab productsTab = databasePlugin.getProductsTab();
        DatabaseTab mutationTab = databasePlugin.getMutationTab();
        if (productsTab == null) {
            productsTab = DatabaseTab.PRODUCTS;
        }
        if (mutationTab == null) {
            mutationTab = DatabaseTab.MUTATIONS;
        }
        tabs[0] = speciesTab;
        tabs[1] = databasePlugin.getSpeciesTab(false);
        tabs[2] = productsTab;
        tabs[3] = mutationTab;
        return tabs;
    }

    public static enum ScreenState {
        NO_INDIVIDUAL,
        NOT_ANALYZED,
        NO_PLUGIN,
        SUCCESS;

    }
}

