/*
 * Decompiled with CFR 0.152.
 */
package forestry.database.gui;

import forestry.core.gui.Drawable;
import forestry.core.gui.GuiForestry;
import forestry.core.gui.slots.SlotFilteredInventory;
import forestry.core.gui.widgets.IScrollable;
import forestry.core.gui.widgets.Widget;
import forestry.core.gui.widgets.WidgetScrollBar;
import forestry.core.inventory.watchers.ISlotChangeWatcher;
import forestry.core.network.packets.PacketGuiSelectRequest;
import forestry.core.render.ColourProperties;
import forestry.core.utils.NetworkUtil;
import forestry.core.utils.Translator;
import forestry.database.DatabaseHelper;
import forestry.database.DatabaseItem;
import forestry.database.DatabaseManager;
import forestry.database.gui.ContainerDatabase;
import forestry.database.gui.buttons.DatabaseButton;
import forestry.database.gui.buttons.GuiDatabaseButton;
import forestry.database.gui.widgets.WidgetDatabaseScreen;
import forestry.database.gui.widgets.WidgetDatabaseSelectedItem;
import forestry.database.gui.widgets.WidgetDatabaseSlot;
import forestry.database.gui.widgets.WidgetDatabaseTabs;
import forestry.database.tiles.TileDatabase;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.util.ResourceLocation;

public class GuiDatabase
extends GuiForestry<ContainerDatabase>
implements ISlotChangeWatcher,
IScrollable {
    private static final int SLOTS = 24;
    public final TileDatabase database;
    private final ArrayList<WidgetDatabaseSlot> slots;
    private final DatabaseManager manager;
    private GuiTextField searchField;
    private GuiDatabaseButton lockButton;
    private GuiDatabaseButton upButton;
    private GuiDatabaseButton downButton;
    private WidgetDatabaseScreen databaseScreen;
    private WidgetScrollBar scrollBar;

    public GuiDatabase(TileDatabase database, EntityPlayer player) {
        super("textures/gui/database_inventory.png", new ContainerDatabase(database, player.field_71071_by));
        this.database = database;
        this.slots = new ArrayList();
        this.field_146999_f = 218;
        this.field_147000_g = 202;
        this.manager = new DatabaseManager(database, this);
        for (Object slot : ((ContainerDatabase)this.container).field_75151_b) {
            if (!(slot instanceof SlotFilteredInventory)) continue;
            SlotFilteredInventory slotDatabase = (SlotFilteredInventory)slot;
            slotDatabase.setChangeWatcher(this);
        }
        for (int i = 0; i < 24; ++i) {
            Object slot;
            slot = new WidgetDatabaseSlot(this.widgetManager);
            this.slots.add((WidgetDatabaseSlot)slot);
            this.widgetManager.add((Widget)slot);
        }
        int screenX = -140;
        WidgetScrollBar scrollBar = new WidgetScrollBar(this.widgetManager, screenX + 106, 10, new Drawable(WidgetDatabaseScreen.TEXTURE, 202, 0, 3, 156), false, new Drawable(WidgetDatabaseScreen.TEXTURE, 205, 0, 3, 5));
        this.databaseScreen = new WidgetDatabaseScreen(this.widgetManager, screenX, 0, scrollBar);
        this.widgetManager.add(this.databaseScreen);
        this.widgetManager.add(scrollBar);
        this.widgetManager.add(new WidgetDatabaseTabs(this.widgetManager, screenX, 177, this.databaseScreen));
        this.scrollBar = new WidgetScrollBar(this.widgetManager, 196, 19, 12, 90, new Drawable(new ResourceLocation("textures/gui/container/creative_inventory/tabs.png"), 232, 0, 12, 15));
        this.widgetManager.add(this.scrollBar);
        this.scrollBar.setParameters(this, 0, database.func_70302_i_() / 4 - 6, 1);
        this.widgetManager.add(new WidgetDatabaseSelectedItem(this.widgetManager, 184, 158, this.manager));
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        String searchText = this.searchField != null ? this.searchField.func_146179_b() : "";
        this.manager.update(searchText);
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }

    @Override
    protected void func_146976_a(float f, int mouseX, int mouseY) {
        super.func_146976_a(f, mouseX, mouseY);
        String name = Translator.translateToLocal(this.database.getUnlocalizedTitle());
        this.textLayout.line = 6;
        this.textLayout.drawLine(name, 8, ColourProperties.INSTANCE.get("gui.title"));
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179140_f();
        this.searchField.func_146194_f();
    }

    @Override
    protected void drawBackground() {
        this.bindTexture(this.textureFile);
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (this.searchField.func_146201_a(typedChar, keyCode)) {
            this.scrollBar.setValue(0);
            this.manager.markForSorting();
        } else if ((keyCode == 208 || keyCode == 205) && this.downButton.field_146124_l) {
            this.downButton.onPressed();
        } else if ((keyCode == 200 || keyCode == 203) && this.upButton.field_146124_l) {
            this.upButton.onPressed();
        } else {
            super.func_73869_a(typedChar, keyCode);
        }
    }

    @Override
    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        Slot slot = this.func_146975_c(mouseX, mouseY);
        if (slot != null && slot.getSlotIndex() == -1) {
            return;
        }
        super.func_73864_a(mouseX, mouseY, mouseButton);
        this.searchField.func_146192_a(mouseX, mouseY, mouseButton);
    }

    @Nullable
    public DatabaseItem getItem(int index) {
        return this.manager.getItem(index);
    }

    @Nullable
    public DatabaseItem getSelectedItem() {
        return this.manager.getSelected();
    }

    public DatabaseManager getManager() {
        return this.manager;
    }

    public void onSortItems(List<DatabaseItem> sorted) {
        this.updateViewedItems(sorted);
    }

    public void onChangeLockState(boolean locked) {
        this.lockButton.setValue(locked);
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_147003_i = 140 + (this.field_146294_l - this.field_146999_f - 125) / 2;
        this.searchField = new GuiTextField(0, this.field_146289_q, this.field_147003_i + 101, this.field_147009_r + 6, 80, this.field_146289_q.field_78288_b);
        this.searchField.func_146203_f(50);
        this.searchField.func_146185_a(false);
        this.searchField.func_146193_g(0xFFFFFF);
        this.field_146292_n.add(new GuiDatabaseButton<Boolean>(0, this.field_147003_i - 18, this.field_147009_r, DatabaseHelper.ascending, this.manager, DatabaseButton.SORT_DIRECTION_BUTTON));
        this.upButton = new GuiDatabaseButton<String>(1, this.field_147003_i + 184, this.field_147009_r + 144, "", this.manager, DatabaseButton.SELECTED_UP);
        this.field_146292_n.add(this.upButton);
        this.downButton = new GuiDatabaseButton<String>(2, this.field_147003_i + 184, this.field_147009_r + 178, "", this.manager, DatabaseButton.SELECTED_DOWN);
        this.field_146292_n.add(this.downButton);
        this.updateViewedItems();
    }

    public void onUpdateSelectedSlot(boolean changed) {
        this.upButton.field_146124_l = this.manager.canSubtract();
        this.downButton.field_146124_l = this.manager.canAdd();
        if (changed) {
            int index = this.getSelectedItem().invIndex;
            this.database.selectedSlot = this.manager.getSelectedSlot();
            NetworkUtil.sendToServer(new PacketGuiSelectRequest(0, index));
            this.databaseScreen.onItemChange(this.manager.getSelectedItemStack());
        }
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        if (button instanceof GuiDatabaseButton) {
            GuiDatabaseButton databaseButton = (GuiDatabaseButton)button;
            databaseButton.onPressed();
        }
    }

    @Override
    protected void addLedgers() {
    }

    @Override
    public void onScroll(int value) {
        this.updateViewedItems();
    }

    @Override
    public boolean isFocused(int mouseX, int mouseY) {
        return this.func_146978_c(0, 0, this.field_146999_f, this.field_147000_g, mouseX + this.field_147003_i, mouseY + this.field_147009_r);
    }

    protected boolean func_193983_c(int mouseX, int mouseY, int guiLeft, int guiTop) {
        boolean isInsideScreen = this.databaseScreen.isMouseOver(mouseX - guiLeft, mouseY - guiTop);
        return super.func_193983_c(mouseX, mouseY, guiLeft, guiTop) && !isInsideScreen;
    }

    @Override
    public void onSlotChanged(IInventory inventory, int slot) {
        if (this.manager.getSelected() != null && slot == this.manager.getSelected().invIndex) {
            this.databaseScreen.onItemChange(this.manager.getSelectedItemStack());
        }
        this.manager.markForSorting();
    }

    public void updateViewedItems() {
        this.updateViewedItems(this.manager.getSorted());
    }

    public void updateViewedItems(List<DatabaseItem> sorted) {
        int currentRow = this.scrollBar.getValue();
        if (currentRow < 0) {
            currentRow = 0;
        }
        int slotStart = currentRow * 4;
        int slotEnd = (currentRow + 6) * 4;
        if (slotEnd > this.database.func_70302_i_()) {
            slotEnd = this.database.func_70302_i_();
        }
        byte startRow = (byte)(currentRow % 2);
        int emptySlot = sorted.size() - 1;
        for (int invIndex = 0; invIndex < this.database.func_70302_i_(); ++invIndex) {
            int xOffset;
            int yOffset;
            if (invIndex < slotStart || invIndex >= slotEnd) continue;
            int x = invIndex % 4;
            int y = invIndex / 4 - currentRow;
            if (startRow == 0) {
                yOffset = 25;
                xOffset = 17;
                if (y % 2 == 1) {
                    xOffset = 38;
                    yOffset = 38;
                    --y;
                }
            } else {
                yOffset = 25;
                xOffset = 38;
                if (y % 2 == 1) {
                    yOffset = 38;
                    xOffset = 17;
                    --y;
                }
            }
            int xPos = xOffset + x * 42;
            int yPos = yOffset + y / 2 * 25;
            int index = invIndex;
            if (sorted.size() <= index || sorted.isEmpty()) {
                index = emptySlot;
            }
            WidgetDatabaseSlot slot = this.slots.get(invIndex - slotStart);
            slot.update(xPos, yPos, index, index != emptySlot);
        }
        if (!sorted.isEmpty() && this.databaseScreen.size() == 0) {
            this.databaseScreen.onItemChange(this.manager.getSelectedItemStack());
            if (this.database.selectedSlot != -1) {
                this.manager.setSelectedSlot(this.database.selectedSlot);
            }
        }
    }
}

